/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.kc.link.rest;

import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import io.jans.configapi.core.rest.BaseResource;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.plugin.kc.link.service.KcLinkConfigService;
import io.jans.keycloak.link.model.config.AppConfiguration;
import io.jans.keycloak.link.model.config.Conf;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.slf4j.Logger;

@Path(value="/kcLinkConfig")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class KcLinkConfigResource
extends BaseResource {
    @Inject
    Logger logger;
    @Inject
    KcLinkConfigService kcLinkConfigService;

    @Operation(summary="Gets KC Link configuration properties", description="Gets KC Link configuration properties", operationId="get-kc-link-properties", tags={"KC Link - Configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/kc-link-config.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/kc-link-config.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/kc-link.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppConfiguration.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/kc-link-config.readonly"}, groupScopes={"https://jans.io/oauth/kc-link-config.write"}, superScopes={"https://jans.io/oauth/config/kc-link.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    public Response getkcLinkConf() {
        AppConfiguration kcLinkConfiguration = this.kcLinkConfigService.find();
        this.logger.info("KC Link details kcLinkConfiguration():{}", (Object)kcLinkConfiguration);
        if (kcLinkConfiguration == null) {
            KcLinkConfigResource.throwInternalServerException((String)"It seems Kc Link module is not setup, kindly check.");
        }
        return Response.ok((Object)kcLinkConfiguration).build();
    }

    @Operation(summary="Update KC Link configuration properties", description="Update KC Link configuration properties", operationId="put-kc-link-properties", tags={"KC Link - Configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/kc-link-config.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/kc-link.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="GluuAttribute object", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppConfiguration.class), examples={@ExampleObject(name="Request example", value="example/kc-link/config/kc-link-put.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppConfiguration.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PUT
    @ProtectedApi(scopes={"https://jans.io/oauth/kc-link-config.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/kc-link.admin", "https://jans.io/oauth/config/write-all"})
    public Response updatekcLinkConf(@Valid AppConfiguration kcLinkAppConf) {
        this.logger.info("Update KC Link conf details kcLinkAppConf():{}", (Object)kcLinkAppConf);
        Conf conf = this.kcLinkConfigService.findKcLinkConf();
        this.logger.info("KC Link conf:{} ", (Object)conf);
        if (conf == null) {
            KcLinkConfigResource.throwInternalServerException((String)"It seems Kc Link module is not setup, kindly check.");
        }
        conf.setDynamic(kcLinkAppConf);
        this.kcLinkConfigService.mergeKcLinkConfig(conf);
        kcLinkAppConf = this.kcLinkConfigService.find();
        this.logger.info("KC Link conf, post update - kcLinkAppConf:{}", (Object)kcLinkAppConf);
        return Response.ok((Object)kcLinkAppConf).build();
    }

    @Operation(summary="Partially modifies KC Link configuration properties.", description="Partially modifies KC Link configuration properties.", operationId="patch-kc-link-properties", tags={"KC Link - Configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/kc-link-config.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/kc-link.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="String representing patch-document.", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=JsonPatch.class)), examples={@ExampleObject(name="Request json example", value="example/kc-link/config/kc-link-patch.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppConfiguration.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/kc-link-config.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/kc-link.admin", "https://jans.io/oauth/config/write-all"})
    public Response patchkcLinkConf(@NotNull String jsonPatchString) throws JsonPatchException, IOException {
        this.logger.info("KC Link Config - jsonPatchString:{} ", (Object)jsonPatchString);
        Conf conf = this.kcLinkConfigService.findKcLinkConf();
        this.logger.info("KC Link conf:{} ", (Object)conf);
        if (conf == null) {
            KcLinkConfigResource.throwInternalServerException((String)"It seems Kc Link module is not setup, kindly check.");
        }
        AppConfiguration kcLinkAppConf = (AppConfiguration)Jackson.applyPatch((String)jsonPatchString, (Object)conf.getDynamic());
        this.logger.info("KC Link conf details kcLinkAppConf():{}", (Object)kcLinkAppConf);
        conf.setDynamic(kcLinkAppConf);
        this.kcLinkConfigService.mergeKcLinkConfig(conf);
        kcLinkAppConf = this.kcLinkConfigService.find();
        this.logger.info("KC KC Link post patch - kcLinkAppConf:{}", (Object)kcLinkAppConf);
        return Response.ok((Object)kcLinkAppConf).build();
    }
}

