/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.persist;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.persist.AbstractConditionalLoadXMLObjectLoadSaveManager;
import org.opensaml.core.xml.util.XMLObjectSource;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class FilesystemLoadSaveManager<T extends XMLObject>
extends AbstractConditionalLoadXMLObjectLoadSaveManager<T> {
    private Logger log = LoggerFactory.getLogger(FilesystemLoadSaveManager.class);
    private File baseDirectory;
    private ParserPool parserPool;
    private FileFilter fileFilter;

    public FilesystemLoadSaveManager(@ParameterName(name="baseDir") @Nonnull String baseDir) {
        this(new File(Constraint.isNotNull(StringSupport.trimOrNull(baseDir), "Base directory string instance was null or empty")), null, false);
    }

    public FilesystemLoadSaveManager(@ParameterName(name="baseDir") @Nonnull String baseDir, @ParameterName(name="conditionalLoad") boolean conditionalLoad) {
        this(new File(Constraint.isNotNull(StringSupport.trimOrNull(baseDir), "Base directory string instance was null or empty")), null, conditionalLoad);
    }

    public FilesystemLoadSaveManager(@ParameterName(name="baseDirFile") @Nonnull File baseDir) {
        this(baseDir, null, false);
    }

    public FilesystemLoadSaveManager(@ParameterName(name="baseDirFile") @Nonnull File baseDir, @ParameterName(name="conditionalLoad") boolean conditionalLoad) {
        this(baseDir, null, conditionalLoad);
    }

    public FilesystemLoadSaveManager(@ParameterName(name="baseDir") @Nonnull String baseDir, @ParameterName(name="parserPool") @Nullable ParserPool pp) {
        this(new File(Constraint.isNotNull(StringSupport.trimOrNull(baseDir), "Base directory string instance was null or empty")), pp, false);
    }

    public FilesystemLoadSaveManager(@ParameterName(name="baseDir") @Nonnull String baseDir, @ParameterName(name="parserPool") @Nullable ParserPool pp, @ParameterName(name="conditionalLoad") boolean conditionalLoad) {
        this(new File(Constraint.isNotNull(StringSupport.trimOrNull(baseDir), "Base directory string instance was null or empty")), pp, conditionalLoad);
    }

    public FilesystemLoadSaveManager(@ParameterName(name="baseDirFile") @Nonnull File baseDir, @ParameterName(name="parserPool") @Nullable ParserPool pp) {
        this(baseDir, pp, false);
    }

    public FilesystemLoadSaveManager(@ParameterName(name="baseDirFile") @Nonnull File baseDir, @ParameterName(name="parserPool") @Nullable ParserPool pp, @ParameterName(name="conditionalLoad") boolean conditionalLoad) {
        super(conditionalLoad);
        this.baseDirectory = Constraint.isNotNull(baseDir, "Base directory File instance was null");
        Constraint.isTrue(this.baseDirectory.isAbsolute(), "Base directory specified was not an absolute path");
        if (this.baseDirectory.exists()) {
            Constraint.isTrue(this.baseDirectory.isDirectory(), "Existing base directory path was not a directory");
        } else {
            Constraint.isTrue(this.baseDirectory.mkdirs(), "Base directory did not exist and could not be created");
        }
        this.parserPool = pp;
        if (this.parserPool == null) {
            this.parserPool = Constraint.isNotNull(XMLObjectProviderRegistrySupport.getParserPool(), "Specified ParserPool was null and global ParserPool was not available");
        }
        this.fileFilter = new DefaultFileFilter();
    }

    @Override
    public Set<String> listKeys() throws IOException {
        File[] files = this.baseDirectory.listFiles(this.fileFilter);
        HashSet<String> keys = new HashSet<String>();
        for (File file : files) {
            keys.add(file.getName());
        }
        return Collections.unmodifiableSet(keys);
    }

    @Override
    public Iterable<Pair<String, T>> listAll() throws IOException {
        return new FileIterable(this.listKeys());
    }

    @Override
    public boolean exists(String key) throws IOException {
        return this.buildFile(key).exists();
    }

    /*
     * Loose catch block
     */
    @Override
    public T load(String key) throws IOException {
        File file = this.buildFile(key);
        if (!file.exists()) {
            this.log.debug("Target file with key '{}' does not exist, path: {}", (Object)key, (Object)file.getAbsolutePath());
            this.clearLoadLastModified(key);
            return null;
        }
        if (this.isLoadConditionally() && this.isUnmodifiedSinceLastLoad(key)) {
            this.log.debug("Target file with key '{}' has not been modified since the last request, returning null: {}", (Object)key, (Object)file.getAbsolutePath());
            return null;
        }
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] source = ByteStreams.toByteArray((InputStream)fis);
            ByteArrayInputStream bais = new ByteArrayInputStream(source);
            XMLObject xmlObject = XMLObjectSupport.unmarshallFromInputStream(this.parserPool, bais);
            xmlObject.getObjectMetadata().put(new XMLObjectSource(source));
            this.updateLoadLastModified(key, Instant.ofEpochMilli(file.lastModified()));
            XMLObject xMLObject = xmlObject;
            bais.close();
            return (T)xMLObject;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            bais.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (XMLParserException | UnmarshallingException e) {
                        throw new IOException(String.format("Error loading file from path: %s", file.getAbsolutePath()), e);
                    }
                }
            }
        }
    }

    @Override
    protected synchronized boolean isUnmodifiedSinceLastLoad(@Nonnull String key) throws IOException {
        File file = this.buildFile(key);
        Instant lastModified = Instant.ofEpochMilli(file.lastModified());
        this.log.trace("File '{}' last modified was: {}", (Object)file.getAbsolutePath(), (Object)lastModified);
        return this.getLoadLastModified(key) != null && !lastModified.isAfter(this.getLoadLastModified(key));
    }

    @Override
    public void save(String key, T xmlObject) throws IOException {
        this.save(key, xmlObject, false);
    }

    @Override
    public void save(String key, T xmlObject, boolean overwrite) throws IOException {
        if (!overwrite && this.exists(key)) {
            throw new IOException(String.format("Target file already exists for key '%s' and overwrite not indicated", key));
        }
        File file = this.buildFile(key);
        try (FileOutputStream fos = new FileOutputStream(file);){
            List<XMLObjectSource> sources = xmlObject.getObjectMetadata().get(XMLObjectSource.class);
            if (sources.size() == 1) {
                this.log.debug("XMLObject contained 1 XMLObjectSource instance, persisting existing byte[]");
                XMLObjectSource source = sources.get(0);
                fos.write(source.getObjectSource());
            } else {
                this.log.debug("XMLObject contained {} XMLObjectSource instances, persisting marshalled object", (Object)sources.size());
                try {
                    XMLObjectSupport.marshallToOutputStream(xmlObject, fos);
                }
                catch (MarshallingException e) {
                    throw new IOException(String.format("Error saving target file: %s", file.getAbsolutePath()), e);
                }
            }
            fos.flush();
        }
    }

    @Override
    public boolean remove(String key) throws IOException {
        File file = this.buildFile(key);
        if (file.exists()) {
            boolean success = file.delete();
            if (success) {
                this.clearLoadLastModified(key);
                return true;
            }
            throw new IOException(String.format("Error removing target file: %s", file.getAbsolutePath()));
        }
        return false;
    }

    @Override
    public boolean updateKey(String currentKey, String newKey) throws IOException {
        File currentFile = this.buildFile(currentKey);
        if (!currentFile.exists()) {
            return false;
        }
        File newFile = this.buildFile(newKey);
        if (newFile.exists()) {
            throw new IOException(String.format("Specified new key already exists: %s", newKey));
        }
        Files.move((File)currentFile, (File)newFile);
        this.updateLoadLastModified(newKey, this.getLoadLastModified(currentKey));
        this.clearLoadLastModified(currentKey);
        return true;
    }

    protected File buildFile(String key) throws IOException {
        File path = new File(this.baseDirectory, Constraint.isNotNull(StringSupport.trimOrNull(key), "Input key was null or empty"));
        if (path.exists() && !path.isFile()) {
            throw new IOException(String.format("Path exists based on specified key, but is not a file: %s", path.getAbsolutePath()));
        }
        return path;
    }

    private class FileIterator
    implements Iterator<Pair<String, T>> {
        private Iterator<String> keysIter;
        private Pair<String, T> current;

        public FileIterator(Collection<String> filenames) {
            Set keys = filenames.stream().filter(s -> s != null).collect(Collectors.toSet());
            this.keysIter = keys.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.current != null) {
                return true;
            }
            this.current = this.getNext();
            return this.current != null;
        }

        @Override
        public Pair<String, T> next() {
            if (this.current != null) {
                Pair temp = this.current;
                this.current = null;
                return temp;
            }
            Pair temp = this.getNext();
            if (temp != null) {
                return temp;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Pair<String, T> getNext() {
            while (this.keysIter.hasNext()) {
                String key = this.keysIter.next();
                try {
                    Object xmlObject = FilesystemLoadSaveManager.this.load(key);
                    if (xmlObject != null) {
                        return new Pair(key, xmlObject);
                    }
                    FilesystemLoadSaveManager.this.log.warn("Target file with key '{}' was removed since iterator creation, skipping", (Object)key);
                }
                catch (IOException e) {
                    FilesystemLoadSaveManager.this.log.warn("Error loading target file with key '{}'", (Object)key, (Object)e);
                }
            }
            return null;
        }
    }

    private class FileIterable
    implements Iterable<Pair<String, T>> {
        private Set<String> keys;

        public FileIterable(Collection<String> filenames) {
            this.keys = filenames.stream().filter(s -> s != null).collect(Collectors.toSet());
        }

        @Override
        public Iterator<Pair<String, T>> iterator() {
            return new FileIterator(this.keys);
        }
    }

    public static class DefaultFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            if (pathname == null) {
                return false;
            }
            return pathname.isFile();
        }
    }
}

