/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.saml.configuration;

import io.jans.as.model.configuration.Configuration;
import io.jans.configapi.plugin.saml.model.config.SamlAppConfiguration;
import io.jans.configapi.plugin.saml.model.config.SamlConf;
import io.jans.exception.ConfigurationException;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.BasePersistenceException;
import io.jans.orm.service.PersistanceFactoryService;
import io.jans.orm.util.properties.FileConfiguration;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.BaseConfigurationReload;
import io.jans.service.cdi.event.ConfigurationEvent;
import io.jans.service.cdi.event.ConfigurationUpdate;
import io.jans.service.cdi.event.Scheduled;
import io.jans.service.timer.event.TimerEvent;
import io.jans.service.timer.schedule.TimerSchedule;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Alternative;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

@ApplicationScoped
@Alternative
@Priority(value=1)
public class SamlConfigurationFactory {
    public static final String SAML_CONFIGURATION_ENTRY_DN = "saml_ConfigurationEntryDN";
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    private Event<SamlAppConfiguration> samlConfigurationUpdateEvent;
    @Inject
    private Event<String> event;
    @Inject
    @Named(value="persistenceEntryManager")
    private Instance<PersistenceEntryManager> persistenceEntryManagerInstance;
    @Inject
    private PersistanceFactoryService persistanceFactoryService;
    @Inject
    private Instance<Configuration> configurationInstance;
    public static final String PERSISTENCE_CONFIGUARION_RELOAD_EVENT_TYPE = "persistenceConfigurationReloadEvent";
    public static final String SAML_BASE_CONFIGURATION_RELOAD_EVENT_TYPE = "saml_baseConfigurationReloadEvent";
    private static final int DEFAULT_INTERVAL = 30;
    private AtomicBoolean isActive;
    private long baseConfigurationFileLastModifiedTime;
    private static final String BASE_DIR = System.getProperty("jans.base") != null ? System.getProperty("jans.base") : (System.getProperty("catalina.base") != null && System.getProperty("catalina.base.ignore") == null ? System.getProperty("catalina.base") : (System.getProperty("catalina.home") != null ? System.getProperty("catalina.home") : (System.getProperty("jboss.home.dir") != null ? System.getProperty("jboss.home.dir") : null)));
    private static final String DIR = BASE_DIR + File.separator + "conf" + File.separator;
    private static final String BASE_PROPERTIES_FILE = DIR + "jans.properties";
    public static final String SAML_CONFIGURATION_ENTRY = "saml_ConfigurationEntryDN";
    private SamlAppConfiguration samlAppConfiguration;
    private boolean samlConfigLoaded = false;
    private long samlLoadedRevision = -1L;
    private FileConfiguration baseConfiguration;

    public String getSamlConfigurationDn() {
        return this.baseConfiguration.getString("saml_ConfigurationEntryDN");
    }

    public FileConfiguration getBaseConfiguration() {
        return this.baseConfiguration;
    }

    @PostConstruct
    public void init() {
        this.log.info("Initializing SamlConfigurationFactory ");
        this.isActive = new AtomicBoolean(true);
        try {
            this.loadBaseConfiguration();
        }
        finally {
            this.isActive.set(false);
        }
    }

    @Produces
    @ApplicationScoped
    public SamlAppConfiguration getSamlAppConfiguration() {
        return this.samlAppConfiguration;
    }

    public void create() {
        this.log.info("Loading SAML Configuration");
        if (!this.loadSamlConfigFromDb()) {
            this.log.error("Failed to load SAML configuration from persistence. Please fix it!!!.");
            throw new ConfigurationException("Failed to load SAML configuration from persistence.");
        }
        this.log.info("SAML Configuration loaded successfully - samlLoadedRevision:{}, samlAppConfiguration:{}", (Object)this.samlLoadedRevision, (Object)this.getSamlAppConfiguration());
    }

    public String getSamlAppConfigurationDn() {
        return this.baseConfiguration.getString("saml_ConfigurationEntryDN");
    }

    public String getConfigurationDn(String key) {
        return this.baseConfiguration.getString(key);
    }

    private void loadBaseConfiguration() {
        this.log.debug("Loading base configuration - BASE_PROPERTIES_FILE:{}", (Object)BASE_PROPERTIES_FILE);
        this.baseConfiguration = this.createFileConfiguration(BASE_PROPERTIES_FILE);
        this.baseConfigurationFileLastModifiedTime = new File(BASE_PROPERTIES_FILE).lastModified();
        this.log.debug("Loaded base configuration:{}", (Object)this.baseConfiguration.getProperties());
    }

    private FileConfiguration createFileConfiguration(String fileName) {
        try {
            return new FileConfiguration(fileName);
        }
        catch (Exception ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Failed to load configuration from {}", (Object)fileName, (Object)ex);
            }
            throw new ConfigurationException("Failed to load configuration from " + fileName, (Throwable)ex);
        }
    }

    private boolean loadSamlConfigFromDb() {
        this.log.debug("Loading Api configuration from '{}' DB...", (Object)this.baseConfiguration.getString("persistence.type"));
        try {
            SamlConf samlConf = this.loadConfigurationFromDb(this.getConfigurationDn("saml_ConfigurationEntryDN"), new SamlConf(), new String[0]);
            this.log.trace("Conf configuration '{}' DB...", (Object)samlConf);
            if (samlConf != null) {
                this.initSamlConf(samlConf);
                if (this.samlConfigLoaded) {
                    this.destroy(SamlAppConfiguration.class);
                }
                this.samlConfigLoaded = true;
                this.samlConfigurationUpdateEvent.select(new Annotation[]{ConfigurationUpdate.Literal.INSTANCE}).fire((Object)this.samlAppConfiguration);
                return true;
            }
        }
        catch (Exception ex) {
            this.log.error("Unable to find api configuration in DB..." + ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    private void initSamlConf(SamlConf samlConf) {
        this.log.debug("Initializing SAML Configuration From DB.... samlConf:{}", (Object)samlConf);
        if (samlConf == null) {
            throw new ConfigurationException("Failed to load SAML Configuration From DB " + samlConf);
        }
        this.log.info("samlAppConfigurationFromDb:{}", (Object)samlConf);
        if (samlConf.getDynamicConf() != null) {
            this.samlAppConfiguration = samlConf.getDynamicConf();
        }
        this.samlLoadedRevision = samlConf.getRevision();
        this.log.debug("*** samlAppConfiguration:{}, samlLoadedRevision:{} ", (Object)this.samlAppConfiguration, (Object)this.samlLoadedRevision);
    }

    private <T> T loadConfigurationFromDb(String dn, T obj, String ... returnAttributes) {
        this.log.debug("loadConfigurationFromDb dn:{}, clazz:{}, returnAttributes:{}", new Object[]{dn, obj, returnAttributes});
        PersistenceEntryManager persistenceEntryManager = (PersistenceEntryManager)this.persistenceEntryManagerInstance.get();
        try {
            return (T)persistenceEntryManager.find((Object)dn, obj.getClass(), returnAttributes);
        }
        catch (BasePersistenceException ex) {
            this.log.error(ex.getMessage());
            return null;
        }
    }

    private boolean isSamlRevisionIncreased() {
        SamlConf samlConf = this.loadConfigurationFromDb(this.getConfigurationDn("saml_ConfigurationEntryDN"), new SamlConf(), "jansRevision");
        if (samlConf == null) {
            return false;
        }
        this.log.debug("Saml Config - DB revision: {}, server revision: {}", (Object)samlConf.getRevision(), (Object)this.samlLoadedRevision);
        return samlConf.getRevision() > this.samlLoadedRevision;
    }

    public boolean reloadSamlConfFromLdap() {
        this.log.debug("Reload api configuration TimerEvent");
        if (!this.isSamlRevisionIncreased()) {
            return false;
        }
        return this.loadSamlConfigFromDb();
    }

    public void destroy(Class<? extends Configuration> clazz) {
        Instance confInstance = this.configurationInstance.select(clazz, new Annotation[0]);
        this.configurationInstance.destroy((Object)((Configuration)confInstance.get()));
    }

    public void initTimer() {
        this.log.debug("Initializing Configuration Timer");
        int delay = 30;
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(30, 30), (Object)new ConfigurationEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Asynchronous
    public void reloadConfigurationTimerEvent(@Observes @Scheduled ConfigurationEvent configurationEvent) {
        long lastModified;
        this.log.debug("Config reload configuration TimerEvent - baseConfigurationFileLastModifiedTime:{}", (Object)this.baseConfigurationFileLastModifiedTime);
        File baseConf = new File(BASE_PROPERTIES_FILE);
        if (baseConf.exists() && (lastModified = baseConf.lastModified()) > this.baseConfigurationFileLastModifiedTime) {
            this.loadBaseConfiguration();
            this.event.select(new Annotation[]{BaseConfigurationReload.Literal.INSTANCE}).fire((Object)SAML_BASE_CONFIGURATION_RELOAD_EVENT_TYPE);
        }
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.reloadSamlConfFromLdap();
        }
        catch (Exception ex) {
            this.log.error("Exception happened while reloading application configuration", (Throwable)ex);
        }
        finally {
            this.isActive.set(false);
        }
    }
}

