/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.saml.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.jans.configapi.plugin.saml.model.ValidationStatus;
import io.jans.model.GluuStatus;
import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.DataEntry;
import io.jans.orm.annotation.ObjectClass;
import io.jans.orm.model.base.Entry;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

@DataEntry(sortBy={"displayName"})
@ObjectClass(value="jansTrustedIdp")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class IdentityProvider
extends Entry
implements Serializable {
    @AttributeName(ignoreDuringUpdate=true)
    @Schema(description="Unique identifier.")
    private String inum;
    @NotNull
    @AttributeName
    @Schema(description="Creator of IDP.")
    private String creatorId;
    @NotNull
    @AttributeName(name="name")
    @Schema(description="Name uniquely identifies an identity provider.")
    private String name;
    @NotNull
    @Size(min=0, max=60, message="Length of the Display Name should not exceed 60")
    @AttributeName
    @Schema(description="Identity provider display name.")
    private @NotNull @Size(min=0, max=60, message="Length of the Display Name should not exceed 60") String displayName;
    @NotNull
    @Size(min=0, max=500, message="Length of the Description should not exceed 500")
    @AttributeName
    @Schema(description="Description of Identity provider.")
    private @NotNull @Size(min=0, max=500, message="Length of the Description should not exceed 500") String description;
    @NotNull
    @AttributeName(name="realm")
    @Schema(description="Realm in which Identity provider is created.")
    private String realm;
    @AttributeName(name="jansEnabled")
    @Schema(description="Indicates if Identity provider is enabled.")
    private boolean enabled;
    @AttributeName(name="signingCertificate")
    @Schema(description="Digital certificate used to verify the authenticity of the request.")
    private String signingCertificate;
    @AttributeName(name="validateSignature")
    private String validateSignature;
    @AttributeName(name="singleLogoutServiceUrl")
    @Schema(description="Url used to send logout requests.")
    private String singleLogoutServiceUrl;
    @AttributeName(name="nameIDPolicyFormat")
    @Schema(description=" URI reference corresponding to a name identifier format.")
    private String nameIDPolicyFormat;
    @AttributeName(name="principalAttribute")
    @Schema(description=" Name or Friendly Name of the attribute used to identify external users.")
    private String principalAttribute;
    @AttributeName(name="principalType")
    @Schema(description="Way to identify and track external users from the assertion.")
    private String principalType;
    @AttributeName(name="entityId")
    @Schema(description="Entity ID that will be used to uniquely identify this SAML Service Provider.")
    private String idpEntityId;
    @AttributeName(name="singleSignOnServiceUrl")
    @Schema(description="Url used to send SAML authentication requests.")
    private String singleSignOnServiceUrl;
    @AttributeName(name="encryptionPublicKey")
    @Schema(description="Public key to use to encrypt the message.")
    private String encryptionPublicKey;
    @AttributeName
    @Schema(description="IDP provider, should be SAML.")
    private String providerId;
    @AttributeName
    @Schema(description="If enabled, email provided by this provider is not verified even if verification is enabled for the realm.")
    private boolean trustEmail;
    @AttributeName
    @Schema(description="Enable/disable if tokens must be stored after authenticating users.")
    private boolean storeToken;
    @AttributeName
    @Schema(description="Enable/disable if new users can read any stored tokens.")
    private boolean addReadTokenRoleOnCreate;
    @AttributeName
    private boolean authenticateByDefault;
    @AttributeName
    @Schema(description="If true, users cannot log in through this provider. They can only link to this provider.")
    private boolean linkOnly;
    @AttributeName
    @Schema(description="Alias of authentication flow, which is triggered after first login with this identity provider. Term 'First Login' means that no Keycloak account is currently linked to the authenticated identity provider account.")
    private String firstBrokerLoginFlowAlias;
    @AttributeName
    @Schema(description="Alias of authentication flow, which is triggered after each login with this identity provider.")
    private String postBrokerLoginFlowAlias;
    @AttributeName(name="jansSAMLspMetaDataFN")
    @Hidden
    private String spMetaDataFN;
    @AttributeName(name="jansSAMLspMetaDataURL")
    @Schema(description="SAML SP metadata file URL.")
    private String spMetaDataURL;
    @AttributeName(name="jansSAMLspMetaLocation")
    @Schema(description="SP metadata file location.")
    private String spMetaDataLocation;
    @AttributeName(name="jansSAMLidpMetaDataFN")
    @Hidden
    private String idpMetaDataFN;
    @AttributeName(name="jansSAMLidpMetaDataURL")
    @Schema(description="SAML IDP metadata file URL.")
    private String idpMetaDataURL;
    @AttributeName(name="jansSAMLidpMetaLocation")
    @Schema(description="SAML IDP metadata file location.")
    private String idpMetaDataLocation;
    @AttributeName(name="jansStatus")
    @Schema(description="IDP setup status.")
    private GluuStatus status;
    @AttributeName(name="jansValidationStatus")
    @Schema(description="IDP validation status.")
    private ValidationStatus validationStatus;
    @AttributeName(name="jansValidationLog")
    @Schema(description="IDP validation log.")
    private List<String> validationLog;

    public String getInum() {
        return this.inum;
    }

    public void setInum(String inum) {
        this.inum = inum;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getSigningCertificate() {
        return this.signingCertificate;
    }

    public void setSigningCertificate(String signingCertificate) {
        this.signingCertificate = signingCertificate;
    }

    public String getValidateSignature() {
        return this.validateSignature;
    }

    public void setValidateSignature(String validateSignature) {
        this.validateSignature = validateSignature;
    }

    public String getSingleLogoutServiceUrl() {
        return this.singleLogoutServiceUrl;
    }

    public void setSingleLogoutServiceUrl(String singleLogoutServiceUrl) {
        this.singleLogoutServiceUrl = singleLogoutServiceUrl;
    }

    public String getNameIDPolicyFormat() {
        return this.nameIDPolicyFormat;
    }

    public void setNameIDPolicyFormat(String nameIDPolicyFormat) {
        this.nameIDPolicyFormat = nameIDPolicyFormat;
    }

    public String getPrincipalAttribute() {
        return this.principalAttribute;
    }

    public void setPrincipalAttribute(String principalAttribute) {
        this.principalAttribute = principalAttribute;
    }

    public String getPrincipalType() {
        return this.principalType;
    }

    public void setPrincipalType(String principalType) {
        this.principalType = principalType;
    }

    public String getIdpEntityId() {
        return this.idpEntityId;
    }

    public void setIdpEntityId(String idpEntityId) {
        this.idpEntityId = idpEntityId;
    }

    public String getSingleSignOnServiceUrl() {
        return this.singleSignOnServiceUrl;
    }

    public void setSingleSignOnServiceUrl(String singleSignOnServiceUrl) {
        this.singleSignOnServiceUrl = singleSignOnServiceUrl;
    }

    public String getEncryptionPublicKey() {
        return this.encryptionPublicKey;
    }

    public void setEncryptionPublicKey(String encryptionPublicKey) {
        this.encryptionPublicKey = encryptionPublicKey;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public boolean isTrustEmail() {
        return this.trustEmail;
    }

    public void setTrustEmail(boolean trustEmail) {
        this.trustEmail = trustEmail;
    }

    public boolean isStoreToken() {
        return this.storeToken;
    }

    public void setStoreToken(boolean storeToken) {
        this.storeToken = storeToken;
    }

    public boolean isAddReadTokenRoleOnCreate() {
        return this.addReadTokenRoleOnCreate;
    }

    public void setAddReadTokenRoleOnCreate(boolean addReadTokenRoleOnCreate) {
        this.addReadTokenRoleOnCreate = addReadTokenRoleOnCreate;
    }

    public boolean isAuthenticateByDefault() {
        return this.authenticateByDefault;
    }

    public void setAuthenticateByDefault(boolean authenticateByDefault) {
        this.authenticateByDefault = authenticateByDefault;
    }

    public boolean isLinkOnly() {
        return this.linkOnly;
    }

    public void setLinkOnly(boolean linkOnly) {
        this.linkOnly = linkOnly;
    }

    public String getFirstBrokerLoginFlowAlias() {
        return this.firstBrokerLoginFlowAlias;
    }

    public void setFirstBrokerLoginFlowAlias(String firstBrokerLoginFlowAlias) {
        this.firstBrokerLoginFlowAlias = firstBrokerLoginFlowAlias;
    }

    public String getPostBrokerLoginFlowAlias() {
        return this.postBrokerLoginFlowAlias;
    }

    public void setPostBrokerLoginFlowAlias(String postBrokerLoginFlowAlias) {
        this.postBrokerLoginFlowAlias = postBrokerLoginFlowAlias;
    }

    public String getSpMetaDataFN() {
        return this.spMetaDataFN;
    }

    public void setSpMetaDataFN(String spMetaDataFN) {
        this.spMetaDataFN = spMetaDataFN;
    }

    public String getSpMetaDataURL() {
        return this.spMetaDataURL;
    }

    public void setSpMetaDataURL(String spMetaDataURL) {
        this.spMetaDataURL = spMetaDataURL;
    }

    public String getSpMetaDataLocation() {
        return this.spMetaDataLocation;
    }

    public void setSpMetaDataLocation(String spMetaDataLocation) {
        this.spMetaDataLocation = spMetaDataLocation;
    }

    public String getIdpMetaDataFN() {
        return this.idpMetaDataFN;
    }

    public void setIdpMetaDataFN(String idpMetaDataFN) {
        this.idpMetaDataFN = idpMetaDataFN;
    }

    public String getIdpMetaDataURL() {
        return this.idpMetaDataURL;
    }

    public void setIdpMetaDataURL(String idpMetaDataURL) {
        this.idpMetaDataURL = idpMetaDataURL;
    }

    public String getIdpMetaDataLocation() {
        return this.idpMetaDataLocation;
    }

    public void setIdpMetaDataLocation(String idpMetaDataLocation) {
        this.idpMetaDataLocation = idpMetaDataLocation;
    }

    public GluuStatus getStatus() {
        return this.status;
    }

    public void setStatus(GluuStatus status) {
        this.status = status;
    }

    public ValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    public void setValidationStatus(ValidationStatus validationStatus) {
        this.validationStatus = validationStatus;
    }

    public List<String> getValidationLog() {
        return this.validationLog;
    }

    public void setValidationLog(List<String> validationLog) {
        this.validationLog = validationLog;
    }

    public String toString() {
        return "IdentityProvider [inum=" + this.inum + ", creatorId=" + this.creatorId + ", name=" + this.name + ", displayName=" + this.displayName + ", description=" + this.description + ", realm=" + this.realm + ", enabled=" + this.enabled + ", signingCertificate=" + this.signingCertificate + ", validateSignature=" + this.validateSignature + ", singleLogoutServiceUrl=" + this.singleLogoutServiceUrl + ", nameIDPolicyFormat=" + this.nameIDPolicyFormat + ", principalAttribute=" + this.principalAttribute + ", principalType=" + this.principalType + ", idpEntityId=" + this.idpEntityId + ", singleSignOnServiceUrl=" + this.singleSignOnServiceUrl + ", encryptionPublicKey=" + this.encryptionPublicKey + ", providerId=" + this.providerId + ", trustEmail=" + this.trustEmail + ", storeToken=" + this.storeToken + ", addReadTokenRoleOnCreate=" + this.addReadTokenRoleOnCreate + ", authenticateByDefault=" + this.authenticateByDefault + ", linkOnly=" + this.linkOnly + ", firstBrokerLoginFlowAlias=" + this.firstBrokerLoginFlowAlias + ", postBrokerLoginFlowAlias=" + this.postBrokerLoginFlowAlias + ", spMetaDataFN=" + this.spMetaDataFN + ", spMetaDataURL=" + this.spMetaDataURL + ", spMetaDataLocation=" + this.spMetaDataLocation + ", idpMetaDataFN=" + this.idpMetaDataFN + ", idpMetaDataURL=" + this.idpMetaDataURL + ", idpMetaDataLocation=" + this.idpMetaDataLocation + ", status=" + this.status + ", validationStatus=" + this.validationStatus + ", validationLog=" + this.validationLog + "]";
    }
}

