/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.saml.service;

import io.jans.as.common.service.OrganizationService;
import io.jans.as.common.service.common.InumService;
import io.jans.configapi.configuration.ConfigurationFactory;
import io.jans.configapi.plugin.saml.model.TrustRelationship;
import io.jans.configapi.plugin.saml.service.SamlConfigService;
import io.jans.configapi.plugin.saml.service.SamlIdpService;
import io.jans.model.GluuStatus;
import io.jans.model.SearchRequest;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SortOrder;
import io.jans.orm.search.filter.Filter;
import io.jans.util.StringHelper;
import io.jans.util.exception.InvalidConfigurationException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class SamlService {
    @Inject
    Logger log;
    @Inject
    PersistenceEntryManager persistenceEntryManager;
    @Inject
    ConfigurationFactory configurationFactory;
    @Inject
    OrganizationService organizationService;
    @Inject
    private InumService inumService;
    @Inject
    SamlConfigService samlConfigService;
    @Inject
    SamlIdpService samlIdpService;

    public String getTrustRelationshipDn() {
        return this.samlConfigService.getTrustRelationshipDn();
    }

    public String getSpMetadataFilePattern() {
        return this.samlConfigService.getSpMetadataFilePattern();
    }

    public boolean containsRelationship(String dn) {
        return this.persistenceEntryManager.contains(dn, TrustRelationship.class);
    }

    public TrustRelationship getRelationshipByDn(String dn) {
        if (StringHelper.isNotEmpty((String)dn)) {
            try {
                return (TrustRelationship)this.persistenceEntryManager.find(TrustRelationship.class, (Object)dn);
            }
            catch (Exception e) {
                this.log.error(e.getMessage());
            }
        }
        return null;
    }

    public TrustRelationship getTrustRelationshipByInum(String inum) {
        TrustRelationship result = null;
        try {
            result = (TrustRelationship)this.persistenceEntryManager.find(TrustRelationship.class, (Object)this.getDnForTrustRelationship(inum));
        }
        catch (Exception ex) {
            this.log.error("Failed to load TrustRelationship entry", (Throwable)ex);
        }
        return result;
    }

    public List<TrustRelationship> getAllTrustRelationships() {
        return this.persistenceEntryManager.findEntries(this.getDnForTrustRelationship(null), TrustRelationship.class, null);
    }

    public List<TrustRelationship> getAllActiveTrustRelationships() {
        TrustRelationship trustRelationship = new TrustRelationship();
        trustRelationship.setBaseDn(this.getDnForTrustRelationship(null));
        trustRelationship.setStatus(GluuStatus.ACTIVE);
        return this.persistenceEntryManager.findEntries((Object)trustRelationship);
    }

    public List<TrustRelationship> getAllTrustRelationshipByInum(String inum) {
        return this.persistenceEntryManager.findEntries(this.getDnForTrustRelationship(inum), TrustRelationship.class, null);
    }

    public List<TrustRelationship> getAllTrustRelationshipByDisplayName(String name) {
        this.log.info("Search TrustRelationship with name:{}", (Object)name);
        String[] targetArray = new String[]{name};
        Filter displayNameFilter = Filter.createEqualityFilter((String)"displayName", (Object)targetArray);
        this.log.debug("Search TrustRelationship with displayNameFilter:{}", (Object)displayNameFilter);
        return this.persistenceEntryManager.findEntries(this.getDnForTrustRelationship(null), TrustRelationship.class, displayNameFilter);
    }

    public List<TrustRelationship> getAllTrustRelationshipByName(String name) {
        this.log.info("Search TrustRelationship with name:{}", (Object)name);
        Filter nameFilter = Filter.createEqualityFilter((String)"name", (Object)name);
        this.log.debug("Search TrustRelationship with nameFilter:{}", (Object)nameFilter);
        return this.persistenceEntryManager.findEntries(this.getDnForTrustRelationship(null), TrustRelationship.class, nameFilter);
    }

    public TrustRelationship getTrustContainerFederation(TrustRelationship trustRelationship) {
        return this.getRelationshipByDn(trustRelationship.getDn());
    }

    public TrustRelationship getTrustContainerFederation(String dn) {
        return this.getRelationshipByDn(dn);
    }

    public List<TrustRelationship> getAllTrustRelationships(int sizeLimit) {
        return this.persistenceEntryManager.findEntries(this.getDnForTrustRelationship(null), TrustRelationship.class, null, sizeLimit);
    }

    public TrustRelationship getTrustByUnpunctuatedInum(String unpunctuated) {
        for (TrustRelationship trust : this.getAllTrustRelationships()) {
            if (!StringHelper.removePunctuation((String)trust.getInum()).equals(unpunctuated)) continue;
            return trust;
        }
        return null;
    }

    public List<TrustRelationship> searchTrustRelationship(String pattern, int sizeLimit) {
        this.log.info("Search TrustRelationship with pattern:{}, sizeLimit:{}", (Object)pattern, (Object)sizeLimit);
        String[] targetArray = new String[]{pattern};
        Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
        Filter inumFilter = Filter.createSubstringFilter((String)"inum", null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter, inumFilter});
        this.log.info("Search TrustRelationship with searchFilter:{}", (Object)searchFilter);
        return this.persistenceEntryManager.findEntries(this.getDnForTrustRelationship(null), TrustRelationship.class, searchFilter, sizeLimit);
    }

    public List<TrustRelationship> getAllTrustRelationship(int sizeLimit) {
        return this.persistenceEntryManager.findEntries(this.getDnForTrustRelationship(null), TrustRelationship.class, null, sizeLimit);
    }

    public PagedResult<TrustRelationship> getTrustRelationship(SearchRequest searchRequest) {
        this.log.info("Search TrustRelationship with searchRequest:{}", (Object)searchRequest);
        Filter searchFilter = null;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (searchRequest.getFilterAssertionValue() != null && !searchRequest.getFilterAssertionValue().isEmpty()) {
            for (String assertionValue : searchRequest.getFilterAssertionValue()) {
                String[] targetArray = new String[]{assertionValue};
                Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
                Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
                Filter inumFilter = Filter.createSubstringFilter((String)"inum", null, (String[])targetArray, null);
                filters.add(Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter, inumFilter}));
            }
            searchFilter = Filter.createORFilter(filters);
        }
        this.log.debug("TrustRelationship pattern searchFilter:{}", searchFilter);
        ArrayList<Filter> fieldValueFilters = new ArrayList<Filter>();
        if (searchRequest.getFieldValueMap() != null && !searchRequest.getFieldValueMap().isEmpty()) {
            for (Map.Entry entry : searchRequest.getFieldValueMap().entrySet()) {
                Filter dataFilter = Filter.createEqualityFilter((String)((String)entry.getKey()), entry.getValue());
                this.log.trace("TrustRelationship dataFilter:{}", (Object)dataFilter);
                fieldValueFilters.add(Filter.createANDFilter((Filter[])new Filter[]{dataFilter}));
            }
            searchFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createORFilter(filters), Filter.createANDFilter(fieldValueFilters)});
        }
        this.log.info("TrustRelationship searchFilter:{}", (Object)searchFilter);
        return this.persistenceEntryManager.findPagedEntries(this.getDnForTrustRelationship(null), TrustRelationship.class, searchFilter, null, searchRequest.getSortBy(), SortOrder.getByValue((String)searchRequest.getSortOrder()), searchRequest.getStartIndex().intValue(), searchRequest.getCount().intValue(), searchRequest.getMaxCount());
    }

    public TrustRelationship addTrustRelationship(TrustRelationship trustRelationship) throws IOException, WebApplicationException {
        return this.addTrustRelationship(trustRelationship, null);
    }

    public TrustRelationship addTrustRelationship(TrustRelationship trustRelationship, InputStream file) throws IOException, WebApplicationException {
        this.log.info("Add new trustRelationship:{}, file:{}", (Object)trustRelationship, (Object)file);
        this.setTrustRelationshipDefaultValue(trustRelationship, false);
        this.persistenceEntryManager.persist((Object)trustRelationship);
        if (file != null && file.available() > 0) {
            this.saveSpMetaDataFileSourceTypeFile(trustRelationship, file);
        } else {
            trustRelationship.setSpMetaDataFN(null);
        }
        this.persistenceEntryManager.merge((Object)trustRelationship);
        this.log.info("After saving new trustRelationship:{}", (Object)trustRelationship);
        return this.getTrustRelationshipByInum(trustRelationship.getInum());
    }

    public TrustRelationship updateTrustRelationship(TrustRelationship trustRelationship) throws IOException, WebApplicationException {
        return this.updateTrustRelationship(trustRelationship, null);
    }

    public TrustRelationship updateTrustRelationship(TrustRelationship trustRelationship, InputStream file) throws IOException, WebApplicationException {
        this.log.info("Update trustRelationship:{}, file:{}", (Object)trustRelationship, (Object)file);
        this.setTrustRelationshipDefaultValue(trustRelationship, true);
        if (file != null && file.available() > 0) {
            this.saveSpMetaDataFileSourceTypeFile(trustRelationship, file);
        }
        this.persistenceEntryManager.merge((Object)trustRelationship);
        this.log.info("After updating trustRelationship:{}", (Object)trustRelationship);
        return this.getTrustRelationshipByInum(trustRelationship.getInum());
    }

    public void removeTrustRelationship(TrustRelationship trustRelationship) {
        this.persistenceEntryManager.removeRecursively(trustRelationship.getDn(), TrustRelationship.class);
    }

    private TrustRelationship setTrustRelationshipDefaultValue(TrustRelationship trustRelationship, boolean update) {
        this.log.debug("trustRelationship:{}, update:{}", (Object)trustRelationship, (Object)update);
        return trustRelationship;
    }

    public String getDnForTrustRelationship(String inum) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=trustRelationships,%s", orgDn);
        }
        return String.format("inum=%s,ou=trustRelationships,%s", inum, orgDn);
    }

    public String generateInumForNewRelationship() {
        String newInum = null;
        String newDn = null;
        while (this.containsRelationship(newDn = this.getDnForTrustRelationship(newInum = UUID.randomUUID().toString()))) {
        }
        return newInum;
    }

    private boolean saveSpMetaDataFileSourceTypeFile(TrustRelationship trustRelationship, InputStream file) {
        this.log.debug("saveSpMetadataFileSourceTypeFile(). trustRelationship: {} . file: {}", (Object)trustRelationship, (Object)file);
        String spMetadataFileName = this.getSpNewMetadataFileName(trustRelationship);
        trustRelationship.setSpMetaDataFN(spMetadataFileName);
        InputStream targetStream = file;
        String metadataFilePath = this.samlIdpService.saveMetadataFile(this.samlConfigService.getSpMetadataDir(), spMetadataFileName, "sp-module", targetStream);
        this.log.debug("targetStream: {}, spMetadataDir: {}, spMetadataFileName: {}", new Object[]{targetStream, this.samlConfigService.getSpMetadataDir(), spMetadataFileName});
        if (StringHelper.isNotEmpty((String)metadataFilePath)) {
            trustRelationship.setSpMetaDataFN(metadataFilePath);
            this.log.debug("SP Metadata file ' {} ' saved.", (Object)spMetadataFileName);
            return true;
        }
        this.log.error("Failed to save SP metadata file for TrustRelationship ' {} '", (Object)trustRelationship.getInum());
        return false;
    }

    public String getSpMetadataFilePath(String spMetaDataFN) {
        if (StringUtils.isBlank((CharSequence)this.getSpMetadataDir())) {
            throw new InvalidConfigurationException("Failed to return SP metadata file path as undefined!");
        }
        return this.getSpMetadataDir() + spMetaDataFN;
    }

    public String getSpMetadataDir() {
        if (StringUtils.isBlank((CharSequence)this.samlConfigService.getSpMetadataDir())) {
            throw new InvalidConfigurationException("Failed to return SP metadata file path as undefined!");
        }
        return this.samlConfigService.getSpMetadataDir() + File.separator;
    }

    public String getSpNewMetadataFileName(TrustRelationship trustRel) {
        return this.getSpNewMetadataFileName(trustRel.getInum());
    }

    public String getSpNewMetadataFileName(String inum) {
        this.log.info("Generate SP Metadata FileName with inum:{}", (Object)inum);
        String relationshipInum = StringHelper.removePunctuation((String)inum);
        this.log.info("inum after remove punctuation is:{}", (Object)relationshipInum);
        return String.format(this.samlConfigService.getSpMetadataFilePattern(), relationshipInum);
    }

    public InputStream getTrustRelationshipMetadataFile(TrustRelationship trustrelationship) {
        this.log.debug("Get trustrelationship metadata file");
        return this.samlIdpService.getFileFromDocumentStore(trustrelationship.getSpMetaDataFN());
    }
}

