/*
 * Decompiled with CFR 0.152.
 */
package io.jans.saml.metadata.parser;

import io.jans.saml.metadata.builder.ContactPersonBuilder;
import io.jans.saml.metadata.builder.EndpointBuilder;
import io.jans.saml.metadata.builder.EntityDescriptorBuilder;
import io.jans.saml.metadata.builder.IndexedEndpointBuilder;
import io.jans.saml.metadata.builder.KeyDescriptorBuilder;
import io.jans.saml.metadata.builder.LocalizedTextBuilder;
import io.jans.saml.metadata.builder.OrganizationBuilder;
import io.jans.saml.metadata.builder.RoleDescriptorBuilder;
import io.jans.saml.metadata.builder.SAMLMetadataBuilder;
import io.jans.saml.metadata.builder.SPSSODescriptorBuilder;
import io.jans.saml.metadata.builder.SSODescriptorBuilder;
import io.jans.saml.metadata.builder.ds.KeyInfoBuilder;
import io.jans.saml.metadata.builder.ds.X509DataBuilder;
import io.jans.saml.metadata.builder.enc.EncryptionMethodBuilder;
import io.jans.saml.metadata.model.SAMLBinding;
import io.jans.saml.metadata.model.SAMLMetadata;
import io.jans.saml.metadata.parser.ParseError;
import io.jans.saml.metadata.parser.ParserCreateError;
import io.jans.saml.metadata.util.SAXUtils;
import io.jans.saml.metadata.util.XPathUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SAMLMetadataParser {
    private final SAXParser saxParser;
    private final Schema schema;

    public SAMLMetadataParser() {
        try {
            this.saxParser = SAXUtils.createParser();
            this.schema = this.saxParser.getSchema();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new ParserCreateError("Could not create parser", e);
        }
    }

    public SAMLMetadata parse(File metadatafile) {
        try {
            Validator validator = this.schema.newValidator();
            validator.validate(new StreamSource(metadatafile));
            DocumentBuilderFactory docbuilderfactory = DocumentBuilderFactory.newInstance();
            docbuilderfactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
            docbuilderfactory.setSchema(this.schema);
            docbuilderfactory.setNamespaceAware(true);
            DocumentBuilder docbuilder = docbuilderfactory.newDocumentBuilder();
            Document doc = docbuilder.parse(metadatafile);
            XPath xpath = XPathUtils.newXPath();
            SAMLMetadataBuilder builder = new SAMLMetadataBuilder();
            if (XPathUtils.entityDescriptorIsDocumentRoot(xpath, doc)) {
                Node entitydescnode = XPathUtils.entityDescriptorFromParentNode(xpath, doc);
                this.parseEntityDescriptor(xpath, entitydescnode, builder.entityDescriptor());
            } else {
                Node entitiesdescnode = XPathUtils.entitiesDescriptorFromParentNode(xpath, doc);
                this.flattenEntitiesDescriptor(xpath, entitiesdescnode, builder);
            }
            return builder.build();
        }
        catch (IOException | IllegalArgumentException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new ParseError("Metadata parsing failed", e);
        }
    }

    private final void flattenEntitiesDescriptor(XPath xpath, Node entitiescdescriptor, SAMLMetadataBuilder builder) throws XPathExpressionException {
        NodeList entitydescriptorlist = XPathUtils.entityDescriptorListFromParentNode(xpath, entitiescdescriptor);
        for (int i = 0; i < entitydescriptorlist.getLength(); ++i) {
            this.parseEntityDescriptor(xpath, entitydescriptorlist.item(i), builder.entityDescriptor());
        }
        NodeList entitiesdescriptorlist = XPathUtils.entitiesDescriptorListFromParentNode(xpath, entitiescdescriptor);
        for (int i = 0; i < entitiesdescriptorlist.getLength(); ++i) {
            this.flattenEntitiesDescriptor(xpath, entitiesdescriptorlist.item(i), builder);
        }
    }

    private final void parseEntityDescriptor(XPath xpath, Node node, EntityDescriptorBuilder builder) throws XPathExpressionException {
        builder.id(XPathUtils.idAttributeValue(xpath, node)).entityId(XPathUtils.entityIDAttributeValue(xpath, node)).cacheDuration(XPathUtils.cacheDurationAttributeValue(xpath, node)).validUntil(XPathUtils.validUntilAttributeValue(xpath, node));
        NodeList spssodescriptorslist = XPathUtils.roleDescriptorFromParentNode(XPathUtils.RoleDescriptorNodeType.SPSSO_DESCRIPTOR_NODE, xpath, node);
        for (int i = 0; i < spssodescriptorslist.getLength(); ++i) {
            this.parseSPSSODescriptor(xpath, spssodescriptorslist.item(i), builder.spssoDescriptor());
        }
    }

    private final void parseSPSSODescriptor(XPath xpath, Node node, SPSSODescriptorBuilder builder) throws XPathExpressionException {
        builder.authnRequestsSigned(XPathUtils.authnRequestsSignedAttributeValue(xpath, node));
        builder.wantAssertionsSigned(XPathUtils.wantAssertionsSignedAttributeValue(xpath, node));
        this.parseSSODescriptor(xpath, node, builder);
        NodeList assertionconsumerservicelist = XPathUtils.assertionConsumerServiceListFromParentNode(xpath, node);
        for (int i = 0; i < assertionconsumerservicelist.getLength(); ++i) {
            this.parseIndexedEndpoint(xpath, assertionconsumerservicelist.item(i), builder.assertionConsumerService());
        }
    }

    private final void parseSSODescriptor(XPath xpath, Node node, SSODescriptorBuilder builder) throws XPathExpressionException {
        this.parseRoleDescriptor(xpath, node, builder);
        NodeList sloservicelist = XPathUtils.singleLogoutServiceListFromParentNode(xpath, node);
        for (int i = 0; i < sloservicelist.getLength(); ++i) {
            this.parseEndpoint(xpath, sloservicelist.item(i), builder.singleLogoutService());
        }
        builder.nameIDFormats(XPathUtils.nameIDFormatListFromParentNode(xpath, node));
    }

    private final void parseRoleDescriptor(XPath xpath, Node node, RoleDescriptorBuilder builder) throws XPathExpressionException {
        builder.id(XPathUtils.idAttributeValue(xpath, node)).cacheDuration(XPathUtils.cacheDurationAttributeValue(xpath, node)).validUntil(XPathUtils.validUntilAttributeValue(xpath, node)).supportedProtocols(XPathUtils.protocolSupportEnumerationAttributeValue(xpath, node)).errorUrl(XPathUtils.errorUrlAttributeValue(xpath, node));
        Node organization = XPathUtils.organizationFromParentNode(xpath, node);
        if (organization != null) {
            this.parseOrganization(xpath, organization, builder.organization());
        }
        NodeList contactpersonlist = XPathUtils.contactPersonListFromParentNode(xpath, node);
        for (int i = 0; i < contactpersonlist.getLength(); ++i) {
            this.parseContactPerson(xpath, contactpersonlist.item(i), builder.contactPerson());
        }
        NodeList keydescriptorlist = XPathUtils.keyDescriptorListFromParentNode(xpath, node);
        for (int i = 0; i < keydescriptorlist.getLength(); ++i) {
            this.parseKeyDescriptor(xpath, keydescriptorlist.item(i), builder.keyDescriptor());
        }
    }

    private final void parseOrganization(XPath xpath, Node node, OrganizationBuilder builder) throws XPathExpressionException {
        NodeList orgnamelist = XPathUtils.organizationNameListFromParentNode(xpath, node);
        for (int i = 0; i < orgnamelist.getLength(); ++i) {
            this.parseLocalizedText(xpath, orgnamelist.item(i), builder.name());
        }
        NodeList displaynamelist = XPathUtils.organizationDisplayNameListFromParentNode(xpath, node);
        for (int i = 0; i < displaynamelist.getLength(); ++i) {
            this.parseLocalizedText(xpath, displaynamelist.item(i), builder.diplayName());
        }
        NodeList urls = XPathUtils.organizationUrlListFromParentNode(xpath, node);
        for (int i = 0; i < urls.getLength(); ++i) {
            this.parseLocalizedText(xpath, urls.item(i), builder.url());
        }
    }

    private final void parseLocalizedText(XPath xpath, Node node, LocalizedTextBuilder builder) throws XPathExpressionException {
        builder.language(XPathUtils.languageAttributeValue(xpath, node)).text(node.getTextContent());
    }

    private final void parseContactPerson(XPath xpath, Node node, ContactPersonBuilder builder) throws XPathExpressionException {
        builder.type(XPathUtils.contactTypeAttributeValue(xpath, node)).company(XPathUtils.companyValueFromParentNode(xpath, node)).givenName(XPathUtils.givenNameValueFromParentNode(xpath, node)).surName(XPathUtils.surnameValueFromParentNode(xpath, node)).emailAddresses(XPathUtils.emailAddressListFromParentNode(xpath, node)).telephoneNumbers(XPathUtils.telephoneNumberListFromParentNode(xpath, node));
    }

    private final void parseKeyDescriptor(XPath xpath, Node node, KeyDescriptorBuilder builder) throws XPathExpressionException {
        builder.use(XPathUtils.useAttributeValue(xpath, node));
        NodeList encmethods = XPathUtils.encryptionMethodListFromParentNode(xpath, node);
        for (int i = 0; i < encmethods.getLength(); ++i) {
            this.parseEncryptionMethod(xpath, encmethods.item(i), builder.encryptionMethod());
        }
        Node keyinfo = XPathUtils.keyInfoFromParentNode(xpath, node);
        if (keyinfo != null) {
            this.parseKeyInfo(xpath, keyinfo, builder.keyInfo());
        }
    }

    private final void parseEncryptionMethod(XPath xpath, Node node, EncryptionMethodBuilder builder) throws XPathExpressionException {
        builder.algorithm(XPathUtils.algorithmAttributeValue(xpath, node)).keySize(XPathUtils.keySizeFromParentNode(xpath, node)).oaepParams(XPathUtils.oaepParamsFromParentNode(xpath, node));
    }

    private final void parseKeyInfo(XPath xpath, Node node, KeyInfoBuilder builder) throws XPathExpressionException {
        builder.id(XPathUtils.dsigIdAttributeValue(xpath, node));
        NodeList x509datalist = XPathUtils.x509DataListFromParentNode(xpath, node);
        for (int i = 0; i < x509datalist.getLength(); ++i) {
            this.parseX509Data(xpath, x509datalist.item(i), builder.x509Data());
        }
    }

    private final void parseX509Data(XPath xpath, Node node, X509DataBuilder builder) throws XPathExpressionException {
        List<String> certificates = XPathUtils.x509CertificatesFromParentNode(xpath, node);
        builder.x509Certificates(certificates);
    }

    private final void parseEndpoint(XPath xpath, Node node, EndpointBuilder builder) throws XPathExpressionException {
        builder.binding(SAMLBinding.fromString(XPathUtils.bindingAttributeValue(xpath, node))).location(XPathUtils.locationAttributeValue(xpath, node)).responseLocation(XPathUtils.responseLocationAttributeValue(xpath, node));
    }

    private final void parseIndexedEndpoint(XPath xpath, Node node, IndexedEndpointBuilder builder) throws XPathExpressionException {
        this.parseEndpoint(xpath, node, builder);
        builder.index(XPathUtils.indexAttributeValue(xpath, node)).isDefault(XPathUtils.isDefaultAttributeValue(xpath, node));
    }
}

