/*
 * Decompiled with CFR 0.152.
 */
package io.jans.saml.metadata.util;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class LSResourceResolverImpl
implements LSResourceResolver {
    private static final Map<String, String> namespacemap = new HashMap<String, String>();
    private static final Map<String, String> publicidmap;
    private static final String CHARACTER_ENCODING = "UTF-8";

    @Override
    public LSInput resolveResource(String type, String nameSpaceURI, String publicId, String systemId, String baseURI) {
        String resourcepath;
        if (nameSpaceURI != null && (resourcepath = namespacemap.get(nameSpaceURI)) != null) {
            return new LSInputImpl(this.getClass().getResourceAsStream(resourcepath));
        }
        if (publicId != null && (resourcepath = publicidmap.get(publicId)) != null) {
            return new LSInputImpl(this.getClass().getResourceAsStream(resourcepath));
        }
        return null;
    }

    static {
        namespacemap.put("http://www.w3.org/XML/1998/namespace", "/META-INF/xml.schemas/xml.xsd");
        namespacemap.put("urn:oasis:names:tc:SAML:2.0:assertion", "/META-INF/saml.schemas/saml-schema-assertion-2.0.xsd");
        namespacemap.put("http://www.w3.org/2000/09/xmldsig#", "/META-INF/xml.schemas/xmldsig-core-schema.xsd");
        namespacemap.put("http://www.w3.org/2001/04/xmlenc#", "/META-INF/xml.schemas/xenc-schema.xsd");
        publicidmap = new HashMap<String, String>();
        publicidmap.put("-//W3C//DTD XMLSchema 200102//EN", "/META-INF/xml.schemas/XMLSchema.dtd");
        publicidmap.put("datatypes", "/META-INF/xml.schemas/datatypes.dtd");
    }

    private static class LSInputImpl
    implements LSInput {
        private final InputStream byteStream;

        public LSInputImpl(InputStream byteStream) {
            this.byteStream = byteStream;
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public void setPublicId(String publicId) {
        }

        @Override
        public InputStream getByteStream() {
            return this.byteStream;
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public boolean getCertifiedText() {
            return true;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public void setCharacterStream(Reader reader) {
        }

        @Override
        public String getEncoding() {
            return LSResourceResolverImpl.CHARACTER_ENCODING;
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public String getSystemId() {
            return null;
        }

        @Override
        public void setSystemId(String systemId) {
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public void setStringData(String stringData) {
        }
    }
}

