/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.saml.service;

import io.jans.configapi.plugin.saml.configuration.SamlConfigurationFactory;
import io.jans.configapi.plugin.saml.model.config.SamlAppConfiguration;
import io.jans.configapi.plugin.saml.model.config.SamlConf;
import io.jans.orm.PersistenceEntryManager;
import io.jans.util.exception.InvalidConfigurationException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class SamlConfigService {
    @Inject
    Logger logger;
    @Inject
    @Named(value="persistenceEntryManager")
    PersistenceEntryManager persistenceManager;
    @Inject
    SamlConfigurationFactory samlConfigurationFactory;

    public SamlConf findSamlConf() {
        String dn = this.samlConfigurationFactory.getSamlConfigurationDn();
        if (StringUtils.isBlank((CharSequence)dn)) {
            throw new InvalidConfigurationException("Saml Configuration DN is undefined!");
        }
        this.logger.info(" dn:{}", (Object)dn);
        SamlConf samlConf = (SamlConf)this.persistenceManager.find((Object)dn, SamlConf.class, null);
        this.logger.info(" samlConf:{}", (Object)samlConf);
        return samlConf;
    }

    public void mergeSamlConfig(SamlConf samlConf) {
        samlConf.setRevision(samlConf.getRevision() + 1L);
        this.persistenceManager.merge((Object)samlConf);
    }

    public SamlAppConfiguration find() {
        return this.getSamlConf().getDynamicConf();
    }

    public String getTrustRelationshipDn() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String trustRelationshipDn = null;
        if (samlAppConfiguration != null) {
            trustRelationshipDn = samlAppConfiguration.getSamlTrustRelationshipDn();
        }
        return trustRelationshipDn;
    }

    public String getTrustedIdpDn() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String trustedIdpDn = null;
        if (samlAppConfiguration != null) {
            trustedIdpDn = samlAppConfiguration.getTrustedIdpDn();
        }
        return trustedIdpDn;
    }

    public boolean isSamlEnabled() {
        SamlConf samlConf = this.getSamlConf();
        this.logger.debug("samlConf.getDynamicConf():{}", (Object)samlConf.getDynamicConf());
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        boolean isSamlEnabled = false;
        if (samlAppConfiguration != null) {
            isSamlEnabled = samlAppConfiguration.isEnabled();
        }
        return isSamlEnabled;
    }

    public String getSelectedIdp() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String selectedIdp = null;
        if (samlAppConfiguration != null) {
            selectedIdp = samlAppConfiguration.getSelectedIdp();
        }
        return selectedIdp;
    }

    public String getServerUrl() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String serverUrl = null;
        if (samlAppConfiguration != null) {
            serverUrl = samlAppConfiguration.getServerUrl();
        }
        return serverUrl;
    }

    public String getRealm() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String realm = null;
        if (samlAppConfiguration != null) {
            realm = samlAppConfiguration.getRealm();
        }
        return realm;
    }

    public String getClientId() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String clientId = null;
        if (samlAppConfiguration != null) {
            clientId = samlAppConfiguration.getClientId();
        }
        return clientId;
    }

    public String getClientSecret() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String clientSecret = null;
        if (samlAppConfiguration != null) {
            clientSecret = samlAppConfiguration.getClientSecret();
        }
        return clientSecret;
    }

    public String getGrantType() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String grantType = null;
        if (samlAppConfiguration != null) {
            grantType = samlAppConfiguration.getGrantType();
        }
        return grantType;
    }

    public String getScope() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String scope = null;
        if (samlAppConfiguration != null) {
            scope = samlAppConfiguration.getScope();
        }
        return scope;
    }

    public String getUsername() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String username = null;
        if (samlAppConfiguration != null) {
            username = samlAppConfiguration.getUsername();
        }
        return username;
    }

    public String getPassword() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String password = null;
        if (samlAppConfiguration != null) {
            password = samlAppConfiguration.getPassword();
        }
        return password;
    }

    public String getSpMetadataUrl(String realm, String name) {
        this.logger.debug("Get SP Metadata Url - realm:{}, name:{}", (Object)realm, (Object)name);
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String spMetadataUrl = null;
        if (samlAppConfiguration != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(samlAppConfiguration.getServerUrl()).append(samlAppConfiguration.getSpMetadataUrl());
            spMetadataUrl = String.format(sb.toString(), realm, name);
        }
        this.logger.debug("SP Metadata Url - spMetadataUrl:{}", spMetadataUrl);
        return spMetadataUrl;
    }

    public String getTokenUrl(String realm) {
        this.logger.debug("Get SAML Token Url - realm:{}", (Object)realm);
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String tokenUrl = null;
        if (samlAppConfiguration != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(samlAppConfiguration.getServerUrl()).append(samlAppConfiguration.getTokenUrl());
            tokenUrl = String.format(sb.toString(), realm);
        }
        this.logger.debug("SAML Token Url - tokenUrl:{}", tokenUrl);
        return tokenUrl;
    }

    public String getIdpUrl(String realm) {
        this.logger.debug("Get SAML IDP Url - realm:{}", (Object)realm);
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String idpUrl = null;
        if (samlAppConfiguration != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(samlAppConfiguration.getServerUrl()).append(samlAppConfiguration.getIdpUrl());
            idpUrl = String.format(sb.toString(), realm);
        }
        this.logger.debug("SAML IDP Url - idpUrl:{}", idpUrl);
        return idpUrl;
    }

    public String getExtIDPTokenUrl(String realm, String idpAliasName) {
        this.logger.debug("Get SAML External IDP Url - realm:{}, idpAliasName:{}", (Object)realm, (Object)idpAliasName);
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String extIDPTokenUrl = null;
        if (samlAppConfiguration != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(samlAppConfiguration.getServerUrl()).append(samlAppConfiguration.getExtIDPTokenUrl());
            extIDPTokenUrl = String.format(sb.toString(), realm, idpAliasName);
        }
        this.logger.debug("SAML Ext IDP Url - extIDPTokenUrl:{}", extIDPTokenUrl);
        return extIDPTokenUrl;
    }

    public String getExtIDPRedirectUrl(String realm, String clientId, String redirectUrl, String responseType, String idpAliasName) {
        this.logger.debug("Get SAML External IDP Redirect Url - realm:{}, clientId:{}, redirectUrl:{}, responseType:{}, idpAliasName:{}", new Object[]{realm, clientId, redirectUrl, responseType, idpAliasName});
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String extIDPRedirectUrl = null;
        if (samlAppConfiguration != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(samlAppConfiguration.getServerUrl()).append(samlAppConfiguration.getExtIDPRedirectUrl());
            extIDPRedirectUrl = String.format(sb.toString(), realm, clientId, redirectUrl, responseType, idpAliasName);
        }
        this.logger.debug("SAML External IDP Redirect  - extIDPRedirectUrl:{}", extIDPRedirectUrl);
        return extIDPRedirectUrl;
    }

    public String getIdpMetadataImportUrl(String realm) {
        this.logger.debug("Get SAML IDP Metadata Import Url - realm:{}", (Object)realm);
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String idpMetadataImportUrl = null;
        if (samlAppConfiguration != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(samlAppConfiguration.getServerUrl()).append(samlAppConfiguration.getIdpMetadataImportUrl());
            idpMetadataImportUrl = String.format(sb.toString(), realm);
        }
        this.logger.debug("SAML IDP Metadata Import Url - idpMetadataImportUrl:{}", idpMetadataImportUrl);
        return idpMetadataImportUrl;
    }

    public String getIdpRootDir() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String idpRootDir = null;
        if (samlAppConfiguration != null) {
            idpRootDir = samlAppConfiguration.getIdpRootDir();
        }
        return idpRootDir;
    }

    public String getIdpMetadataDir() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String idpMetadataDir = null;
        if (samlAppConfiguration != null) {
            idpMetadataDir = samlAppConfiguration.getIdpMetadataDir();
        }
        return idpMetadataDir;
    }

    public String getIdpMetadataTempDir() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String idpMetadataTempDir = null;
        if (samlAppConfiguration != null) {
            idpMetadataTempDir = samlAppConfiguration.getIdpMetadataTempDir();
        }
        return idpMetadataTempDir;
    }

    public String getIdpMetadataFilePattern() {
        return "%s_idp-metadata.xml";
    }

    public String getIdpMetadataFile() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String idpMetadataFile = null;
        if (samlAppConfiguration != null) {
            idpMetadataFile = samlAppConfiguration.getIdpMetadataFile();
        }
        return idpMetadataFile;
    }

    public String getSpMetadataDir() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String spMetadataDir = null;
        if (samlAppConfiguration != null) {
            spMetadataDir = samlAppConfiguration.getSpMetadataDir();
        }
        return spMetadataDir;
    }

    public String getSpMetadataTempDir() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String spMetadataTempDir = null;
        if (samlAppConfiguration != null) {
            spMetadataTempDir = samlAppConfiguration.getSpMetadataTempDir();
        }
        return spMetadataTempDir;
    }

    public String getSpMetadataFilePattern() {
        return "%s_sp-metadata.xml";
    }

    public String getSpMetadataFile() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        String spMetadataFile = null;
        if (samlAppConfiguration != null) {
            spMetadataFile = samlAppConfiguration.getSpMetadataFile();
        }
        return spMetadataFile;
    }

    public boolean isIgnoreValidation() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        boolean ignoreValidation = false;
        if (samlAppConfiguration != null) {
            ignoreValidation = samlAppConfiguration.isIgnoreValidation();
        }
        return ignoreValidation;
    }

    public boolean isSetConfigDefaultValue() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        boolean setConfigDefaultValue = false;
        if (samlAppConfiguration != null) {
            setConfigDefaultValue = samlAppConfiguration.isSetConfigDefaultValue();
        }
        return setConfigDefaultValue;
    }

    public List<String> getIdpMetadataMandatoryAttributes() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        List<String> idpMetadataMandatoryAttributes = null;
        if (samlAppConfiguration != null) {
            idpMetadataMandatoryAttributes = samlAppConfiguration.getIdpMetadataMandatoryAttributes();
        }
        return idpMetadataMandatoryAttributes;
    }

    public List<String> getKcAttributes() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        List<String> kcAttributes = null;
        if (samlAppConfiguration != null) {
            kcAttributes = samlAppConfiguration.getKcAttributes();
        }
        return kcAttributes;
    }

    public List<String> getKcSamlConfig() {
        SamlConf samlConf = this.getSamlConf();
        SamlAppConfiguration samlAppConfiguration = samlConf.getDynamicConf();
        List<String> kcSamlConfig = null;
        if (samlAppConfiguration != null) {
            kcSamlConfig = samlAppConfiguration.getKcSamlConfig();
        }
        return kcSamlConfig;
    }

    private SamlConf getSamlConf() {
        SamlConf samlConf = this.findSamlConf();
        if (samlConf == null) {
            throw new InvalidConfigurationException("SamlConf is undefined!");
        }
        this.logger.debug("  samlConf:{}, samlConf.getDynamicConf():{}", (Object)samlConf, (Object)samlConf.getDynamicConf());
        return samlConf;
    }
}

