/*
 * Decompiled with CFR 0.152.
 */
package io.jans.saml.metadata.util;

import io.jans.saml.metadata.parser.ParserCreateError;
import io.jans.saml.metadata.util.LSResourceResolverImpl;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class SAXUtils {
    private static final Source[] schemasources = new Source[]{new StreamSource(SAXUtils.class.getResourceAsStream("/META-INF/saml.schemas/saml-schema-metadata-2.0.xsd"))};
    private static SAXParserFactory parserfactory = null;

    private SAXUtils() {
    }

    public static void init() throws ParserConfigurationException, SAXException {
        if (parserfactory == null) {
            parserfactory = SAXParserFactory.newInstance();
            parserfactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
            parserfactory.setSchema(SAXUtils.newSchemaFactory().newSchema(schemasources));
            parserfactory.setNamespaceAware(true);
        }
    }

    public static final SAXParser createParser() throws ParserConfigurationException, SAXException {
        if (parserfactory == null) {
            throw new ParserCreateError("Please call SAXParser.init() first");
        }
        return parserfactory.newSAXParser();
    }

    private static final SchemaFactory newSchemaFactory() throws SAXException {
        SchemaFactory schemafactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemafactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
        schemafactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        schemafactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        schemafactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        schemafactory.setResourceResolver(new LSResourceResolverImpl());
        return schemafactory;
    }
}

