/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.saml.rest;

import io.jans.as.model.util.Util;
import io.jans.configapi.core.model.ApiError;
import io.jans.configapi.core.rest.BaseResource;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.plugin.saml.form.TrustRelationshipForm;
import io.jans.configapi.plugin.saml.model.MetadataSourceType;
import io.jans.configapi.plugin.saml.model.TrustRelationship;
import io.jans.configapi.plugin.saml.service.SamlService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;
import org.slf4j.Logger;

@Path(value="/saml/trust-relationship")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class TrustRelationshipResource
extends BaseResource {
    private static final String SAML_TRUST_RELATIONSHIP = "Trust Relationship";
    private static final String SAML_TRUST_RELATIONSHIP_FORM = "Trust Relationship From";
    private static final String SAML_TRUST_RELATIONSHIP_CHECK_STR = "Trust Relationship identified by '";
    private static final String NAME_CONFLICT = "NAME_CONFLICT";
    private static final String NAME_CONFLICT_MSG = "Trust Relationship with same name `%s` already exists!";
    private static final String DATA_NULL_CHK = "RESOURCE_IS_NULL";
    private static final String DATA_NULL_MSG = "`%s` should not be null!";
    @Inject
    Logger logger;
    @Inject
    SamlService samlService;

    @Operation(summary="Get all Trust Relationship", description="Get all TrustRelationship.", operationId="get-trust-relationships", tags={"SAML - Trust Relationship"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/saml.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=TrustRelationship.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/saml.readonly"})
    public Response getAllTrustRelationship() {
        List<TrustRelationship> trustRelationshipList = this.samlService.getAllTrustRelationships();
        this.logger.info("All trustRelationshipList:{}", trustRelationshipList);
        return Response.ok(trustRelationshipList).build();
    }

    @Operation(summary="Get TrustRelationship by Id", description="Get TrustRelationship by Id", operationId="get-trust-relationship-by-id", tags={"SAML - Trust Relationship"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/saml.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=TrustRelationship.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Trust relationship not found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class))}), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/saml.readonly"})
    @Path(value="/id/{id}")
    public Response getTrustRelationshipById(@Parameter(description="Unique identifier - Id") @PathParam(value="id") @NotNull String id) {
        TrustRelationship trustrelationship;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Searching TrustRelationship by id: {}", (Object)Util.escapeLog((Object)id));
        }
        if ((trustrelationship = this.samlService.getTrustRelationshipByInum(id)) != null) {
            this.logger.info("TrustRelationship found by id:{}, trustRelationship:{}", (Object)id, (Object)trustrelationship);
            return Response.ok((Object)trustrelationship).build();
        }
        this.logger.info("TrustRelationship with id {} not found", (Object)id);
        ApiError error = new ApiError.ErrorBuilder().withCode(String.valueOf(Response.Status.NOT_FOUND.getStatusCode())).withMessage("Trust relationship not found").andDescription(String.format("The TrustRelationship with id '%s' was not found", id)).build();
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build();
    }

    @Operation(summary="Create Trust Relationship with Metadata File", description="Create Trust Relationship with Metadata File", operationId="post-trust-relationship-metadata-file", tags={"SAML - Trust Relationship"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/saml.write"})})
    @RequestBody(description="Trust Relationship object", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=TrustRelationshipForm.class), examples={@ExampleObject(name="Request example", value="example/trust-relationship/trust-relationship-post.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Newly created Trust Relationship", content={@Content(mediaType="application/json", schema=@Schema(implementation=TrustRelationship.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="InternalServerError"))})})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/upload")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/saml.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/saml.write"})
    @POST
    public Response createTrustRelationshipWithFile(@MultipartForm TrustRelationshipForm trustRelationshipForm, InputStream metadatafile) throws IOException {
        TrustRelationship trustRelationship = null;
        try {
            this.logger.info(" Create trustRelationshipForm:{} ", (Object)trustRelationshipForm);
            TrustRelationshipResource.checkResourceNotNull((Object)trustRelationshipForm, (String)SAML_TRUST_RELATIONSHIP_FORM);
            trustRelationship = trustRelationshipForm.getTrustRelationship();
            this.logger.debug(" Create trustRelationship:{} ", (Object)trustRelationship);
            TrustRelationshipResource.checkResourceNotNull((Object)trustRelationship, (String)SAML_TRUST_RELATIONSHIP);
            TrustRelationshipResource.checkNotNull((String)trustRelationship.getName(), (String)"Name");
            List<TrustRelationship> existingTrustRelationship = this.samlService.getAllTrustRelationshipByName(trustRelationship.getName());
            this.logger.debug(" existingTrustRelationship:{} ", existingTrustRelationship);
            if (existingTrustRelationship != null && !existingTrustRelationship.isEmpty()) {
                TrustRelationshipResource.throwBadRequestException((String)NAME_CONFLICT, (String)String.format(NAME_CONFLICT_MSG, trustRelationship.getName()));
            }
            InputStream metaDataFile = trustRelationshipForm.getMetaDataFile();
            this.logger.debug(" Create metaDataFile:{} ", (Object)metaDataFile);
            if (metaDataFile != null) {
                this.logger.debug(" Create metaDataFile.available():{}", (Object)metaDataFile.available());
            }
            this.validateSpMetaDataSourceType(trustRelationship, metaDataFile, false);
            String inum = this.samlService.generateInumForNewRelationship();
            trustRelationship.setInum(inum);
            trustRelationship.setDn(this.samlService.getDnForTrustRelationship(inum));
            trustRelationship = this.samlService.addTrustRelationship(trustRelationship, metaDataFile);
            this.logger.info("Create created by TrustRelationship:{}", (Object)trustRelationship);
        }
        catch (Exception ex) {
            TrustRelationshipResource.throwInternalServerException((String)("Error while creating by TrustRelationship - {" + trustRelationship + "}"), (Throwable)ex);
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity(trustRelationship).build();
    }

    @Operation(summary="Update TrustRelationship", description="Update TrustRelationship", operationId="put-trust-relationship", tags={"SAML - Trust Relationship"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/saml.write"})})
    @RequestBody(description="Trust Relationship object", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=TrustRelationshipForm.class), examples={@ExampleObject(name="Request example", value="example/trust-relationship/trust-relationship-put.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=TrustRelationship.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="InternalServerError"))})})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/saml.write"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/upload")
    @PUT
    public Response updateTrustRelationship(@MultipartForm TrustRelationshipForm trustRelationshipForm, InputStream metadatafile) throws IOException {
        this.logger.info("Update trustRelationshipForm:{}", (Object)trustRelationshipForm);
        TrustRelationship trustRelationship = null;
        try {
            TrustRelationshipResource.checkResourceNotNull((Object)trustRelationshipForm, (String)SAML_TRUST_RELATIONSHIP_FORM);
            trustRelationship = trustRelationshipForm.getTrustRelationship();
            this.logger.debug(" Create trustRelationship:{} ", (Object)trustRelationship);
            TrustRelationshipResource.checkResourceNotNull((Object)trustRelationship, (String)SAML_TRUST_RELATIONSHIP);
            TrustRelationshipResource.checkNotNull((String)trustRelationship.getName(), (String)"Name");
            TrustRelationshipResource.checkNotNull((String)trustRelationship.getInum(), (String)"inum");
            TrustRelationship existingTrustRelationship = this.samlService.getTrustRelationshipByInum(trustRelationship.getInum());
            this.logger.info("TrustRelationship found by trustRelationship.getInum():{}, existingTrustRelationship:{}", (Object)trustRelationship.getInum(), (Object)existingTrustRelationship);
            TrustRelationshipResource.checkResourceNotNull((Object)existingTrustRelationship, (String)(SAML_TRUST_RELATIONSHIP_CHECK_STR + trustRelationship.getInum() + "'"));
            String inum = trustRelationship.getInum();
            List<TrustRelationship> trustRelationshipList = this.samlService.getAllTrustRelationshipByName(trustRelationship.getName());
            this.logger.info(" trustRelationshipList:{} ", trustRelationshipList);
            if (trustRelationshipList != null && !trustRelationshipList.isEmpty()) {
                List inumList = trustRelationshipList.stream().map(TrustRelationship::getInum).collect(Collectors.toList());
                this.logger.info("TrustRelationship's with name:{}, inumList:{}", (Object)trustRelationship.getName(), inumList);
                List list = trustRelationshipList.stream().filter(e -> !e.getInum().equalsIgnoreCase(inum)).collect(Collectors.toList());
                this.logger.info("Other TrustRelationship's with same name:{} list:{}", (Object)trustRelationship.getName(), list);
                if (list != null && !list.isEmpty()) {
                    TrustRelationshipResource.throwBadRequestException((String)NAME_CONFLICT, (String)String.format(NAME_CONFLICT_MSG, trustRelationship.getName()));
                }
            }
            InputStream metaDataFile = trustRelationshipForm.getMetaDataFile();
            this.logger.debug("metaDataFile for update is:{} ", (Object)metaDataFile);
            if (metaDataFile != null && metaDataFile.available() > 0) {
                this.logger.debug("For update metaDataFile.available():{}", (Object)metaDataFile.available());
            } else if (trustRelationship.getSpMetaDataSourceType().equals((Object)MetadataSourceType.FILE)) {
                trustRelationship.setSpMetaDataFN(existingTrustRelationship.getSpMetaDataFN());
            }
            this.validateSpMetaDataSourceType(trustRelationship, metaDataFile, true);
            trustRelationship = this.samlService.updateTrustRelationship(trustRelationship, metaDataFile);
            this.logger.info("Post update trustRelationship:{}", (Object)trustRelationship);
        }
        catch (Exception ex) {
            TrustRelationshipResource.throwInternalServerException((String)("Error while updating by TrustRelationship - {" + trustRelationship + "}"), (Throwable)ex);
        }
        return Response.ok((Object)trustRelationship).build();
    }

    @Operation(summary="Delete TrustRelationship", description="Delete TrustRelationship", operationId="delete-trust-relationship", tags={"SAML - Trust Relationship"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/saml.write"})})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @Path(value="/{id}")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/saml.write"})
    @DELETE
    public Response deleteTrustRelationship(@Parameter(description="Unique Id of Trust Relationship") @PathParam(value="id") @NotNull String id) {
        TrustRelationship trustRelationship;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Delete TrustRelationship identified by id:{}", (Object)Util.escapeLog((Object)id));
        }
        if ((trustRelationship = this.samlService.getTrustRelationshipByInum(id)) == null) {
            TrustRelationshipResource.checkResourceNotNull((Object)trustRelationship, (String)SAML_TRUST_RELATIONSHIP);
        }
        this.samlService.removeTrustRelationship(trustRelationship);
        return Response.noContent().build();
    }

    @Operation(summary="Get TrustRelationship file metadata", description="Get TrustRelationship file metadata", operationId="get-trust-relationship-file-metadata", tags={"SAML - Trust Relationship"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/saml.readonly"})}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/xml", schema=@Schema(type="string", format="binary"))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @Path(value="/sp-metadata-file/{id}")
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/saml.readonly"})
    public Response gettrustRelationshipFileMetadata(@Parameter(description="TrustRelationship inum") @PathParam(value="id") @NotNull String id) {
        InputStream fs;
        this.logger.info("getTrustRelationshipFileMeta()");
        TrustRelationship trustrelationship = this.samlService.getTrustRelationshipByInum(id);
        TrustRelationshipResource.checkResourceNotNull((Object)trustrelationship, (String)SAML_TRUST_RELATIONSHIP);
        if (trustrelationship.getSpMetaDataSourceType() != MetadataSourceType.FILE) {
            TrustRelationshipResource.throwBadRequestException((String)"TrustRelationship metadatasource type isn't a FILE");
        }
        if ((fs = this.samlService.getTrustRelationshipMetadataFile(trustrelationship)) == null) {
            return TrustRelationshipResource.getNotFoundError((String)String.format("metadata file for tr '%s' ", id));
        }
        return Response.ok((Object)fs, (String)"application/xml").build();
    }

    private void validateSpMetaDataSourceType(TrustRelationship trustRelationship, InputStream metaDataFile, boolean isUpdate) throws IOException {
        this.logger.info("Validate SP MetaDataSourceType trustRelationship:{}, metaDataFile:{}, isUpdate:{}", new Object[]{trustRelationship, metaDataFile, isUpdate});
        TrustRelationshipResource.checkResourceNotNull((Object)((Object)trustRelationship.getSpMetaDataSourceType()), (String)"SP MetaData Source Type");
        this.logger.info("Validate trustRelationship.getSpMetaDataSourceType():{}", (Object)trustRelationship.getSpMetaDataSourceType());
        if (trustRelationship.getSpMetaDataSourceType().equals((Object)MetadataSourceType.FILE)) {
            if (!(metaDataFile != null && metaDataFile.available() > 0 || isUpdate)) {
                TrustRelationshipResource.throwBadRequestException((String)DATA_NULL_CHK, (String)String.format(DATA_NULL_MSG, "SP MetaData File"));
            }
            trustRelationship.setSamlMetadata(null);
        } else if (trustRelationship.getSpMetaDataSourceType().equals((Object)MetadataSourceType.MANUAL)) {
            if (metaDataFile != null && metaDataFile.available() > 0) {
                TrustRelationshipResource.throwBadRequestException((String)"SP MetaData File should not be provided!");
            }
            TrustRelationshipResource.checkResourceNotNull((Object)trustRelationship.getSamlMetadata(), (String)"'SamlMetadata manual elements'");
            TrustRelationshipResource.checkNotNull((String)trustRelationship.getSamlMetadata().getEntityId(), (String)"'EntityId'");
            TrustRelationshipResource.checkNotNull((String)trustRelationship.getSamlMetadata().getNameIDPolicyFormat(), (String)"'NameIDPolicyFormat'");
            TrustRelationshipResource.checkNotNull((String)trustRelationship.getSamlMetadata().getSingleLogoutServiceUrl(), (String)"'SingleLogoutServiceUrl'");
            if (StringUtils.isBlank((CharSequence)trustRelationship.getSamlMetadata().getJansAssertionConsumerServiceGetURL()) && StringUtils.isBlank((CharSequence)trustRelationship.getSamlMetadata().getJansAssertionConsumerServiceGetURL())) {
                TrustRelationshipResource.throwBadRequestException((String)"Either of AssertionConsumerService GET or POST URL should be provided!");
            }
        }
    }
}

