/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.saml.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.jans.as.common.service.OrganizationService;
import io.jans.configapi.core.util.DataUtil;
import io.jans.configapi.plugin.saml.client.IdpClientFactory;
import io.jans.configapi.plugin.saml.model.IdentityProvider;
import io.jans.configapi.plugin.saml.service.IdentityProviderService;
import io.jans.configapi.plugin.saml.service.KeycloakService;
import io.jans.configapi.plugin.saml.service.SamlConfigService;
import io.jans.configapi.util.AuthUtil;
import io.jans.model.SearchRequest;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.PagedResult;
import io.jans.util.exception.InvalidAttributeException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class IdpService {
    @Inject
    Logger log;
    @Inject
    PersistenceEntryManager persistenceEntryManager;
    @Inject
    SamlConfigService samlConfigService;
    @Inject
    OrganizationService organizationService;
    @Inject
    IdentityProviderService identityProviderService;
    @Inject
    KeycloakService keycloakService;
    @Inject
    IdpClientFactory idpClientFactory;
    @Inject
    AuthUtil authUtil;

    public String getIdentityProviderDn() {
        return this.samlConfigService.getTrustedIdpDn();
    }

    public String getRealm() {
        String realm = this.samlConfigService.getRealm();
        this.log.debug("realm:{}", (Object)realm);
        if (StringUtils.isBlank((CharSequence)realm)) {
            realm = "master";
        }
        this.log.debug("Final realm:{}", (Object)realm);
        return realm;
    }

    public String getSpMetadataUrl(String realm, String name) {
        return this.samlConfigService.getSpMetadataUrl(realm, name);
    }

    public List<IdentityProvider> getAllIdentityProviders(String realmName) throws IOException {
        return this.keycloakService.findAllIdentityProviders(realmName);
    }

    public IdentityProvider getIdentityProviderByInum(String inum) {
        return this.identityProviderService.getIdentityProviderByInum(inum);
    }

    public List<IdentityProvider> getIdentityProviderByName(String name) {
        List<IdentityProvider> list = null;
        try {
            list = this.identityProviderService.getIdentityProviderByName(name);
        }
        catch (Exception ex) {
            this.log.error("Error while finding IDP with name:{} is:{}", (Object)name, (Object)ex);
        }
        return list;
    }

    public PagedResult<IdentityProvider> getIdentityProviders(SearchRequest searchRequest) {
        return this.identityProviderService.getIdentityProvider(searchRequest);
    }

    public List<IdentityProvider> getAllIdp(String realmName) throws IOException {
        this.log.info("Fetch all IDP from realm:{}", (Object)realmName);
        if (StringUtils.isBlank((CharSequence)realmName)) {
            realmName = this.getRealm();
        }
        return this.keycloakService.findAllIdentityProviders(realmName);
    }

    public IdentityProvider createSamlIdentityProvider(IdentityProvider identityProvider, InputStream idpMetadataStream) throws IOException {
        this.log.info("Create IdentityProvider with IDP metadata file in identityProvider:{}, idpMetadataStream:{}, samlConfigService.isSamlEnabled():{}", new Object[]{identityProvider, idpMetadataStream, this.samlConfigService.isSamlEnabled()});
        if (identityProvider == null) {
            throw new InvalidAttributeException("IdentityProvider object is null!!!");
        }
        String inum = this.identityProviderService.generateInumForIdentityProvider();
        identityProvider.setInum(inum);
        identityProvider.setDn(this.identityProviderService.getDnForIdentityProvider(inum));
        ByteArrayOutputStream bos = this.getByteArrayOutputStream(idpMetadataStream);
        identityProvider = this.processIdentityProvider(identityProvider, this.getInputStream(bos), false);
        this.log.debug("Create IdentityProvider identityProvider:{}", (Object)identityProvider);
        try {
            this.identityProviderService.addSamlIdentityProvider(identityProvider, this.getInputStream(bos));
            this.log.debug("Created IdentityProvider in Jans DB -  identityProvider:{}", (Object)identityProvider);
        }
        catch (Exception ex) {
            this.log.error("Deleting KC IDP as error while persisting identityProvider:{}", (Object)identityProvider);
            this.deleteIdentityProvider(identityProvider, false);
            throw ex;
        }
        return identityProvider;
    }

    public IdentityProvider updateSamlIdentityProvider(IdentityProvider identityProvider, InputStream idpMetadataStream) throws IOException {
        this.log.debug("Update IdentityProvider with IDP metadata file in - identityProvider:{}, idpMetadataStream:{}, samlConfigService.isSamlEnabled():{}", new Object[]{identityProvider, idpMetadataStream, this.samlConfigService.isSamlEnabled()});
        if (identityProvider == null) {
            throw new InvalidAttributeException("IdentityProvider object for update is null!!!");
        }
        ByteArrayOutputStream bos = this.getByteArrayOutputStream(idpMetadataStream);
        identityProvider = this.processIdentityProvider(identityProvider, this.getInputStream(bos), true);
        this.log.debug("Update IdentityProvider identityProvider:{}", (Object)identityProvider);
        this.updateIdentityProvider(identityProvider, this.getInputStream(bos));
        this.log.info("Updated IdentityProvider - identityProvider:{}", (Object)identityProvider);
        return identityProvider;
    }

    public void deleteIdentityProvider(IdentityProvider identityProvider, boolean deleteInDB) throws IOException {
        boolean status = false;
        this.log.info("Delete dentityProvider:{}, deleteInDB:{}, samlConfigService.isSamlEnabled():{}", new Object[]{identityProvider, deleteInDB, this.samlConfigService.isSamlEnabled()});
        if (identityProvider == null) {
            throw new InvalidAttributeException("IdentityProvider object for delete is null!!!");
        }
        if (this.samlConfigService.isSamlEnabled()) {
            status = this.keycloakService.deleteIdentityProvider(identityProvider.getRealm(), identityProvider.getName());
        }
        this.log.info("Delete IDP status:{}, deleteInDB:{}", (Object)status, (Object)deleteInDB);
        if (status && deleteInDB) {
            this.log.info("Deleting IDP in DB - identityProvider.getInum():{}, identityProvider.getName():{}", (Object)identityProvider.getInum(), (Object)identityProvider.getName());
            this.identityProviderService.removeIdentityProvider(identityProvider);
            this.log.info("IDP successfully deleted in DB - identityProvider.getInum():{}, identityProvider.getName():{}", (Object)identityProvider.getInum(), (Object)identityProvider.getName());
        }
    }

    public String getSpMetadata(IdentityProvider identityProvider) throws JsonProcessingException {
        if (identityProvider == null) {
            throw new InvalidAttributeException("IdentityProvider object is null!!!");
        }
        return this.keycloakService.getSpMetadata(identityProvider.getRealm(), identityProvider.getName());
    }

    private IdentityProvider updateIdentityProvider(IdentityProvider identityProvider, InputStream idpMetadataStream) throws IOException {
        this.log.info("Update IdentityProvider with IDP metadata file in identityProvider:{}, idpMetadataStream:{} ", (Object)identityProvider, (Object)idpMetadataStream);
        this.identityProviderService.updateIdentityProvider(identityProvider, idpMetadataStream);
        this.log.debug("Updated IdentityProvider in Jans DB -  identityProvider:{}", (Object)identityProvider);
        return identityProvider;
    }

    private IdentityProvider setSamlIdentityProviderDefaultValue(IdentityProvider identityProvider, boolean update) {
        this.log.info("Setting default value for identityProvider:{}, update:{}", (Object)identityProvider, (Object)update);
        if (identityProvider == null) {
            return identityProvider;
        }
        if (StringUtils.isBlank((CharSequence)identityProvider.getRealm())) {
            identityProvider.setRealm(this.getRealm());
        }
        if (StringUtils.isBlank((CharSequence)identityProvider.getProviderId())) {
            identityProvider.setProviderId("saml");
        }
        if (!update) {
            identityProvider.setStoreToken(true);
            identityProvider.setAddReadTokenRoleOnCreate(true);
            if (StringUtils.isBlank((CharSequence)identityProvider.getNameIDPolicyFormat())) {
                identityProvider.setNameIDPolicyFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
            }
            if (StringUtils.isBlank((CharSequence)identityProvider.getPrincipalAttribute())) {
                identityProvider.setPrincipalAttribute("uid");
            }
            if (StringUtils.isBlank((CharSequence)identityProvider.getPrincipalType())) {
                identityProvider.setPrincipalType("FRIENDLY_ATTRIBUTE");
            }
        }
        this.log.info("After setting default value for identityProvider:{}, update:{}", (Object)identityProvider, (Object)update);
        return identityProvider;
    }

    private Map<String, String> setSamlIdpConfigDefaultValue(Map<String, String> config, IdentityProvider identityProvider, boolean update) {
        this.log.info("Setting default config value for config:{}, identityProvider:{}, update:{}, samlConfigService.isSetConfigDefaultValue():{}", new Object[]{config, identityProvider, update, this.samlConfigService.isSetConfigDefaultValue()});
        if (identityProvider == null || config == null || config.isEmpty()) {
            return config;
        }
        if (!update && this.samlConfigService.isSetConfigDefaultValue()) {
            if (StringUtils.isBlank((CharSequence)identityProvider.getNameIDPolicyFormat())) {
                identityProvider.setNameIDPolicyFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
            }
            config.put("nameIDPolicyFormat", identityProvider.getNameIDPolicyFormat());
            if (StringUtils.isBlank((CharSequence)identityProvider.getPrincipalAttribute())) {
                identityProvider.setPrincipalAttribute("uid");
            }
            config.put("principalAttribute", identityProvider.getPrincipalAttribute());
            if (StringUtils.isBlank((CharSequence)identityProvider.getPrincipalType())) {
                identityProvider.setPrincipalType("FRIENDLY_ATTRIBUTE");
            }
            config.put("principalType", identityProvider.getPrincipalType());
        }
        this.log.info("After setting config default value for identityProvider:{}, update:{}", (Object)identityProvider, (Object)update);
        return config;
    }

    private IdentityProvider processIdentityProvider(IdentityProvider identityProvider, InputStream idpMetadataStream, boolean isUpdate) throws IOException {
        this.log.info("Common processing for identityProvider:{}, idpMetadataStream:{}, isUpdate:{}", new Object[]{identityProvider, idpMetadataStream, isUpdate});
        if (identityProvider == null) {
            return identityProvider;
        }
        this.setSamlIdentityProviderDefaultValue(identityProvider, isUpdate);
        if (idpMetadataStream != null && idpMetadataStream.available() > 0) {
            Map<String, String> config = this.validateSamlMetadata(identityProvider.getProviderId(), identityProvider.getRealm(), idpMetadataStream);
            this.log.debug("Validated metadata to create IDP - config:{}", config);
            this.setSamlIdpConfigDefaultValue(config, identityProvider, isUpdate);
            this.populateIdpMetadataElements(identityProvider, config);
        }
        boolean validConfig = this.validateIdpMetadataElements(identityProvider);
        this.log.info("Is metadata individual elements for IDP creation present:{}", (Object)validConfig);
        if (this.samlConfigService.isSamlEnabled()) {
            this.log.info("Create/Update IDP Service idpMetadataStream:{}, identityProvider.getRealm():{}", (Object)idpMetadataStream, (Object)identityProvider.getRealm());
            identityProvider = this.keycloakService.createUpdateIdentityProvider(identityProvider.getRealm(), isUpdate, identityProvider);
            this.log.info("Newly created identityProvider in KC:{}", (Object)identityProvider);
            if (identityProvider != null) {
                String spMetadataUrl = this.getSpMetadataUrl(identityProvider.getRealm(), identityProvider.getName());
                this.log.debug(" Setting KC SP Metadata URL - spMetadataUrl:{} ", (Object)spMetadataUrl);
                identityProvider.setSpMetaDataURL(spMetadataUrl);
            }
        }
        return identityProvider;
    }

    private Map<String, String> validateSamlMetadata(String prorviderId, String realmName, InputStream idpMetadataStream) throws IOException {
        return this.keycloakService.importSamlMetadata(prorviderId, realmName, idpMetadataStream);
    }

    private boolean validateIdpMetadataElements(IdentityProvider identityProvider) {
        this.log.info("identityProvider:{}, samlConfigService.getIdpMetadataMandatoryAttributes():{}", (Object)identityProvider, this.samlConfigService.getIdpMetadataMandatoryAttributes());
        boolean isValid = false;
        if (identityProvider == null || this.samlConfigService.getIdpMetadataMandatoryAttributes() == null || this.samlConfigService.getIdpMetadataMandatoryAttributes().isEmpty()) {
            isValid = true;
            return isValid;
        }
        ArrayList<String> missingElements = null;
        for (String attribute : this.samlConfigService.getIdpMetadataMandatoryAttributes()) {
            this.log.debug("attribute:{}, getValue(identityProvider, attribute):{}", (Object)attribute, (Object)this.getValue(identityProvider, attribute));
            if (!StringUtils.isBlank((CharSequence)this.getValue(identityProvider, attribute))) continue;
            if (missingElements == null) {
                missingElements = new ArrayList<String>();
            }
            missingElements.add(attribute);
        }
        this.log.info("missingElements:{}", missingElements);
        if (missingElements != null && !missingElements.isEmpty()) {
            isValid = false;
            this.log.debug("IDP elements are missing:{}, isValid:{} !", (Object)missingElements, (Object)isValid);
            throw new InvalidAttributeException("IDP mandatory attribute missing - " + missingElements + " !!!");
        }
        isValid = true;
        this.log.info("validateIdpMetadataElements - isValid:{}", (Object)isValid);
        return isValid;
    }

    private IdentityProvider populateIdpMetadataElements(IdentityProvider identityProvider, Map<String, String> config) {
        this.log.info("identityProvider:{}, config:{}, samlConfigService.getKcSamlConfig():{}", new Object[]{identityProvider, config, this.samlConfigService.getKcSamlConfig()});
        if (identityProvider == null || config == null || this.samlConfigService.getKcSamlConfig().isEmpty()) {
            return identityProvider;
        }
        for (String attribute : this.samlConfigService.getKcSamlConfig()) {
            this.log.trace("attribute:{}, config.get(attribute):{}", (Object)attribute, (Object)config.get(attribute));
            DataUtil.invokeReflectionSetter((Object)identityProvider, (String)attribute, (Object)config.get(attribute));
        }
        this.log.info("validateIdpMetadataElements - identityProvider:{}", (Object)identityProvider);
        return identityProvider;
    }

    private String getValue(IdentityProvider identityProvider, String property) {
        this.log.debug("Get Field Value - identityProvider:{}, property:{}", (Object)identityProvider, (Object)property);
        String value = null;
        try {
            value = (String)DataUtil.getValue((Object)identityProvider, (String)property);
            this.log.debug("Field Value - property:{}, value:{}", (Object)property, (Object)value);
        }
        catch (Exception ex) {
            this.log.error("Error while getting value of config ", (Throwable)ex);
        }
        return value;
    }

    private ByteArrayOutputStream getByteArrayOutputStream(InputStream input) throws IOException {
        return this.authUtil.getByteArrayOutputStream(input);
    }

    private InputStream getInputStream(ByteArrayOutputStream output) {
        this.log.debug("Get InputStream for output:{}", (Object)output);
        ByteArrayInputStream input = null;
        if (output == null) {
            return input;
        }
        input = new ByteArrayInputStream(output.toByteArray());
        this.log.debug("From ByteArrayOutputStream InputStream is:{}", (Object)input);
        return input;
    }
}

