/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.saml.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.plugin.saml.client.IdpClientFactory;
import io.jans.configapi.plugin.saml.model.IdentityProvider;
import io.jans.configapi.plugin.saml.service.SamlConfigService;
import io.jans.configapi.plugin.saml.util.Constants;
import io.jans.util.exception.InvalidAttributeException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

@ApplicationScoped
public class KeycloakService {
    public static final String REALM_NAME_NULL = "Realm name is null!!!";
    @Inject
    Logger logger;
    @Inject
    IdpClientFactory idpClientFactory;
    @Inject
    SamlConfigService samlConfigService;

    public List<IdentityProvider> findAllIdentityProviders(String realmName) throws IOException {
        this.logger.info("Fetch all IdentityProvider for realmName:{}, samlConfigService:{}", (Object)realmName, (Object)this.samlConfigService);
        if (StringUtils.isBlank((CharSequence)realmName)) {
            throw new InvalidAttributeException("IDP Realm name file is null!!!");
        }
        String token = this.getKcAccessToken(realmName);
        String idpUrl = this.getIdpUrl(realmName);
        this.logger.debug("Fetch all IdentityProvider for idpUrl:{}", (Object)idpUrl);
        String idpListAsString = this.idpClientFactory.getAllIdp(idpUrl, token);
        this.logger.info("Fetch all IdentityProvider for idpListAsString:{}", (Object)idpListAsString);
        List<IdentityProvider> identityProvider = this.createIdentityProviderList(idpListAsString);
        this.logger.info("Fetch all IdentityProvider for realmName:{}, identityProvider:{}", (Object)realmName, identityProvider);
        return identityProvider;
    }

    public Map<String, String> importSamlMetadata(String providerId, String realmName, InputStream idpMetadataStream) throws IOException {
        this.logger.info("Import config providerId:{}, realmName:{}, idpMetadataStream:{} ", new Object[]{providerId, realmName, idpMetadataStream});
        if (StringUtils.isBlank((CharSequence)providerId)) {
            throw new InvalidAttributeException("IDP ProviderId is null!!!");
        }
        if (StringUtils.isBlank((CharSequence)realmName)) {
            throw new InvalidAttributeException("IDP Realm name file is null!!!");
        }
        if (idpMetadataStream == null) {
            throw new InvalidAttributeException("IDP Metedata file is null!!!");
        }
        String token = this.getKcAccessToken(realmName);
        String samlMetadataImportUrl = this.getSamlMetadataImportUrl(realmName);
        this.logger.info(" samlMetadataImportUrl:{}", (Object)samlMetadataImportUrl);
        Map<String, String> config = this.idpClientFactory.extractSamlMetadata(samlMetadataImportUrl, token, providerId, realmName, idpMetadataStream);
        this.logger.info("Import SAML response for realmName:{}, config:{}", (Object)realmName, config);
        boolean valid = this.verifySamlIdpConfig(config);
        this.logger.debug("Is IDP metadata config valid:{}", (Object)valid);
        if (!valid) {
            throw new InvalidAttributeException("Idp Metedata file is not valid !!!");
        }
        return config;
    }

    public IdentityProvider createUpdateIdentityProvider(String realmName, boolean isUpdate, IdentityProvider identityProvider) throws IOException {
        IdentityProvider idp = null;
        this.logger.info("Add/Update IdentityProvider under realmName:{}, isUpdate:{}, identityProvider:{})", new Object[]{realmName, isUpdate, identityProvider});
        if (StringUtils.isBlank((CharSequence)realmName)) {
            throw new InvalidAttributeException(REALM_NAME_NULL);
        }
        if (identityProvider == null) {
            throw new InvalidAttributeException("IdentityProvider object is null!!!");
        }
        String token = this.getKcAccessToken(realmName);
        Object idpUrl = this.getIdpUrl(realmName);
        if (isUpdate) {
            idpUrl = (String)idpUrl + "/" + identityProvider.getName();
            this.logger.info("Final URL for update IDP idpUrl:{}", idpUrl);
        }
        JSONObject jsonObject = this.createIdentityProviderJson(identityProvider);
        this.populateKcConfig(jsonObject);
        JSONObject kcJsonObject = this.createKcJSONObject(jsonObject);
        this.logger.info("Create new IdentityProvider - kcJsonObject:{}", (Object)kcJsonObject);
        String idpJson = this.idpClientFactory.createUpdateIdp((String)idpUrl, token, isUpdate, kcJsonObject);
        this.logger.debug("IdentityProvider response idpJson:{}", (Object)idpJson);
        idp = this.createIdentityProvider(idpJson);
        this.logger.debug("IdentityProvider idp:{}", (Object)idp);
        return identityProvider;
    }

    public boolean deleteIdentityProvider(String realmName, String idpName) throws IOException {
        boolean deleteStatus = false;
        this.logger.info("Delete IdentityProvider under realmName:{}, idpName:{})", (Object)realmName, (Object)idpName);
        if (StringUtils.isBlank((CharSequence)realmName)) {
            throw new InvalidAttributeException(REALM_NAME_NULL);
        }
        if (StringUtils.isBlank((CharSequence)idpName)) {
            throw new InvalidAttributeException("Name of IdentityProvider to be deleted is null!!!");
        }
        String token = this.getKcAccessToken(realmName);
        String idpUrl = this.getIdpUrl(realmName) + "/" + idpName;
        this.logger.info("IDP URL for delete is idpUrl:{}", (Object)idpUrl);
        deleteStatus = this.idpClientFactory.deleteIdp(idpUrl, token);
        this.logger.info("IdentityProvider delete response deleteStatus:{}", (Object)deleteStatus);
        return deleteStatus;
    }

    public String getSpMetadata(String realmName, String idpName) throws JsonProcessingException {
        String spMetadataJson = null;
        if (StringUtils.isBlank((CharSequence)realmName)) {
            throw new InvalidAttributeException(REALM_NAME_NULL);
        }
        if (StringUtils.isBlank((CharSequence)idpName)) {
            throw new InvalidAttributeException("Name of IdentityProvider is null!!!");
        }
        String token = this.getKcAccessToken(realmName);
        String idpUrl = this.getSpMetadataUrl(realmName, idpName);
        this.logger.info("IDP URL for delete is idpUrl:{}", (Object)idpUrl);
        spMetadataJson = this.idpClientFactory.getSpMetadata(idpUrl, token);
        this.logger.info("IdentityProvider delete response spMetadataJson:{}", (Object)spMetadataJson);
        return spMetadataJson;
    }

    private String getKcAccessToken(String realmName) throws JsonProcessingException {
        this.logger.info(" realmName:{}", (Object)realmName);
        String tokenUrl = this.getTokenUrl(realmName);
        return IdpClientFactory.getAccessToken(tokenUrl, this.samlConfigService.getClientId(), this.samlConfigService.getClientSecret(), this.samlConfigService.getGrantType(), this.samlConfigService.getScope(), this.samlConfigService.getUsername(), this.samlConfigService.getPassword(), this.samlConfigService.getServerUrl());
    }

    private String getIdpUrl(String realmName) {
        return this.samlConfigService.getIdpUrl(realmName);
    }

    private String getTokenUrl(String realmName) {
        return this.samlConfigService.getTokenUrl(realmName);
    }

    private String getSpMetadataUrl(String realm, String name) {
        return this.samlConfigService.getSpMetadataUrl(realm, name);
    }

    private String getSamlMetadataImportUrl(String realmName) {
        return this.samlConfigService.getIdpMetadataImportUrl(realmName);
    }

    private List<String> getKcAttributes() {
        return this.samlConfigService.getKcAttributes();
    }

    private List<String> getKcSamlConfig() {
        return this.samlConfigService.getKcSamlConfig();
    }

    private boolean verifySamlIdpConfig(Map<String, String> config) {
        this.logger.debug("verifySamlConfig - config:{}", config);
        if (config == null || config.isEmpty()) {
            return false;
        }
        this.logger.info("config.keySet().containsAll(Constants.SAML_IDP_CONFIG):{}", (Object)config.keySet().containsAll(Constants.SAML_IDP_CONFIG));
        return config.keySet().containsAll(Constants.SAML_IDP_CONFIG);
    }

    private List<IdentityProvider> createIdentityProviderList(String jsonIdentityProviderList) throws IOException {
        this.logger.info("jsonIdentityProviderList:{}", (Object)jsonIdentityProviderList);
        ArrayList<IdentityProvider> idpList = null;
        if (StringUtils.isBlank((CharSequence)jsonIdentityProviderList)) {
            return idpList;
        }
        JSONArray jsonArray = new JSONArray(jsonIdentityProviderList);
        int count = jsonArray.length();
        idpList = new ArrayList<IdentityProvider>();
        for (int i = 0; i < count; ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            this.logger.trace(" i:{},{}", (Object)i, (Object)jsonObject);
            if (jsonObject == null) continue;
            idpList.add(this.createIdentityProvider(jsonObject.toString()));
        }
        this.logger.info("idpList:{}", idpList);
        return idpList;
    }

    private JSONObject createIdentityProviderJson(IdentityProvider identityProvider) throws IOException {
        this.logger.info("Create Json - identityProvider:{}", (Object)identityProvider);
        JSONObject jsonObj = null;
        if (identityProvider == null) {
            return jsonObj;
        }
        String json = Jackson.asJson((Object)identityProvider);
        jsonObj = new JSONObject(json);
        jsonObj.put("internalId", (Object)identityProvider.getInum());
        jsonObj.put("alias", (Object)identityProvider.getName());
        this.logger.info("jsonObj:{}", (Object)jsonObj);
        return jsonObj;
    }

    private IdentityProvider createIdentityProvider(String jsonIdentityProvider) throws IOException {
        this.logger.info("jsonIdentityProvider:{}", (Object)jsonIdentityProvider);
        IdentityProvider identityProvider = null;
        if (StringUtils.isBlank((CharSequence)jsonIdentityProvider)) {
            return identityProvider;
        }
        JSONObject jsonObj = new JSONObject(jsonIdentityProvider);
        jsonObj.put("inum", (Object)Jackson.getElement((String)jsonIdentityProvider, (String)"internalId"));
        jsonObj.put("name", (Object)Jackson.getElement((String)jsonIdentityProvider, (String)"alias"));
        ObjectMapper mapper = Jackson.createJsonMapper();
        identityProvider = (IdentityProvider)mapper.readValue(jsonObj.toString(), IdentityProvider.class);
        this.logger.info("IDP - identityProvider:{}", (Object)identityProvider);
        return identityProvider;
    }

    private JSONObject populateKcConfig(JSONObject jsonObject) {
        this.logger.info("IDP - jsonObject:{}", (Object)jsonObject);
        List<String> kcSamlConfig = this.getKcSamlConfig();
        this.logger.info("kcSamlConfig:{}", kcSamlConfig);
        if (jsonObject == null || kcSamlConfig == null || kcSamlConfig.isEmpty()) {
            return jsonObject;
        }
        HashMap<String, String> config = new HashMap<String, String>();
        for (String name : kcSamlConfig) {
            this.logger.trace("name:{}, jsonObject.has(name):{}", (Object)name, (Object)jsonObject.has(name));
            if (!jsonObject.has(name)) continue;
            config.put(name, jsonObject.getString(name));
        }
        this.logger.info("config:{}", config);
        jsonObject.put("config", config);
        this.logger.debug("IDP metadata config config:{})", config);
        if (config.isEmpty()) {
            throw new InvalidAttributeException("Idp Metedata config is null!!!");
        }
        boolean valid = this.verifySamlIdpConfig(config);
        this.logger.debug("Is IDP metadata config valid:{})", (Object)valid);
        this.logger.info("Post config IDP jsonObject:{}", (Object)jsonObject);
        return jsonObject;
    }

    private JSONObject createKcJSONObject(JSONObject jsonObject) {
        this.logger.info("For KC - jsonObject:{}", (Object)jsonObject);
        List<String> kcAttributes = this.getKcAttributes();
        if (jsonObject == null || kcAttributes == null || kcAttributes.isEmpty()) {
            return jsonObject;
        }
        JSONObject kcJSONObject = new JSONObject();
        for (String name : kcAttributes) {
            try {
                this.logger.trace("name:{}, jsonObject.get(name):{}", (Object)name, jsonObject.get(name));
                kcJSONObject.put(name, jsonObject.get(name));
            }
            catch (JSONException jex) {
                this.logger.error("JSONException for attribute:{}, is:{}", (Object)name, (Object)jex);
            }
        }
        this.logger.info("kcJSONObject:{}", (Object)kcJSONObject);
        return kcJSONObject;
    }
}

