/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.saml.rest;

import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import io.jans.configapi.core.rest.BaseResource;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.plugin.saml.model.config.SamlAppConfiguration;
import io.jans.configapi.plugin.saml.model.config.SamlConf;
import io.jans.configapi.plugin.saml.service.SamlConfigService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.slf4j.Logger;

@Path(value="/samlConfig")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SamlConfigResource
extends BaseResource {
    @Inject
    Logger logger;
    @Inject
    SamlConfigService samlConfigService;

    @Operation(summary="Gets SAML configuration properties", description="Gets SAML configuration properties", operationId="get-saml-properties", tags={"SAML - Configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/saml-config.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=SamlAppConfiguration.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/saml-config.readonly"}, groupScopes={"https://jans.io/oauth/config/saml-config.write"}, superScopes={"https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    public Response getSamlConfiguration() {
        SamlAppConfiguration samlConfiguration = this.samlConfigService.find();
        this.logger.info("SAML details samlConfiguration():{}", (Object)samlConfiguration);
        return Response.ok((Object)samlConfiguration).build();
    }

    @Operation(summary="Update SAML configuration properties", description="Update SAML configuration properties", operationId="put-saml-properties", tags={"SAML - Configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/saml-config.write"})})
    @RequestBody(description="GluuAttribute object", content={@Content(mediaType="application/json", schema=@Schema(implementation=SamlAppConfiguration.class), examples={@ExampleObject(name="Request example", value="example/saml/config/saml-put.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=SamlAppConfiguration.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PUT
    @ProtectedApi(scopes={"https://jans.io/oauth/config/saml-config.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response updateSamlConfiguration(@Valid SamlAppConfiguration samlConfiguration) {
        this.logger.info("Update SAML details samlConfiguration():{}", (Object)samlConfiguration);
        SamlConf conf = this.samlConfigService.findSamlConf();
        conf.setDynamicConf(samlConfiguration);
        this.samlConfigService.mergeSamlConfig(conf);
        samlConfiguration = this.samlConfigService.find();
        this.logger.info("SAML post update - samlConfiguration:{}", (Object)samlConfiguration);
        return Response.ok((Object)samlConfiguration).build();
    }

    @Operation(summary="Partially modifies SAML configuration properties.", description="Partially modifies SAML Configuration properties.", operationId="patch-saml-properties", tags={"SAML - Configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/saml-config.write"})})
    @RequestBody(description="String representing patch-document.", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=JsonPatch.class)), examples={@ExampleObject(name="Request json example", value="example/saml/config/saml-patch.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=SamlAppConfiguration.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/saml-config.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response patchSamlConfiguration(@NotNull String jsonPatchString) throws JsonPatchException, IOException {
        this.logger.info("Config API - jsonPatchString:{} ", (Object)jsonPatchString);
        SamlConf conf = this.samlConfigService.findSamlConf();
        SamlAppConfiguration samlConfiguration = (SamlAppConfiguration)Jackson.applyPatch((String)jsonPatchString, (Object)conf.getDynamicConf());
        conf.setDynamicConf(samlConfiguration);
        this.samlConfigService.mergeSamlConfig(conf);
        samlConfiguration = this.samlConfigService.find();
        this.logger.info("SAML post patch - samlConfiguration:{}", (Object)samlConfiguration);
        return Response.ok((Object)samlConfiguration).build();
    }
}

