/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.saml.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.configapi.core.util.Jackson;
import io.jans.util.exception.InvalidAttributeException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class IdpClientFactory {
    private static Logger logger = LoggerFactory.getLogger(IdpClientFactory.class);
    public static final String AUTHORIZATION = "Authorization";
    public static final String BEARER = "Bearer  ";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String APPLICATION_JSON = "application/json";
    public static final String ACCESS_TOKEN_NULL = "Access Token is null!!!";
    public static final String IDP_URL_NULL = "IDP URL is null!!!";

    public static String getAccessToken(String tokenUrl, String clientId, String clientSecret, String grantType, String scope, String username, String password, String serverUrl) throws JsonProcessingException {
        logger.info("Get  tokenUrl:{}, clientId:{}, grantType:{}, scope:{}, username:{}, serverUrl:{}", new Object[]{tokenUrl, clientId, grantType, scope, username, serverUrl});
        Invocation.Builder request = IdpClientFactory.getClientBuilder(tokenUrl);
        request.header(AUTHORIZATION, (Object)("Basic " + clientId + ":" + clientSecret));
        request.header(CONTENT_TYPE, (Object)"application/x-www-form-urlencoded");
        MultivaluedHashMap multivaluedHashMap = new MultivaluedHashMap();
        multivaluedHashMap.add((Object)"client_id", (Object)clientId);
        multivaluedHashMap.add((Object)"client_secret", (Object)clientSecret);
        multivaluedHashMap.add((Object)"grant_type", (Object)(StringUtils.isNotBlank((CharSequence)grantType) ? grantType.toLowerCase() : "password"));
        multivaluedHashMap.add((Object)"scope", (Object)scope);
        multivaluedHashMap.add((Object)"username", (Object)username);
        multivaluedHashMap.add((Object)"password", (Object)password);
        multivaluedHashMap.add((Object)"redirect_uri", (Object)serverUrl);
        Response response = request.post(Entity.form((MultivaluedMap)multivaluedHashMap));
        String token = null;
        if (response != null) {
            logger.trace("Response for Access Token -  response.getStatus():{}, response.getStatusInfo():{}, response.getEntity().getClass():{}", new Object[]{response.getStatus(), response.getStatusInfo(), response.getEntity().getClass()});
            String entity = (String)response.readEntity(String.class);
            if (response.getStatusInfo().equals(Response.Status.OK)) {
                token = Jackson.getElement((String)entity, (String)"access_token");
            } else {
                throw new WebApplicationException("Error while Access Token is " + response.getStatusInfo() + " - " + entity, response);
            }
        }
        return token;
    }

    public String getAllIdp(String idpUrl, String token) {
        logger.info(" All IDP - idpUrl:{}", (Object)idpUrl);
        Invocation.Builder client = IdpClientFactory.getClientBuilder(idpUrl);
        client.header(CONTENT_TYPE, (Object)APPLICATION_JSON);
        client.header(AUTHORIZATION, (Object)(BEARER + token));
        Response response = client.get();
        logger.debug("All IDP - response:{}", (Object)response);
        String identityProviderJsonList = null;
        if (response != null) {
            logger.trace("Fetch all IDP response.getStatus():{}, response.getStatusInfo():{}, response.getEntity().getClass():{}", new Object[]{response.getStatus(), response.getStatusInfo(), response.getEntity().getClass()});
            String entity = (String)response.readEntity(String.class);
            logger.trace("Get All IDP entity:{}", (Object)entity);
            if (response.getStatusInfo().equals(Response.Status.OK)) {
                identityProviderJsonList = entity;
            } else {
                throw new WebApplicationException("Error while fetching All IDP is " + response.getStatusInfo() + " - " + entity, response);
            }
        }
        return identityProviderJsonList;
    }

    public String getIdp(String idpUrl, String token) {
        logger.info(" Fetch IDP - idpUrl:{}", (Object)idpUrl);
        Invocation.Builder client = IdpClientFactory.getClientBuilder(idpUrl);
        client.header(CONTENT_TYPE, (Object)APPLICATION_JSON);
        client.header(AUTHORIZATION, (Object)(BEARER + token));
        Response response = client.get();
        logger.debug("Fetch IDP - response:{}", (Object)response);
        String identityProviderJson = null;
        if (response != null) {
            logger.trace("IDP -  response.getStatus():{}, response.getStatusInfo():{}, response.getEntity().getClass():{}", new Object[]{response.getStatus(), response.getStatusInfo(), response.getEntity().getClass()});
            String entity = (String)response.readEntity(String.class);
            if (response.getStatusInfo().equals(Response.Status.OK)) {
                identityProviderJson = entity;
            } else {
                throw new WebApplicationException("Error while fetching IDP is " + response.getStatusInfo() + " - " + entity, response);
            }
        }
        return identityProviderJson;
    }

    public Map<String, String> extractSamlMetadata(String idpMetadataConfigUrl, String token, String providerId, String realmName, InputStream idpMetadataStream) throws IOException {
        Map config = null;
        logger.info("Saml Idp Metadata idpMetadataConfigUrl:{}, providerId:{}, realmName:{}, idpMetadataStream:{}", new Object[]{idpMetadataConfigUrl, providerId, realmName, idpMetadataStream});
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new InvalidAttributeException(ACCESS_TOKEN_NULL);
        }
        if (idpMetadataStream == null) {
            throw new InvalidAttributeException("Idp Metedata file is null!!!");
        }
        Invocation.Builder request = IdpClientFactory.getClientBuilder(idpMetadataConfigUrl);
        request.header(AUTHORIZATION, (Object)(BEARER + token));
        MultipartFormDataOutput formData = new MultipartFormDataOutput();
        formData.addFormData("providerId", providerId, MediaType.TEXT_PLAIN_TYPE);
        logger.debug("SAML idpMetadataStream.available():{}", (Object)idpMetadataStream.available());
        byte[] content = idpMetadataStream.readAllBytes();
        logger.debug("content:{}", (Object)content);
        String body = new String(content, StandardCharsets.UTF_8);
        formData.addFormData("file", body, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        logger.info("Request for SAML metadata import - formData:{}", (Object)formData);
        Entity formDataEntity = Entity.entity((Object)formData, (String)"multipart/form-data");
        Response response = request.post(formDataEntity);
        logger.trace("Response for SAML metadata  import-  response:{}", (Object)response);
        if (response != null) {
            logger.trace("extract Saml Metadata -  response.getStatus():{}, response.getStatusInfo():{}, response.getEntity().getClass():{}", new Object[]{response.getStatus(), response.getStatusInfo(), response.getEntity().getClass()});
            String entity = (String)response.readEntity(String.class);
            if (response.getStatusInfo().equals(Response.Status.OK)) {
                ObjectMapper mapper = Jackson.createJsonMapper();
                config = (Map)mapper.readValue(entity, Map.class);
            } else {
                throw new WebApplicationException("Error while validating SAML IDP Metadata " + response.getStatusInfo() + " - " + entity, response);
            }
        }
        return config;
    }

    public String createUpdateIdp(String idpUrl, String token, boolean isUpdate, JSONObject identityProviderJson) {
        String idpJson = null;
        logger.info("Add/modify IDP idpUrl:{}, isUpdate:{}, identityProviderJson:{}", new Object[]{idpUrl, isUpdate, identityProviderJson});
        if (StringUtils.isBlank((CharSequence)idpUrl)) {
            throw new InvalidAttributeException(IDP_URL_NULL);
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new InvalidAttributeException(ACCESS_TOKEN_NULL);
        }
        if (identityProviderJson == null) {
            throw new InvalidAttributeException("IDP Json object is null!!!");
        }
        Invocation.Builder request = IdpClientFactory.getClientBuilder(idpUrl);
        request.header(AUTHORIZATION, (Object)(BEARER + token));
        request.header(CONTENT_TYPE, (Object)APPLICATION_JSON);
        Response response = null;
        if (isUpdate) {
            logger.debug(" Update SAML IDP in KC server -  identityProviderJson.toMap():{}", (Object)identityProviderJson.toMap());
            response = request.put(Entity.json((Object)identityProviderJson.toMap()));
        } else {
            logger.debug(" Create SAML IDP in KC server -  identityProviderJson.toMap():{}", (Object)identityProviderJson.toMap());
            response = request.post(Entity.json((Object)identityProviderJson.toMap()));
        }
        logger.debug("Response for SAML IDP -  response:{}", (Object)response);
        Object url = idpUrl;
        String name = identityProviderJson.getString("alias");
        logger.debug("Add/Update IDP Id -  name:{}", (Object)name);
        if (response != null) {
            logger.debug("IDP Add/Update - isUpdate:{}, response.getStatus():{}, response.getStatusInfo():{}, response.getEntity():{},response.getStatusInfo().equals(Status.OK):{},  response.getStatusInfo().equals(Status.CREATED):{}, , response.getStatusInfo().equals(Status.NO_CONTENT):{}", new Object[]{isUpdate, response.getStatus(), response.getStatusInfo(), response.getEntity(), response.getStatusInfo().equals(Response.Status.OK), response.getStatusInfo().equals(Response.Status.CREATED), response.getStatusInfo().equals(Response.Status.NO_CONTENT)});
            String entity = (String)response.readEntity(String.class);
            logger.debug("Add/Update IDP entity:{}", (Object)entity);
            if (isUpdate && (response.getStatusInfo().equals(Response.Status.OK) || response.getStatusInfo().equals(Response.Status.NO_CONTENT))) {
                logger.debug("Successful response for Update IDP request - identityProviderJson:{}, status:{}, entity:{}", new Object[]{identityProviderJson, response.getStatusInfo(), entity});
            } else if (!isUpdate && (response.getStatusInfo().equals(Response.Status.OK) || response.getStatusInfo().equals(Response.Status.CREATED))) {
                url = idpUrl + "/" + name;
                logger.debug("Successful response for Add IDP request - identityProviderJson:{}, status:{}, entity:{}, url:{}", new Object[]{identityProviderJson, response.getStatusInfo(), entity, url});
            } else {
                logger.error("Error while creating/updating IDP - identityProviderJson:{}, status:{}, entity:{}", new Object[]{identityProviderJson, response.getStatusInfo(), entity});
                throw new WebApplicationException("Error while creating/updating IDP" + identityProviderJson + ", Status is " + response.getStatusInfo() + " - " + entity, response);
            }
            idpJson = this.getIdp((String)url, token);
            logger.debug("Added/Updated IDP -  idpJson:{}", (Object)idpJson);
        }
        return idpJson;
    }

    public boolean deleteIdp(String idpUrl, String token) {
        boolean isDeleted = false;
        logger.info("Delete IDP idpUrl:{}", (Object)idpUrl);
        if (StringUtils.isBlank((CharSequence)idpUrl)) {
            throw new InvalidAttributeException(IDP_URL_NULL);
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new InvalidAttributeException(ACCESS_TOKEN_NULL);
        }
        Invocation.Builder request = IdpClientFactory.getClientBuilder(idpUrl);
        request.header(AUTHORIZATION, (Object)(BEARER + token));
        request.header(CONTENT_TYPE, (Object)APPLICATION_JSON);
        Response response = request.delete();
        logger.debug("Response for SAML IDP deletion -  response:{}", (Object)response);
        if (response != null) {
            logger.debug("Delete IDP  -  response.getStatus():{}, response.getStatusInfo():{}, response.getEntity():{}", new Object[]{response.getStatus(), response.getStatusInfo(), response.getEntity()});
            String entity = (String)response.readEntity(String.class);
            logger.trace("Delete IDP entity:{}", (Object)entity);
            if (response.getStatusInfo().equals(Response.Status.NO_CONTENT)) {
                isDeleted = true;
            } else {
                throw new WebApplicationException("Error while deleting IDP " + response.getStatusInfo() + " - " + entity, response);
            }
        }
        return isDeleted;
    }

    public String getSpMetadata(String metadataEndpoint, String token) {
        logger.info(" SP Metadata - metadataEndpoint:{}", (Object)metadataEndpoint);
        String jsonStrn = null;
        Invocation.Builder request = IdpClientFactory.getClientBuilder(metadataEndpoint);
        request.header(AUTHORIZATION, (Object)(BEARER + token));
        request.header(CONTENT_TYPE, (Object)APPLICATION_JSON);
        Response response = request.get();
        logger.debug("SpMetadata- response:{}", (Object)response);
        if (response != null) {
            logger.trace("IDP Add/Update - response.getStatus():{}, response.getStatusInfo():{}, response.getEntity().getClass():{}", new Object[]{response.getStatus(), response.getStatusInfo(), response.getEntity().getClass()});
            if (response.getStatusInfo().equals(Response.Status.OK)) {
                jsonStrn = (String)response.readEntity(String.class);
            } else {
                throw new WebApplicationException("Error while fetching SP Metadata " + response.getStatusInfo() + " - " + jsonStrn, response);
            }
        }
        return jsonStrn;
    }

    private static Invocation.Builder getClientBuilder(String url) {
        return ClientBuilder.newClient().target(url).request();
    }
}

