/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.saml.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.jans.configapi.plugin.saml.model.MetadataSourceType;
import io.jans.configapi.plugin.saml.model.ProfileConfiguration;
import io.jans.configapi.plugin.saml.model.SAMLMetadata;
import io.jans.configapi.plugin.saml.model.ValidationStatus;
import io.jans.model.GluuStatus;
import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.DataEntry;
import io.jans.orm.annotation.JsonObject;
import io.jans.orm.annotation.ObjectClass;
import io.jans.orm.model.base.Entry;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@DataEntry(sortBy={"displayName"})
@ObjectClass(value="jansTrustRelationship")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TrustRelationship
extends Entry
implements Serializable {
    private static final long serialVersionUID = 7912166229997681502L;
    @AttributeName(ignoreDuringUpdate=true)
    @Schema(description="Unique identifier")
    private String inum;
    @AttributeName
    @Schema(description="Creator of Trust Relationship.")
    private String owner;
    @AttributeName(name="name")
    @NotNull
    @Size(min=0, max=60, message="Length of the name should not exceed 60")
    @Schema(description="The alphanumeric ID string that is used to identify the Trust Relationship.")
    private @NotNull @Size(min=0, max=60, message="Length of the name should not exceed 60") String name;
    @NotNull
    @Size(min=0, max=60, message="Length of the Display Name should not exceed 60")
    @AttributeName
    @Schema(description="Trust Relationship display name.")
    private @NotNull @Size(min=0, max=60, message="Length of the Display Name should not exceed 60") String displayName;
    @NotNull
    @Size(min=0, max=4000, message="Length of the Description should not exceed 4000")
    @AttributeName
    @Schema(description="Description of the Trust Relationship.")
    private @NotNull @Size(min=0, max=4000, message="Length of the Description should not exceed 4000") String description;
    @Schema(description="URL to use when the auth server needs to redirect.")
    @AttributeName
    private String baseUrl;
    @AttributeName(name="jansEnabled")
    @Schema(description="Indicates if Trust Relationship is enabled.")
    private boolean enabled;
    @AttributeName(name="displayInConsole")
    @Schema(description="Indicates if Trust Relationship should always be listed in the UI.")
    private boolean alwaysDisplayInConsole;
    @AttributeName(name="jansPreferredMethod")
    @Schema(description="Preferred Authenticator Type.")
    private String clientAuthenticatorType;
    @AttributeName(name="jansClntSecret")
    @Schema(description="Client secret.")
    private String secret;
    @AttributeName(name="jansRegistrationAccessTkn")
    @Schema(description="Registration access token.")
    private String registrationAccessToken;
    @Schema(description="Boolean value if consent is required.")
    private Boolean consentRequired;
    @NotNull
    @AttributeName(name="jansSAMLspMetaDataSourceTyp")
    @Schema(description="Trust Relationship SP metadata type - file, URI.")
    private MetadataSourceType spMetaDataSourceType;
    @JsonObject
    @AttributeName(name="samlMetadata")
    @Schema(description="SAML entity metadata.")
    private SAMLMetadata samlMetadata;
    @AttributeName(name="jansRedirectURI")
    @Schema(description="List of valid Redirect URI.")
    private String[] redirectUris;
    @AttributeName(name="jansSAMLspMetaDataFN")
    @Hidden
    @Schema(description="Trust Relationship metadata file name.")
    private String spMetaDataFN;
    @AttributeName(name="jansSAMLspMetaDataURL")
    @Schema(description="SAML entity metadata file URL.")
    private String spMetaDataURL;
    @AttributeName(name="jansMetaLocation")
    @Schema(description="Trust Relationship metadata file location.")
    private String metaLocation;
    @AttributeName(name="jansReleasedAttr")
    @Schema(description="Trust Relationship attributes that will be released to SAML server.")
    private List<String> releasedAttributes;
    @Pattern(regexp="^$|(^(https?|http)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])", message="Please enter a valid url, including protocol (http/https)")
    @AttributeName(name="jansPostLogoutRedirectURI")
    @Schema(description="Logout request URL.")
    private @Pattern(regexp="^$|(^(https?|http)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])", message="Please enter a valid url, including protocol (http/https)") String spLogoutURL;
    @AttributeName(name="jansStatus")
    @Schema(description="Trust Relationship setup status.")
    private GluuStatus status;
    @AttributeName(name="jansValidationStatus")
    @Schema(description="Trust Relationship validation status.")
    private ValidationStatus validationStatus;
    @AttributeName(name="jansValidationLog")
    @Schema(description="Validation log.")
    private List<String> validationLog;
    @Schema(description="List of profile configuration.")
    private Map<String, ProfileConfiguration> profileConfigurations = new HashMap<String, ProfileConfiguration>();

    public String getInum() {
        return this.inum;
    }

    public void setInum(String inum) {
        this.inum = inum;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isAlwaysDisplayInConsole() {
        return this.alwaysDisplayInConsole;
    }

    public void setAlwaysDisplayInConsole(boolean alwaysDisplayInConsole) {
        this.alwaysDisplayInConsole = alwaysDisplayInConsole;
    }

    public String getClientAuthenticatorType() {
        return this.clientAuthenticatorType;
    }

    public void setClientAuthenticatorType(String clientAuthenticatorType) {
        this.clientAuthenticatorType = clientAuthenticatorType;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getRegistrationAccessToken() {
        return this.registrationAccessToken;
    }

    public void setRegistrationAccessToken(String registrationAccessToken) {
        this.registrationAccessToken = registrationAccessToken;
    }

    public Boolean getConsentRequired() {
        return this.consentRequired;
    }

    public void setConsentRequired(Boolean consentRequired) {
        this.consentRequired = consentRequired;
    }

    public MetadataSourceType getSpMetaDataSourceType() {
        return this.spMetaDataSourceType;
    }

    public void setSpMetaDataSourceType(MetadataSourceType spMetaDataSourceType) {
        this.spMetaDataSourceType = spMetaDataSourceType;
    }

    public SAMLMetadata getSamlMetadata() {
        return this.samlMetadata;
    }

    public void setSamlMetadata(SAMLMetadata samlMetadata) {
        this.samlMetadata = samlMetadata;
    }

    public String[] getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(String[] redirectUris) {
        this.redirectUris = redirectUris;
    }

    public String getSpMetaDataFN() {
        return this.spMetaDataFN;
    }

    public void setSpMetaDataFN(String spMetaDataFN) {
        this.spMetaDataFN = spMetaDataFN;
    }

    public String getSpMetaDataURL() {
        return this.spMetaDataURL;
    }

    public void setSpMetaDataURL(String spMetaDataURL) {
        this.spMetaDataURL = spMetaDataURL;
    }

    public String getMetaLocation() {
        return this.metaLocation;
    }

    public void setMetaLocation(String metaLocation) {
        this.metaLocation = metaLocation;
    }

    public List<String> getReleasedAttributes() {
        return this.releasedAttributes;
    }

    public void setReleasedAttributes(List<String> releasedAttributes) {
        this.releasedAttributes = releasedAttributes;
    }

    public String getSpLogoutURL() {
        return this.spLogoutURL;
    }

    public void setSpLogoutURL(String spLogoutURL) {
        this.spLogoutURL = spLogoutURL;
    }

    public GluuStatus getStatus() {
        return this.status;
    }

    public void setStatus(GluuStatus status) {
        this.status = status;
    }

    public ValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    public void setValidationStatus(ValidationStatus validationStatus) {
        this.validationStatus = validationStatus;
    }

    public List<String> getValidationLog() {
        return this.validationLog;
    }

    public void setValidationLog(List<String> validationLog) {
        this.validationLog = validationLog;
    }

    public Map<String, ProfileConfiguration> getProfileConfigurations() {
        return this.profileConfigurations;
    }

    public void setProfileConfigurations(Map<String, ProfileConfiguration> profileConfigurations) {
        this.profileConfigurations = profileConfigurations;
    }

    public static void sortByDataSourceType(List<TrustRelationship> trustRelationships) {
        Collections.sort(trustRelationships, new SortByDatasourceTypeComparator());
    }

    public String toString() {
        return "TrustRelationship [inum=" + this.inum + ", owner=" + this.owner + ", name=" + this.name + ", displayName=" + this.displayName + ", description=" + this.description + ", baseUrl=" + this.baseUrl + ", enabled=" + this.enabled + ", alwaysDisplayInConsole=" + this.alwaysDisplayInConsole + ", clientAuthenticatorType=" + this.clientAuthenticatorType + ", secret=" + this.secret + ", registrationAccessToken=" + this.registrationAccessToken + ", consentRequired=" + this.consentRequired + ", spMetaDataSourceType=" + this.spMetaDataSourceType + ", samlMetadata=" + this.samlMetadata + ", redirectUris=" + Arrays.toString(this.redirectUris) + ", spMetaDataFN=" + this.spMetaDataFN + ", spMetaDataURL=" + this.spMetaDataURL + ", metaLocation=" + this.metaLocation + ", releasedAttributes=" + this.releasedAttributes + ", spLogoutURL=" + this.spLogoutURL + ", status=" + this.status + ", validationStatus=" + this.validationStatus + ", validationLog=" + this.validationLog + ", profileConfigurations=" + this.profileConfigurations + "]";
    }

    private static class SortByDatasourceTypeComparator
    implements Comparator<TrustRelationship> {
        private SortByDatasourceTypeComparator() {
        }

        @Override
        public int compare(TrustRelationship first, TrustRelationship second) {
            return first.getSpMetaDataSourceType().getRank() - second.getSpMetaDataSourceType().getRank();
        }
    }
}

