/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.saml.service;

import io.jans.service.document.store.conf.DocumentStoreType;
import io.jans.service.document.store.service.LocalDocumentStoreService;
import io.jans.util.INumGenerator;
import io.jans.util.exception.InvalidConfigurationException;
import io.jans.xml.GluuErrorHandler;
import io.jans.xml.XMLValidator;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opensaml.saml.common.xml.SAMLSchemaBuilder;
import org.slf4j.Logger;
import org.xml.sax.SAXException;

@ApplicationScoped
public class SamlIdpService {
    @Inject
    Logger logger;
    @Inject
    private LocalDocumentStoreService localDocumentStoreService;
    private Schema samlSchema;

    @PostConstruct
    public void create() {
        SAMLSchemaBuilder samlSchemaBuilder = new SAMLSchemaBuilder(SAMLSchemaBuilder.SAML1Version.SAML_11);
        try {
            this.samlSchema = samlSchemaBuilder.getSAMLSchema();
            this.logger.debug("samlSchema:{}", (Object)this.samlSchema);
        }
        catch (Exception ex) {
            this.logger.warn("Failed to load SAMLSchema - ", (Throwable)ex);
        }
    }

    public boolean isLocalDocumentStoreType() {
        return this.localDocumentStoreService.getProviderType() == DocumentStoreType.LOCAL;
    }

    public String saveMetadataFile(String metadataDir, String metadataFileName, String documentStoreModuleName, InputStream stream) throws WebApplicationException {
        this.logger.info("metadataDir:{}, metadataFileName:{}, documentStoreModuleName:{}, stream:{}", new Object[]{metadataDir, metadataFileName, documentStoreModuleName, stream});
        if (StringUtils.isBlank((CharSequence)metadataDir)) {
            throw new InvalidConfigurationException("Failed to save file as metadata directory provided is null!");
        }
        if (StringUtils.isBlank((CharSequence)metadataFileName)) {
            throw new InvalidConfigurationException("Failed to save file as metadataFileName is null!");
        }
        if (stream == null) {
            throw new InvalidConfigurationException("Failed to save metadat as file is null!");
        }
        if (StringUtils.isBlank((CharSequence)documentStoreModuleName)) {
            documentStoreModuleName = "SAML";
        }
        String metadataFile = metadataDir + File.separator + metadataFileName;
        this.logger.info("metadataFile:{}, localDocumentStoreService:{} ", (Object)metadataFile, (Object)this.localDocumentStoreService);
        try {
            String result = this.localDocumentStoreService.saveDocumentStream(metadataFile, null, stream, documentStoreModuleName);
            this.logger.info("SAML file saving result:{}", (Object)result);
            InputStream newFile = this.localDocumentStoreService.readDocumentAsStream(metadataFile);
            this.logger.info("SAML file read newFile:{}", (Object)newFile);
            if (result != null) {
                String string = metadataFile;
                return string;
            }
        }
        catch (Exception ex) {
            throw new WebApplicationException("Failed to write SAML metadata file '{" + metadataFile + "}'", (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        return null;
    }

    public GluuErrorHandler validateMetadata(String metadataPath) throws ParserConfigurationException, SAXException, IOException {
        if (this.samlSchema == null) {
            ArrayList<String> validationLog = new ArrayList<String>();
            validationLog.add("Error of schema creating");
            validationLog.add("Failed to load SAML schema");
            return new GluuErrorHandler(false, true, validationLog);
        }
        try (InputStream stream = this.localDocumentStoreService.readDocumentAsStream(metadataPath);){
            GluuErrorHandler gluuErrorHandler = XMLValidator.validateMetadata((InputStream)stream, (Schema)this.samlSchema);
            return gluuErrorHandler;
        }
    }

    public boolean renameMetadata(String metadataPath, String destinationMetadataPath) {
        this.logger.debug("Rename metadata file documentStoreService:{},metadataPath:{}, destinationMetadataPath:{}", new Object[]{this.localDocumentStoreService, metadataPath, destinationMetadataPath});
        try {
            return this.localDocumentStoreService.renameDocument(metadataPath, destinationMetadataPath) != null;
        }
        catch (Exception ex) {
            this.logger.error("Failed to rename metadata '{}' to '{}'", new Object[]{metadataPath, destinationMetadataPath, ex});
            return false;
        }
    }

    public InputStream getFileFromDocumentStore(String path) {
        this.logger.debug("Get file from DocumentStore. Path: {}", (Object)path);
        try {
            return this.localDocumentStoreService.readDocumentAsStream(path);
        }
        catch (Exception e) {
            this.logger.error("Failed to get file '{}' from DocumentStore", (Object)path);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTempMetadataFilename(String metadataFolder, String fileName) {
        this.logger.info("localDocumentStoreService:{}, metadataFolder:{}, fileName:{}", new Object[]{this.localDocumentStoreService, metadataFolder, fileName});
        Class<SamlIdpService> clazz = SamlIdpService.class;
        synchronized (SamlIdpService.class) {
            String possibleTemp;
            do {
                possibleTemp = fileName + INumGenerator.generate((int)2);
                this.logger.debug("possibleTemp:{}", (Object)possibleTemp);
            } while (this.localDocumentStoreService.hasDocument(metadataFolder + possibleTemp));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return possibleTemp;
        }
    }
}

