/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.saml.model;

import io.jans.orm.annotation.AttributeEnum;
import java.util.HashMap;
import java.util.Map;

public enum MetadataSourceType implements AttributeEnum
{
    FILE("file", "File", 1),
    MANUAL("manual", "Manual", 2);

    private final String value;
    private final String displayName;
    private final int rank;
    private static final Map<String, MetadataSourceType> mapByValues;

    private MetadataSourceType(String value, String displayName, int rank) {
        this.value = value;
        this.displayName = displayName;
        this.rank = rank;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getRank() {
        return this.rank;
    }

    public static MetadataSourceType getByValue(String value) {
        return mapByValues.get(value);
    }

    public Enum<? extends AttributeEnum> resolveByValue(String value) {
        return MetadataSourceType.getByValue(value);
    }

    public String toString() {
        return this.value;
    }

    public static boolean contains(String name) {
        boolean result = false;
        for (MetadataSourceType direction : MetadataSourceType.values()) {
            if (!direction.name().equalsIgnoreCase(name)) continue;
            result = true;
            break;
        }
        return result;
    }

    static {
        mapByValues = new HashMap<String, MetadataSourceType>();
        for (MetadataSourceType enumType : MetadataSourceType.values()) {
            mapByValues.put(enumType.getValue(), enumType);
        }
    }
}

