/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.saml.rest;

import com.fasterxml.jackson.databind.JsonNode;
import io.jans.as.model.util.Util;
import io.jans.configapi.core.rest.BaseResource;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.plugin.saml.form.BrokerIdentityProviderForm;
import io.jans.configapi.plugin.saml.model.IdentityProvider;
import io.jans.configapi.plugin.saml.service.IdpService;
import io.jans.model.SearchRequest;
import io.jans.orm.model.PagedResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;
import org.slf4j.Logger;

@Path(value="/saml/idp")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IdpResource
extends BaseResource {
    private static final String SAML_IDP_DATA = "SAML IDP Data";
    private static final String SAML_IDP_DATA_FORM = "SAML IDP Data From";
    private static final String SAML_IDP_CHECK_STR = "IdentityProvider identified by '";
    private static final String NAME_CONFLICT = "NAME_CONFLICT";
    private static final String NAME_CONFLICT_MSG = "SAML IDP with same name %s already exists!";
    private static final String UNAUTHORIZED = "Unauthorized";
    private static final String UNAUTHORIZED_MSG = "Realm client authorization failed while creating IDP.";
    private static final String APPLICATION_ERROR = "Application Error";
    @Inject
    Logger log;
    @Inject
    IdpService idpService;

    @Operation(summary="Retrieves SAML Identity Provider", description="Retrieves SAML Identity Provider", operationId="get-saml-identity-provider", tags={"SAML - Identity Broker"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/idp/saml.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/idp/saml.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/saml.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=IdentityProviderPagedResult.class), examples={@ExampleObject(name="Response json example", value="example/idp/trust-idp/get-all-saml-identity-provider.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/idp/saml.readonly"}, groupScopes={"https://jans.io/idp/saml.write"}, superScopes={"https://jans.io/oauth/config/saml.admin", "https://jans.io/oauth/config/read-all"})
    public Response getAllSamlIdentityProvider(@Parameter(description="Search size - max size of the results to return") @DefaultValue(value="50") @QueryParam(value="limit") int limit, @Parameter(description="Search pattern") @DefaultValue(value="") @QueryParam(value="pattern") String pattern, @Parameter(description="The 1-based index of the first query result") @DefaultValue(value="0") @QueryParam(value="startIndex") int startIndex, @Parameter(description="Attribute whose value will be used to order the returned response") @DefaultValue(value="inum") @QueryParam(value="sortBy") String sortBy, @Parameter(description="Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"") @DefaultValue(value="ascending") @QueryParam(value="sortOrder") String sortOrder, @Parameter(description="Field and value pair for seraching", examples={@ExampleObject(name="Field value example", value="displayName=saml-idp,realm=jans")}) @DefaultValue(value="") @QueryParam(value="fieldValuePair") String fieldValuePair) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Client serach param - limit:{}, pattern:{}, startIndex:{}, sortBy:{}, sortOrder:{}, fieldValuePair:{}", new Object[]{Util.escapeLog((Object)limit), Util.escapeLog((Object)pattern), Util.escapeLog((Object)startIndex), Util.escapeLog((Object)sortBy), Util.escapeLog((Object)sortOrder), Util.escapeLog((Object)fieldValuePair)});
        }
        SearchRequest searchReq = this.createSearchRequest(this.idpService.getIdentityProviderDn(), pattern, sortBy, sortOrder, startIndex, limit, null, null, 200, fieldValuePair, IdentityProvider.class);
        return Response.ok((Object)((Object)this.doSearch(searchReq))).build();
    }

    @Operation(summary="Get SAML Identity Provider by Inum", description="Get SAML Identity Provider by Inum", operationId="get-saml-identity-provider-by-inum", tags={"SAML - Identity Broker"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/idp/saml.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/idp/saml.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/saml.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=IdentityProvider.class), examples={@ExampleObject(name="Response json example", value="example/idp/trust-idp/get-saml-identity-provider-by-inum.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Path(value="/{inum}")
    @ProtectedApi(scopes={"https://jans.io/idp/saml.readonly"}, groupScopes={"https://jans.io/idp/saml.write"}, superScopes={"https://jans.io/oauth/config/saml.admin", "https://jans.io/oauth/config/read-all"})
    public Response getSamlIdentityProviderByInum(@Parameter(description="Unique identifier") @PathParam(value="inum") @NotNull String inum) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Fetch SAML IDP by inum:{}", (Object)Util.escapeLog((Object)inum));
        }
        IdentityProvider idp = this.idpService.getIdentityProviderByInum(inum);
        this.log.debug("SAML IDP fetched  idp:{}", (Object)idp);
        return Response.ok((Object)idp).build();
    }

    @Operation(summary="Get SAML SP Metadata as Json", description="Get SAML SP Metadata as Json", operationId="get-saml-sp-metadata-json", tags={"SAML - Identity Broker"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/idp/saml.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/idp/saml.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/saml.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=JsonNode.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Path(value="/sp-metadata/{inum}")
    @ProtectedApi(scopes={"https://jans.io/idp/saml.readonly"}, groupScopes={"https://jans.io/idp/saml.write"}, superScopes={"https://jans.io/oauth/config/saml.admin", "https://jans.io/oauth/config/read-all"})
    public Response getSamlSPMetadataJson(@Parameter(description="Unique identifier") @PathParam(value="inum") @NotNull String inum) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Fetch SAML SP Metadata for IDP by inum:{}", (Object)Util.escapeLog((Object)inum));
        }
        String json = null;
        try {
            IdentityProvider identityProvider = this.idpService.getIdentityProviderByInum(inum);
            this.log.debug(" identityProvider:{} ", (Object)identityProvider);
            IdpResource.checkResourceNotNull((Object)identityProvider, (String)(SAML_IDP_CHECK_STR + inum + "'"));
            json = this.idpService.getSpMetadata(identityProvider);
            this.log.info(" json:{} ", (Object)json);
        }
        catch (Exception ex) {
            IdpResource.throwInternalServerException((String)"SAML_SP_METADATA", (String)ex.getMessage());
        }
        return Response.ok(json).build();
    }

    @Operation(summary="Get SAML SP Metadata Endpoint URL", description="Get SAML SP Metadata Endpoint URL", operationId="get-saml-sp-metadata-url", tags={"SAML - Identity Broker"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/idp/saml.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/idp/saml.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/saml.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Path(value="/sp-metadata-file/{inum}")
    @ProtectedApi(scopes={"https://jans.io/idp/saml.readonly"}, groupScopes={"https://jans.io/idp/saml.write"}, superScopes={"https://jans.io/oauth/config/saml.admin", "https://jans.io/oauth/config/read-all"})
    @Produces(value={"application/octet-stream"})
    public Response getSamlSPMetadataURL(@Parameter(description="Unique identifier") @PathParam(value="inum") @NotNull String inum) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Fetch SAML SP Metadata URL IDP by inum:{}", (Object)Util.escapeLog((Object)inum));
        }
        IdentityProvider identityProvider = this.idpService.getIdentityProviderByInum(inum);
        this.log.debug(" identityProvider:{} ", (Object)identityProvider);
        IdpResource.checkResourceNotNull((Object)identityProvider, (String)(SAML_IDP_CHECK_STR + inum + "'"));
        String spMetadataUrl = this.idpService.getSpMetadataUrl(identityProvider.getRealm(), identityProvider.getName());
        this.log.info(" spMetadataUrl:{} ", (Object)spMetadataUrl);
        return Response.ok((Object)spMetadataUrl).build();
    }

    @Operation(summary="Create SAML Identity Provider", description="Create SAML Identity Provider", operationId="post-saml-identity-provider", tags={"SAML - Identity Broker"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/idp/saml.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/saml.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="String representing patch-document.", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=BrokerIdentityProviderForm.class), examples={@ExampleObject(name="Response json example", value="example/idp/trust-idp/post-saml-identity-provider.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Newly created Trust IDP", content={@Content(mediaType="application/json-patch+json", schema=@Schema(implementation=IdentityProvider.class), examples={@ExampleObject(name="Response json example", value="example/idp/trust-idp/get-saml-identity-provider-by-inum.json")})}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @Consumes(value={"multipart/form-data"})
    @POST
    @Path(value="/upload")
    @ProtectedApi(scopes={"https://jans.io/idp/saml.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/saml.admin", "https://jans.io/oauth/config/write-all"})
    public Response createSamlIdentityProvider(@MultipartForm BrokerIdentityProviderForm brokerIdentityProviderForm) throws IOException {
        if (this.log.isInfoEnabled()) {
            this.log.info("Create brokerIdentityProviderForm:{}", (Object)brokerIdentityProviderForm);
        }
        IdpResource.checkResourceNotNull((Object)brokerIdentityProviderForm, (String)SAML_IDP_DATA_FORM);
        IdentityProvider idp = brokerIdentityProviderForm.getIdentityProvider();
        this.log.debug(" Create idp:{} ", (Object)idp);
        IdpResource.checkResourceNotNull((Object)idp, (String)SAML_IDP_DATA);
        IdpResource.checkNotNull((String)idp.getName(), (String)"NAME");
        IdpResource.checkNotNull((String)idp.getDisplayName(), (String)"displayName");
        List<IdentityProvider> existingIdentityProviders = this.idpService.getIdentityProviderByName(idp.getName());
        this.log.debug(" existingIdentityProviders:{} ", existingIdentityProviders);
        if (existingIdentityProviders != null && !existingIdentityProviders.isEmpty()) {
            IdpResource.throwBadRequestException((String)NAME_CONFLICT, (String)String.format(NAME_CONFLICT_MSG, idp.getName()));
        }
        InputStream metaDataFile = brokerIdentityProviderForm.getMetaDataFile();
        this.log.debug(" Create metaDataFile:{} ", (Object)metaDataFile);
        try {
            idp = this.idpService.createSamlIdentityProvider(idp, metaDataFile);
        }
        catch (WebApplicationException wex) {
            this.log.error("Application Error while creating IDP is - status:{}, message:{}", (Object)wex.getResponse().getStatus(), (Object)wex.getMessage());
            if (wex.getResponse() != null && wex.getResponse().getStatusInfo() != null && wex.getResponse().getStatusInfo().equals(Response.Status.CONFLICT)) {
                IdpResource.throwBadRequestException((String)NAME_CONFLICT, (String)String.format(NAME_CONFLICT_MSG, idp.getName()));
            } else if (wex.getResponse() != null && wex.getResponse().getStatusInfo() != null && wex.getResponse().getStatusInfo().equals(Response.Status.UNAUTHORIZED)) {
                IdpResource.throwBadRequestException((String)UNAUTHORIZED, (String)UNAUTHORIZED_MSG);
            }
            IdpResource.throwInternalServerException((String)APPLICATION_ERROR, (String)wex.getMessage());
        }
        this.log.info("Create IdentityProvider - idp:{}", (Object)idp);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)idp).build();
    }

    @Operation(summary="Update SAML Identity Provider", description="Update SAML Identity Provider", operationId="put-saml-identity-provider", tags={"SAML - Identity Broker"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/idp/saml.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/saml.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="String representing patch-document.", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=BrokerIdentityProviderForm.class), examples={@ExampleObject(name="Response json example", value="example/idp/trust-idp/put-saml-identity-provider.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Updated Trust IDP", content={@Content(mediaType="application/json-patch+json", schema=@Schema(implementation=IdentityProvider.class), examples={@ExampleObject(name="Response json example", value="example/idp/trust-idp/get-saml-identity-provider-by-inum.json")})}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @Consumes(value={"multipart/form-data"})
    @PUT
    @Path(value="/upload")
    @ProtectedApi(scopes={"https://jans.io/idp/saml.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/saml.admin", "https://jans.io/oauth/config/write-all"})
    public Response updateSamlIdentityProvider(@MultipartForm BrokerIdentityProviderForm brokerIdentityProviderForm) throws IOException {
        if (this.log.isInfoEnabled()) {
            this.log.info("Update brokerIdentityProviderForm:{}", (Object)brokerIdentityProviderForm);
        }
        IdpResource.checkResourceNotNull((Object)brokerIdentityProviderForm, (String)SAML_IDP_DATA_FORM);
        IdentityProvider idp = brokerIdentityProviderForm.getIdentityProvider();
        this.log.debug(" Update idp:{} ", (Object)idp);
        IdpResource.checkResourceNotNull((Object)idp, (String)SAML_IDP_DATA);
        IdpResource.checkNotNull((String)idp.getName(), (String)"name");
        IdpResource.checkNotNull((String)idp.getDisplayName(), (String)"displayName");
        IdpResource.checkNotNull((String)idp.getInum(), (String)"inum");
        IdentityProvider existingIdentityProvider = this.idpService.getIdentityProviderByInum(idp.getInum());
        this.log.debug(" existingIdentityProvider:{} ", (Object)existingIdentityProvider);
        IdpResource.checkResourceNotNull((Object)existingIdentityProvider, (String)(SAML_IDP_CHECK_STR + idp.getInum() + "'"));
        if (StringUtils.isBlank((CharSequence)idp.getRealm())) {
            idp.setRealm(existingIdentityProvider.getRealm());
        }
        InputStream metaDataFile = brokerIdentityProviderForm.getMetaDataFile();
        this.log.debug(" Update metaDataFile:{} ", (Object)metaDataFile);
        try {
            idp = this.idpService.updateSamlIdentityProvider(idp, metaDataFile);
        }
        catch (WebApplicationException wex) {
            this.log.error("Application Error while updating IDP is - status:{}, message:{}", (Object)wex.getResponse().getStatus(), (Object)wex.getMessage());
            if (wex.getResponse() != null && wex.getResponse().getStatusInfo() != null && wex.getResponse().getStatusInfo().equals(Response.Status.CONFLICT)) {
                IdpResource.throwBadRequestException((String)NAME_CONFLICT, (String)("SAML IDP with same name '" + idp.getName() + "' already exists!"));
            } else if (wex.getResponse() != null && wex.getResponse().getStatusInfo() != null && wex.getResponse().getStatusInfo().equals(Response.Status.UNAUTHORIZED)) {
                IdpResource.throwBadRequestException((String)"UNAUTHORIZED", (String)UNAUTHORIZED_MSG);
            }
            IdpResource.throwInternalServerException((String)APPLICATION_ERROR, (String)wex.getMessage());
        }
        this.log.info("Updated IdentityProvider idp:{}", (Object)idp);
        return Response.ok((Object)idp).build();
    }

    @Operation(summary="Delete SAML Identity Provider", description="Delete SAML Identity Provider", operationId="delete-saml-identity-provider", tags={"SAML - Identity Broker"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/idp/saml.delete"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/saml.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/delete-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @DELETE
    @Path(value="{inum}")
    @ProtectedApi(scopes={"https://jans.io/idp/saml.delete"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/saml.admin", "https://jans.io/oauth/config/delete-all"})
    public Response deleteIdentityProvider(@Parameter(description="Unique identifier") @PathParam(value="inum") @NotNull String inum) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("IdentityProvider to be deleted - inum:{} ", (Object)Util.escapeLog((Object)inum));
        }
        IdentityProvider existingIdentityProvider = this.idpService.getIdentityProviderByInum(inum);
        this.log.debug(" existingIdentityProvider:{} ", (Object)existingIdentityProvider);
        IdpResource.checkResourceNotNull((Object)existingIdentityProvider, (String)(SAML_IDP_CHECK_STR + inum + "'"));
        this.idpService.deleteIdentityProvider(existingIdentityProvider, true);
        return Response.noContent().build();
    }

    private IdentityProviderPagedResult doSearch(SearchRequest searchReq) {
        if (this.log.isInfoEnabled()) {
            this.log.info("IdentityProvider search params - searchReq:{} ", (Object)Util.escapeLog((Object)searchReq));
        }
        IdentityProviderPagedResult pagedIdentityProvider = null;
        try {
            PagedResult<IdentityProvider> pagedResult = this.idpService.getIdentityProviders(searchReq);
            if (this.log.isTraceEnabled()) {
                this.log.debug("IdentityProvider PagedResult - pagedResult:{}", pagedResult);
            }
            pagedIdentityProvider = new IdentityProviderPagedResult();
            if (pagedResult != null) {
                this.log.debug("IdentityProviders fetched - pagedResult.getEntries():{}", (Object)pagedResult.getEntries());
                List identityProviderList = pagedResult.getEntries();
                pagedIdentityProvider.setStart(pagedResult.getStart());
                pagedIdentityProvider.setEntriesCount(pagedResult.getEntriesCount());
                pagedIdentityProvider.setTotalEntriesCount(pagedResult.getTotalEntriesCount());
                pagedIdentityProvider.setEntries(identityProviderList);
            }
            this.log.info("pagedIdentityProvider:{}", (Object)pagedIdentityProvider);
        }
        catch (Exception ex) {
            IdpResource.throwInternalServerException((String)ex.getMessage());
        }
        return pagedIdentityProvider;
    }

    private class IdentityProviderPagedResult
    extends PagedResult<IdentityProvider> {
        private IdentityProviderPagedResult() {
        }
    }
}

