/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.saml.service;

import io.jans.as.common.model.registration.Client;
import io.jans.as.common.service.OrganizationService;
import io.jans.as.common.service.common.InumService;
import io.jans.configapi.configuration.ConfigurationFactory;
import io.jans.configapi.plugin.saml.model.IdentityProvider;
import io.jans.configapi.plugin.saml.service.SamlConfigService;
import io.jans.configapi.plugin.saml.service.SamlIdpService;
import io.jans.model.GluuStatus;
import io.jans.model.SearchRequest;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SortOrder;
import io.jans.orm.search.filter.Filter;
import io.jans.util.StringHelper;
import io.jans.util.exception.InvalidConfigurationException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class IdentityProviderService {
    @Inject
    Logger log;
    @Inject
    PersistenceEntryManager persistenceEntryManager;
    @Inject
    ConfigurationFactory configurationFactory;
    @Inject
    OrganizationService organizationService;
    @Inject
    private InumService inumService;
    @Inject
    SamlConfigService samlConfigService;
    @Inject
    SamlIdpService samlIdpService;

    public boolean containsIdentityProvider(String dn) {
        return this.persistenceEntryManager.contains(dn, IdentityProvider.class);
    }

    public IdentityProvider getIdentityProviderByDn(String dn) {
        if (StringHelper.isNotEmpty((String)dn)) {
            try {
                return (IdentityProvider)this.persistenceEntryManager.find(IdentityProvider.class, (Object)dn);
            }
            catch (Exception e) {
                this.log.error(e.getMessage());
            }
        }
        return null;
    }

    public List<IdentityProvider> getAllIdentityProviders() {
        return this.persistenceEntryManager.findEntries(this.getDnForIdentityProvider(null), IdentityProvider.class, null);
    }

    public List<IdentityProvider> getAllIdentityProviders(int sizeLimit) {
        return this.persistenceEntryManager.findEntries(this.getDnForIdentityProvider(null), IdentityProvider.class, null, sizeLimit);
    }

    public IdentityProvider getIdentityProviderByUnpunctuatedInum(String unpunctuated) {
        for (IdentityProvider idp : this.getAllIdentityProviders()) {
            if (!StringHelper.removePunctuation((String)idp.getInum()).equals(unpunctuated)) continue;
            return idp;
        }
        return null;
    }

    public List<IdentityProvider> getAllActiveIdentityProviders() {
        IdentityProvider identityProvider = new IdentityProvider();
        identityProvider.setBaseDn(this.getDnForIdentityProvider(null));
        identityProvider.setStatus(GluuStatus.ACTIVE);
        return this.persistenceEntryManager.findEntries((Object)identityProvider);
    }

    public IdentityProvider getIdentityProviderByInum(String inum) {
        IdentityProvider result = null;
        try {
            result = (IdentityProvider)this.persistenceEntryManager.find(IdentityProvider.class, (Object)this.getDnForIdentityProvider(inum));
        }
        catch (Exception ex) {
            this.log.error("Failed to load IdentityProvider entry", (Throwable)ex);
        }
        return result;
    }

    public List<IdentityProvider> getIdentityProviderByName(String name) {
        this.log.info("Search IdentityProvider with name:{}", (Object)name);
        Filter nameFilter = Filter.createEqualityFilter((String)"NAME", (Object)name);
        this.log.debug("Search IdentityProvider with displayNameFilter:{}", (Object)nameFilter);
        return this.persistenceEntryManager.findEntries(this.getDnForIdentityProvider(null), IdentityProvider.class, nameFilter);
    }

    public IdentityProvider getIdentityProvider(IdentityProvider identityProvider) {
        return this.getIdentityProviderByDn(identityProvider.getDn());
    }

    public IdentityProvider getIdentityProvider(String dn) {
        return this.getIdentityProviderByDn(dn);
    }

    public List<IdentityProvider> searchIdentityProvider(String pattern, int sizeLimit) {
        this.log.info("Search IdentityProvider with pattern:{}, sizeLimit:{}", (Object)pattern, (Object)sizeLimit);
        String[] targetArray = new String[]{pattern};
        Filter nameFilter = Filter.createSubstringFilter((String)"NAME", null, (String[])targetArray, null);
        Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
        Filter inumFilter = Filter.createSubstringFilter((String)"inum", null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{nameFilter, displayNameFilter, descriptionFilter, inumFilter});
        this.log.trace("Search IdentityProvider with searchFilter:{}", (Object)searchFilter);
        return this.persistenceEntryManager.findEntries(this.getDnForIdentityProvider(null), IdentityProvider.class, searchFilter, sizeLimit);
    }

    public List<IdentityProvider> getAllIdentityProvider(int sizeLimit) {
        return this.persistenceEntryManager.findEntries(this.getDnForIdentityProvider(null), IdentityProvider.class, null, sizeLimit);
    }

    public PagedResult<IdentityProvider> getIdentityProvider(SearchRequest searchRequest) {
        this.log.info("Search IdentityProvider with searchRequest:{}", (Object)searchRequest);
        Filter searchFilter = null;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (searchRequest.getFilterAssertionValue() != null && !searchRequest.getFilterAssertionValue().isEmpty()) {
            for (String assertionValue : searchRequest.getFilterAssertionValue()) {
                String[] targetArray = new String[]{assertionValue};
                Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
                Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
                Filter inumFilter = Filter.createSubstringFilter((String)"inum", null, (String[])targetArray, null);
                filters.add(Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter, inumFilter}));
            }
            searchFilter = Filter.createORFilter(filters);
        }
        this.log.debug("IdentityProvider pattern searchFilter:{}", searchFilter);
        ArrayList<Filter> fieldValueFilters = new ArrayList<Filter>();
        if (searchRequest.getFieldValueMap() != null && !searchRequest.getFieldValueMap().isEmpty()) {
            for (Map.Entry entry : searchRequest.getFieldValueMap().entrySet()) {
                Filter dataFilter = Filter.createEqualityFilter((String)((String)entry.getKey()), entry.getValue());
                this.log.debug("IdentityProvider dataFilter:{}", (Object)dataFilter);
                fieldValueFilters.add(Filter.createANDFilter((Filter[])new Filter[]{dataFilter}));
            }
            searchFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createORFilter(filters), Filter.createANDFilter(fieldValueFilters)});
        }
        this.log.debug("IdentityProvider searchFilter:{}", (Object)searchFilter);
        return this.persistenceEntryManager.findPagedEntries(this.getDnForIdentityProvider(null), IdentityProvider.class, searchFilter, null, searchRequest.getSortBy(), SortOrder.getByValue((String)searchRequest.getSortOrder()), searchRequest.getStartIndex().intValue(), searchRequest.getCount().intValue(), searchRequest.getMaxCount());
    }

    public IdentityProvider addSamlIdentityProvider(IdentityProvider identityProvider, InputStream file) throws IOException {
        this.log.info("Add new identityProvider:{}, file:{}", (Object)identityProvider, (Object)file);
        if (file != null && file.available() > 0) {
            this.log.info("Save IDP metadatfile on server");
            this.saveIdpMetaDataFileSourceTypeFile(identityProvider, file);
            this.log.info("After saving IDP metadatfile on server - identityProvider:{}", (Object)identityProvider);
        } else {
            identityProvider.setIdpMetaDataFN(null);
        }
        this.log.info("Persist IDP in DB identityProvider:{}", (Object)identityProvider);
        this.persistenceEntryManager.persist((Object)identityProvider);
        this.log.info("After Persisting IDP");
        return this.getIdentityProviderByInum(identityProvider.getInum());
    }

    public IdentityProvider updateIdentityProvider(IdentityProvider identityProvider) throws IOException {
        return this.updateIdentityProvider(identityProvider, null);
    }

    public IdentityProvider updateIdentityProvider(IdentityProvider identityProvider, InputStream file) throws IOException {
        if (identityProvider == null) {
            return identityProvider;
        }
        if (file != null && file.available() > 0) {
            this.saveIdpMetaDataFileSourceTypeFile(identityProvider, file);
        } else {
            identityProvider.setIdpMetaDataFN(null);
        }
        this.persistenceEntryManager.merge((Object)identityProvider);
        return this.getIdentityProviderByInum(identityProvider.getInum());
    }

    public void removeIdentityProvider(IdentityProvider identityProvider) {
        this.persistenceEntryManager.removeRecursively(identityProvider.getDn(), IdentityProvider.class);
    }

    public String getDnForIdentityProvider(String inum) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=trusted-idp,%s", orgDn);
        }
        return String.format("inum=%s,ou=trusted-idp,%s", inum, orgDn);
    }

    public String generateInumForIdentityProvider() {
        String newInum = null;
        String newDn = null;
        while (this.containsIdentityProvider(newDn = this.getDnForIdentityProvider(newInum = UUID.randomUUID().toString()))) {
        }
        return newInum;
    }

    public String generateInumForNewIdentityProvider() {
        String newInum = null;
        String newDn = null;
        int trycount = 0;
        do {
            if (trycount < 10) {
                newInum = this.inumService.generateId("idp");
                ++trycount;
                continue;
            }
            newInum = this.inumService.generateDefaultId();
        } while (this.persistenceEntryManager.contains(newDn = this.getDnForIdentityProvider(newInum), Client.class));
        return newInum;
    }

    private boolean saveIdpMetaDataFileSourceTypeFile(IdentityProvider identityProvider, InputStream file) {
        this.log.debug("Saving idp {} metadata file : {}", (Object)identityProvider.getInum(), (Object)file);
        if (identityProvider == null || file == null) {
            return false;
        }
        String idpMetaDataFN = this.getIdpNewMetadataFileName(identityProvider);
        identityProvider.setIdpMetaDataFN(idpMetaDataFN);
        identityProvider.setIdpMetaDataLocation(this.getIdpMetadataTempDirFilePath());
        InputStream targetStream = file;
        this.log.debug("targetStream: {}, idpMetaDataFN: {}", (Object)targetStream, (Object)idpMetaDataFN);
        String result = this.samlIdpService.saveMetadataFile(this.getIdpMetadataTempDirFilePath(), idpMetaDataFN, "idp-module", targetStream);
        this.log.debug("targetStream:{}, idpMetaDataFN:{}, result:{}", new Object[]{targetStream, idpMetaDataFN, result});
        if (StringHelper.isNotEmpty((String)result)) {
            this.log.info("IDP metadata file saved inum: {} , filename: {}", (Object)identityProvider.getInum(), (Object)idpMetaDataFN);
            return true;
        }
        this.log.error("Failed to save IDP metadata file for IdentityProvider {}. filename: {}", (Object)identityProvider.getInum(), (Object)idpMetaDataFN);
        return false;
    }

    private String getIdpNewMetadataFileName(IdentityProvider identityProvider) {
        String idpMetaDataFN = null;
        if (identityProvider == null) {
            return idpMetaDataFN;
        }
        this.log.info("idpConfigService.getIdpMetadataFileName(identityProvider.getInum()):{}", (Object)this.getIdpMetadataFileName(identityProvider.getInum()));
        return this.getIdpMetadataFileName(identityProvider.getInum());
    }

    private String getIdpMetadataTempDirFilePath(String idpMetaDataFN) {
        this.log.debug("idpMetaDataFN:{}", (Object)idpMetaDataFN);
        if (StringUtils.isBlank((CharSequence)this.getIdpMetadataTempDirFilePath())) {
            throw new InvalidConfigurationException("Failed to return IDP metadata file path as undefined!");
        }
        return this.getIdpMetadataTempDirFilePath() + idpMetaDataFN;
    }

    private String getIdpMetadataFileName(String inum) {
        String id = StringHelper.removePunctuation((String)inum);
        return String.format(this.samlConfigService.getIdpMetadataFilePattern(), id);
    }

    private String getIdpMetadataTempDirFilePath() {
        return this.samlConfigService.getIdpMetadataTempDir();
    }
}

