/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.lock.rest;

import com.fasterxml.jackson.databind.JsonNode;
import io.jans.as.model.util.Util;
import io.jans.configapi.core.model.exception.ApiApplicationException;
import io.jans.configapi.core.rest.BaseResource;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.plugin.lock.service.LockService;
import io.jans.configapi.service.auth.ConfigurationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Path(value="/lockStat")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LockStatResource
extends BaseResource {
    private static final String STAT_URL = "/jans-lock/v1/internal/stat";
    @Inject
    Logger logger;
    @Inject
    ConfigurationService configurationService;
    @Inject
    LockService lockService;

    @Operation(summary="Provides basic statistic", description="Provides basic statistic", operationId="get-lock-stat", tags={"Statistics"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/read-all", "jans_stat"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Stats", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=JsonNode.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/lock/read-all", "jans_stat"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/read-all"})
    @Produces(value={"application/json"})
    public Response getStatistics(@Parameter(description="Authorization code") @HeaderParam(value="Authorization") String authorization, @Parameter(description="Month for which the stat report is to be fetched. The parameter is mandatory if start_month and end_month parameters are not present.") @QueryParam(value="month") String month, @Parameter(description="Start-Month for which the stat report is to be fetched") @QueryParam(value="start-month") String startMonth, @Parameter(description="End-Month for which the stat report is to be fetched") @QueryParam(value="end-month") String endMonth, @Parameter(description="Report format") @QueryParam(value="format") String format) {
        if (StringUtils.isBlank((CharSequence)format)) {
            format = "";
        }
        JsonNode jsonNode = null;
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("LockStatResource::getStatistics() - authorization:{}, month:{},  startMonth:{}, endMonth:{}, format:{}", new Object[]{Util.escapeLog((Object)authorization), Util.escapeLog((Object)month), Util.escapeLog((Object)startMonth), Util.escapeLog((Object)endMonth), Util.escapeLog((Object)format)});
            }
            String url = this.getIssuer() + STAT_URL;
            jsonNode = this.lockService.getStat(url, authorization, month, startMonth, endMonth, format);
            this.logger.info("StatResource::getUserStatistics() - jsonNode:{} ", (Object)jsonNode);
        }
        catch (ApiApplicationException aex) {
            this.logger.error(" ApiApplicationException while fetching lock stat is", (Throwable)aex);
            LockStatResource.throwInternalServerException((String)"Stat Error", (Throwable)aex);
        }
        catch (Exception ex) {
            this.logger.error(" Error while fetching lock stat is", (Throwable)ex);
            LockStatResource.throwBadRequestException((Object)ex);
        }
        return Response.ok(jsonNode).build();
    }

    private String getIssuer() {
        return this.configurationService.find().getIssuer();
    }
}

