/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.lock.service;

import io.jans.configapi.configuration.ConfigurationFactory;
import io.jans.lock.model.config.AppConfiguration;
import io.jans.lock.model.config.Conf;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.util.properties.FileConfiguration;
import io.jans.util.exception.InvalidConfigurationException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class LockConfigService {
    @Inject
    Logger logger;
    @Inject
    @Named(value="persistenceEntryManager")
    PersistenceEntryManager persistenceManager;
    @Inject
    ConfigurationFactory configurationFactory;

    public FileConfiguration getBaseConfiguration() {
        this.logger.info(" configurationFactory.getBaseConfiguration():{}", (Object)this.configurationFactory.getBaseConfiguration());
        return this.configurationFactory.getBaseConfiguration();
    }

    public String getLockDn() {
        String dn = this.getBaseConfiguration().getString("lock_ConfigurationEntryDN");
        this.logger.info(" lockDn:{}", (Object)dn);
        return dn;
    }

    public Conf findLockConf() {
        String dn = this.getLockDn();
        this.logger.info(" dn:{}", (Object)dn);
        if (StringUtils.isBlank((CharSequence)dn)) {
            throw new InvalidConfigurationException("Lock Configuration DN is undefined!");
        }
        Conf lockconf = (Conf)this.persistenceManager.find((Object)dn, Conf.class, null);
        this.logger.info(" lockconf:{}", (Object)lockconf);
        return lockconf;
    }

    public void mergeLockConfig(Conf lockconf) {
        lockconf.setRevision(lockconf.getRevision() + 1L);
        this.persistenceManager.merge((Object)lockconf);
    }

    public AppConfiguration find() {
        return this.findLockConf().getDynamic();
    }
}

