/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.lock.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.jans.as.model.util.Util;
import io.jans.configapi.core.model.exception.ApiApplicationException;
import io.jans.configapi.core.service.ConfigHttpService;
import io.jans.configapi.core.util.Jackson;
import io.jans.model.net.HttpServiceResponse;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class LockService {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String AUTHORIZATION = "Authorization";
    @Inject
    Logger logger;
    @Inject
    ConfigHttpService configHttpService;

    public JsonNode getStat(String url, String token, String month, String startMonth, String endMonth, String format) throws ApiApplicationException, JsonProcessingException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("LockStatResource::getStatistics() - url:{}, token:{}, month:{},  startMonth:{}, endMonth:{}, format:{}", new Object[]{Util.escapeLog((Object)url), Util.escapeLog((Object)token), Util.escapeLog((Object)month), Util.escapeLog((Object)startMonth), Util.escapeLog((Object)endMonth), Util.escapeLog((Object)format)});
        }
        JsonNode jsonNode = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(CONTENT_TYPE, "application/json");
        if (StringUtils.isNotBlank((CharSequence)token)) {
            headers.put(AUTHORIZATION, token);
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("month", month);
        data.put("start-month", startMonth);
        data.put("end-month", endMonth);
        data.put("format", format);
        HttpServiceResponse httpServiceResponse = this.configHttpService.executeGet(url, headers, data);
        this.logger.info(" stat httpServiceResponse:{}", (Object)httpServiceResponse);
        if (httpServiceResponse != null) {
            this.logger.info(" stat httpServiceResponse.getHttpResponse():{}, httpServiceResponse.getHttpResponse().getStatusLine():{}, httpServiceResponse.getHttpResponse().getEntity():{}", new Object[]{httpServiceResponse.getHttpResponse(), httpServiceResponse.getHttpResponse().getStatusLine(), httpServiceResponse.getHttpResponse().getEntity()});
            jsonNode = this.getResponseJsonNode(httpServiceResponse);
        }
        this.logger.info(" stat jsonNode:{}", jsonNode);
        return jsonNode;
    }

    public JsonNode getResponseJsonNode(HttpServiceResponse serviceResponse) throws ApiApplicationException, JsonProcessingException {
        JsonNode jsonNode = null;
        if (serviceResponse == null) {
            return jsonNode;
        }
        return this.getResponseJsonNode(this.getResponseEntityString(serviceResponse), "response");
    }

    public String getResponseEntityString(HttpServiceResponse serviceResponse) throws ApiApplicationException {
        String jsonString = null;
        if (serviceResponse == null) {
            return jsonString;
        }
        HttpResponse httpResponse = serviceResponse.getHttpResponse();
        if (httpResponse != null) {
            HttpEntity entity = httpResponse.getEntity();
            this.logger.debug("entity:{}, httpResponse.getStatusLine().getStatusCode():{}", (Object)entity, (Object)httpResponse.getStatusLine().getStatusCode());
            if (entity == null) {
                return jsonString;
            }
            try {
                jsonString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            catch (Exception ex) {
                this.logger.error("Error while getting entity using EntityUtils is ", (Throwable)ex);
            }
            if (httpResponse.getStatusLine() != null && httpResponse.getStatusLine().getStatusCode() == Response.Status.OK.getStatusCode()) {
                return jsonString;
            }
            throw new ApiApplicationException(httpResponse.getStatusLine().getStatusCode(), jsonString);
        }
        return jsonString;
    }

    public JsonNode getResponseJsonNode(String jsonSring, String nodeName) throws JsonProcessingException {
        JsonNode jsonNode = null;
        if (StringUtils.isBlank((CharSequence)jsonSring)) {
            return jsonNode;
        }
        jsonNode = Jackson.asJsonNode((String)jsonSring);
        if (StringUtils.isNotBlank((CharSequence)nodeName) && jsonNode != null && jsonNode.get(nodeName) != null) {
            jsonNode = jsonNode.get("response");
        }
        return jsonNode;
    }
}

