/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.lock.service;

import io.jans.as.common.service.OrganizationService;
import io.jans.as.common.service.common.InumService;
import io.jans.configapi.configuration.ConfigurationFactory;
import io.jans.lock.model.audit.HealthEntry;
import io.jans.lock.model.audit.LogEntry;
import io.jans.lock.model.audit.TelemetryEntry;
import io.jans.model.SearchRequest;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SortOrder;
import io.jans.orm.search.filter.Filter;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class AuditService {
    @Inject
    Logger logger;
    public static final String EVENT_TIME = "eventTime";
    @Inject
    @Named(value="persistenceEntryManager")
    PersistenceEntryManager persistenceEntryManager;
    @Inject
    ConfigurationFactory configurationFactory;
    @Inject
    OrganizationService organizationService;
    @Inject
    private InumService inumService;

    public TelemetryEntry addTelemetryData(TelemetryEntry telemetryEntry) {
        if (telemetryEntry == null) {
            return telemetryEntry;
        }
        String inum = telemetryEntry.getInum();
        if (StringUtils.isBlank((CharSequence)inum)) {
            inum = this.generateInumForEntry("telemetry", TelemetryEntry.class);
            telemetryEntry.setInum(inum);
            telemetryEntry.setDn(this.getDnForTelemetryEntry(inum));
        }
        this.persistenceEntryManager.persist((Object)telemetryEntry);
        telemetryEntry = this.getTelemetryEntryByDn(this.getDnForTelemetryEntry(inum));
        return telemetryEntry;
    }

    public void removeTelemetryEntry(TelemetryEntry telemetryEntry) {
        this.persistenceEntryManager.removeRecursively(telemetryEntry.getDn(), TelemetryEntry.class);
    }

    public void updateTelemetryEntry(TelemetryEntry telemetryEntry) {
        this.persistenceEntryManager.merge((Object)telemetryEntry);
    }

    public TelemetryEntry getTelemetryEntryByInum(String inum) {
        TelemetryEntry result = null;
        try {
            result = (TelemetryEntry)this.persistenceEntryManager.find(TelemetryEntry.class, (Object)this.getTelemetryEntryByDn(inum));
        }
        catch (Exception ex) {
            this.logger.error("Failed to load TelemetryEntry entry", (Throwable)ex);
        }
        return result;
    }

    public List<TelemetryEntry> searchTelemetryEntrys(String pattern, int sizeLimit) {
        this.logger.debug("Search TelemetryEntrys with pattern:{}, sizeLimit:{}", (Object)pattern, (Object)sizeLimit);
        String[] targetArray = new String[]{pattern};
        Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
        Filter inumFilter = Filter.createSubstringFilter((String)"inum", null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter, inumFilter});
        this.logger.debug("Search TelemetryEntrys with searchFilter:{}", (Object)searchFilter);
        return this.persistenceEntryManager.findEntries(this.getDnForTelemetryEntry(null), TelemetryEntry.class, searchFilter, sizeLimit);
    }

    public List<TelemetryEntry> getAllTelemetryEntrys(int sizeLimit) {
        return this.persistenceEntryManager.findEntries(this.getDnForTelemetryEntry(null), TelemetryEntry.class, null, sizeLimit);
    }

    public List<TelemetryEntry> getAllTelemetryEntrys() {
        return this.persistenceEntryManager.findEntries(this.getDnForTelemetryEntry(null), TelemetryEntry.class, null);
    }

    public PagedResult<TelemetryEntry> getTelemetryEntrys(SearchRequest searchRequest) {
        this.logger.debug("Search TelemetryEntrys with searchRequest:{}", (Object)searchRequest);
        Filter searchFilter = null;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (searchRequest.getFilterAssertionValue() != null && !searchRequest.getFilterAssertionValue().isEmpty()) {
            for (String assertionValue : searchRequest.getFilterAssertionValue()) {
                String[] targetArray = new String[]{assertionValue};
                Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
                Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
                Filter inumFilter = Filter.createSubstringFilter((String)"inum", null, (String[])targetArray, null);
                filters.add(Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter, inumFilter}));
            }
            searchFilter = Filter.createORFilter(filters);
        }
        this.logger.trace("TelemetryEntrys pattern searchFilter:{}", searchFilter);
        ArrayList<Filter> fieldValueFilters = new ArrayList<Filter>();
        if (searchRequest.getFieldValueMap() != null && !searchRequest.getFieldValueMap().isEmpty()) {
            for (Map.Entry entry : searchRequest.getFieldValueMap().entrySet()) {
                Filter dataFilter = Filter.createEqualityFilter((String)((String)entry.getKey()), entry.getValue());
                this.logger.trace("TelemetryEntrys dataFilter:{}", (Object)dataFilter);
                fieldValueFilters.add(Filter.createANDFilter((Filter[])new Filter[]{dataFilter}));
            }
            searchFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createORFilter(filters), Filter.createANDFilter(fieldValueFilters)});
        }
        this.logger.debug("TelemetryEntrys searchFilter:{}", (Object)searchFilter);
        return this.persistenceEntryManager.findPagedEntries(this.getDnForTelemetryEntry(null), TelemetryEntry.class, searchFilter, null, searchRequest.getSortBy(), SortOrder.getByValue((String)searchRequest.getSortOrder()), searchRequest.getStartIndex().intValue(), searchRequest.getCount().intValue(), searchRequest.getMaxCount());
    }

    public List<TelemetryEntry> getTelemetryEntrysByRange(Date eventStartDate, Date eventEndDate, int sizeLimit) {
        this.logger.debug("Search TelemetryEntrys by event range: [{}, {}], sizeLimit:{}", new Object[]{eventStartDate, eventEndDate, sizeLimit});
        String baseDn = this.getDnForTelemetryEntry(null);
        Filter eventStartDateFilter = Filter.createGreaterOrEqualFilter((String)EVENT_TIME, (Object)this.persistenceEntryManager.encodeTime(baseDn, eventStartDate));
        Filter eventEndDateFilter = Filter.createLessOrEqualFilter((String)EVENT_TIME, (Object)this.persistenceEntryManager.encodeTime(baseDn, eventEndDate));
        Filter searchFilter = Filter.createANDFilter((Filter[])new Filter[]{eventStartDateFilter, eventEndDateFilter});
        this.logger.debug("Search TelemetryEntrys with searchFilter: {}", (Object)searchFilter);
        return this.persistenceEntryManager.findEntries(baseDn, TelemetryEntry.class, searchFilter, sizeLimit);
    }

    public TelemetryEntry getTelemetryEntryByDn(String dn) {
        try {
            return (TelemetryEntry)this.persistenceEntryManager.find(TelemetryEntry.class, (Object)dn);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    public String getDnForTelemetryEntry(String inum) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=telemetry,ou=lock,%s", orgDn);
        }
        return String.format("inum=%s,ou=telemetry,ou=lock,%s", inum, orgDn);
    }

    public HealthEntry addHealthEntry(HealthEntry healthEntry) {
        if (healthEntry == null) {
            return healthEntry;
        }
        String inum = healthEntry.getInum();
        if (StringUtils.isBlank((CharSequence)inum)) {
            inum = this.generateInumForEntry("health", HealthEntry.class);
            healthEntry.setInum(inum);
            healthEntry.setDn(this.getDnForHealthEntry(inum));
        }
        this.persistenceEntryManager.persist((Object)healthEntry);
        healthEntry = this.getHealthEntryByDn(this.getDnForHealthEntry(inum));
        return healthEntry;
    }

    public List<HealthEntry> getHealthEntrysByRange(Date eventDateStart, Date eventDateEnd, int sizeLimit) {
        this.logger.debug("Search HealthEntrys by event range: [{}, {}], sizeLimit:{}", new Object[]{eventDateStart, eventDateEnd, sizeLimit});
        String baseDn = this.getDnForHealthEntry(null);
        Filter eventDateStartFilter = Filter.createGreaterOrEqualFilter((String)EVENT_TIME, (Object)this.persistenceEntryManager.encodeTime(baseDn, eventDateStart));
        Filter eventDateEndFilter = Filter.createLessOrEqualFilter((String)EVENT_TIME, (Object)this.persistenceEntryManager.encodeTime(baseDn, eventDateEnd));
        Filter searchFilter = Filter.createANDFilter((Filter[])new Filter[]{eventDateStartFilter, eventDateEndFilter});
        this.logger.debug("Search HealthEntrys with searchFilter: {}", (Object)searchFilter);
        return this.persistenceEntryManager.findEntries(baseDn, HealthEntry.class, searchFilter, sizeLimit);
    }

    public HealthEntry getHealthEntryByDn(String dn) {
        try {
            return (HealthEntry)this.persistenceEntryManager.find(HealthEntry.class, (Object)dn);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    public String getDnForHealthEntry(String inum) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=health,ou=lock,%s", orgDn);
        }
        return String.format("inum=%s,ou=health,ou=lock,%s", inum, orgDn);
    }

    public LogEntry addLogData(LogEntry logEntry) {
        if (logEntry == null) {
            return logEntry;
        }
        String inum = logEntry.getInum();
        if (StringUtils.isBlank((CharSequence)inum)) {
            inum = this.generateInumForEntry("log", LogEntry.class);
            logEntry.setInum(inum);
            logEntry.setDn(this.getDnForLogEntry(inum));
        }
        this.persistenceEntryManager.persist((Object)logEntry);
        logEntry = this.getLogEntryByDn(this.getDnForLogEntry(inum));
        return logEntry;
    }

    public List<LogEntry> getLogEntrysByRange(Date eventDateStart, Date eventDateEnd, int sizeLimit) {
        this.logger.debug("Search LogEntrys by event range: [{}, {}], sizeLimit:{}", new Object[]{eventDateStart, eventDateEnd, sizeLimit});
        String baseDn = this.getDnForLogEntry(null);
        Filter eventDateStartFilter = Filter.createGreaterOrEqualFilter((String)EVENT_TIME, (Object)this.persistenceEntryManager.encodeTime(baseDn, eventDateStart));
        Filter eventDateEndFilter = Filter.createLessOrEqualFilter((String)EVENT_TIME, (Object)this.persistenceEntryManager.encodeTime(baseDn, eventDateEnd));
        Filter searchFilter = Filter.createANDFilter((Filter[])new Filter[]{eventDateStartFilter, eventDateEndFilter});
        this.logger.debug("Search LogEntrys with searchFilter: {}", (Object)searchFilter);
        return this.persistenceEntryManager.findEntries(baseDn, LogEntry.class, searchFilter, sizeLimit);
    }

    public LogEntry getLogEntryByDn(String dn) {
        try {
            return (LogEntry)this.persistenceEntryManager.find(LogEntry.class, (Object)dn);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    public String getDnForLogEntry(String inum) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=log,ou=lock,%s", orgDn);
        }
        return String.format("inum=%s,ou=log,ou=lock,%s", inum, orgDn);
    }

    public String generateInumForEntry(String entryName, Class classObj) {
        String newInum = null;
        String newDn = null;
        int trycount = 0;
        do {
            if (trycount < 10) {
                newInum = this.inumService.generateId(entryName);
                ++trycount;
                continue;
            }
            newInum = this.inumService.generateDefaultId();
        } while (this.persistenceEntryManager.contains(newDn = this.getDnForLogEntry(newInum), classObj));
        return newInum;
    }
}

