/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.lock.rest;

import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import io.jans.configapi.core.rest.BaseResource;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.plugin.lock.service.LockConfigService;
import io.jans.lock.model.config.AppConfiguration;
import io.jans.lock.model.config.Conf;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.slf4j.Logger;

@Path(value="/lockConfig")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LockConfigResource
extends BaseResource {
    private static final String CONFIG_NULL_ERR_MSG = "It seems Lock module is not setup, kindly check.";
    @Inject
    Logger logger;
    @Inject
    LockConfigService lockConfigService;

    @Operation(summary="Gets Lock configuration properties", description="Gets Lock configuration properties", operationId="get-lock-properties", tags={"Lock - Configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock-config.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock-config.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/lock.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppConfiguration.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/lock-config.readonly"}, groupScopes={"https://jans.io/oauth/lock-config.write"}, superScopes={"https://jans.io/oauth/config/lock.admin", "https://jans.io/oauth/lock/read-all", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    public Response getlockConf() {
        AppConfiguration lockConfiguration = this.lockConfigService.find();
        this.logger.info("Lock details lockConfiguration():{}", (Object)lockConfiguration);
        if (lockConfiguration == null) {
            LockConfigResource.throwInternalServerException((String)CONFIG_NULL_ERR_MSG);
        }
        return Response.ok((Object)lockConfiguration).build();
    }

    @Operation(summary="Update Lock configuration properties", description="Update Lock configuration properties", operationId="put-lock-properties", tags={"Lock - Configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock-config.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/lock.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/write-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="GluuAttribute object", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppConfiguration.class), examples={@ExampleObject(name="Request example", value="example/lock/config/lock-put.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppConfiguration.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PUT
    @ProtectedApi(scopes={"https://jans.io/oauth/lock-config.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/lock.admin", "https://jans.io/oauth/lock/write-all", "https://jans.io/oauth/config/write-all"})
    public Response updatelockConf(@Valid AppConfiguration lockAppConf) {
        this.logger.info("Update Lock conf details lockAppConf():{}", (Object)lockAppConf);
        Conf conf = this.lockConfigService.findLockConf();
        this.logger.info("Lock conf:{} ", (Object)conf);
        if (conf == null) {
            LockConfigResource.throwInternalServerException((String)CONFIG_NULL_ERR_MSG);
        }
        conf.setDynamic(lockAppConf);
        this.lockConfigService.mergeLockConfig(conf);
        lockAppConf = this.lockConfigService.find();
        this.logger.info("Lock conf, post update - lockAppConf:{}", (Object)lockAppConf);
        return Response.ok((Object)lockAppConf).build();
    }

    @Operation(summary="Partially modifies Lock configuration properties.", description="Partially modifies Lock configuration properties.", operationId="patch-lock-properties", tags={"Lock - Configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock-config.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/lock.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/write-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="String representing patch-document.", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=JsonPatch.class)), examples={@ExampleObject(name="Request json example", value="example/lock/config/lock-patch.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppConfiguration.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/lock-config.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/lock.admin", "https://jans.io/oauth/lock/write-all", "https://jans.io/oauth/config/write-all"})
    public Response patchlockConf(@NotNull String jsonPatchString) throws JsonPatchException, IOException {
        this.logger.info("Lock Config - jsonPatchString:{} ", (Object)jsonPatchString);
        Conf conf = this.lockConfigService.findLockConf();
        this.logger.info("Lock conf:{} ", (Object)conf);
        if (conf == null) {
            LockConfigResource.throwInternalServerException((String)CONFIG_NULL_ERR_MSG);
        }
        AppConfiguration lockAppConf = (AppConfiguration)Jackson.applyPatch((String)jsonPatchString, (Object)conf.getDynamic());
        this.logger.info("Lock conf details lockAppConf():{}", (Object)lockAppConf);
        conf.setDynamic(lockAppConf);
        this.lockConfigService.mergeLockConfig(conf);
        lockAppConf = this.lockConfigService.find();
        this.logger.info("Lock post patch - lockAppConf:{}", (Object)lockAppConf);
        return Response.ok((Object)lockAppConf).build();
    }
}

