/*
 * Decompiled with CFR 0.152.
 */
package io.jans.lock.model.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.jans.lock.model.config.AuditPersistenceMode;
import io.jans.lock.model.config.Configuration;
import io.jans.lock.model.config.LockProtectionMode;
import io.jans.lock.model.config.cedarling.CedarlingConfiguration;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.enterprise.inject.Vetoed;
import java.util.List;

@Vetoed
@JsonIgnoreProperties(ignoreUnknown=true)
public class AppConfiguration
implements Configuration {
    @Schema(description="Entry Base distinguished name (DN) that identifies the starting point of a search")
    private String baseDN;
    @Schema(description="Lock base endpoint URL")
    private String baseEndpoint;
    @Schema(description="OpenID issuer URL")
    private String openIdIssuer;
    @Schema(description="Protection mode for the Lock server (OAuth or Cedarling)")
    private LockProtectionMode protectionMode = LockProtectionMode.OAUTH;
    @Schema(description="Audit persistence mode")
    private AuditPersistenceMode auditPersistenceMode = AuditPersistenceMode.INTERNAL;
    @Schema(description="Cedarling configuration")
    private CedarlingConfiguration cedarlingConfiguration;
    @Schema(description="Active stat enabled")
    private boolean statEnabled;
    @Schema(description="Statistical data capture time interval")
    private int statTimerIntervalInSeconds;
    @Schema(description="List of token channel names")
    private List<String> tokenChannels;
    @Schema(description="Lock Client ID")
    private String clientId;
    @Schema(description="Lock client password")
    private String clientPassword;
    @Schema(description="Choose whether to disable JDK loggers")
    private Boolean disableJdkLogger = true;
    private Boolean disableExternalLoggerConfiguration = true;
    @Schema(description="Specify the logging level of loggers")
    private String loggingLevel;
    @Schema(description="Logging layout used for Jans Authorization Server loggers")
    private String loggingLayout;
    @Schema(description="The path to the external log4j2 logging configuration")
    private String externalLoggerConfiguration;
    @Schema(description="The interval for metric reporter in seconds")
    private int metricReporterInterval;
    @Schema(description="The days to keep metric reported data")
    private int metricReporterKeepDataDays;
    @Schema(description="Enable metric reporter")
    private Boolean metricReporterEnabled;
    @Schema(description="Time interval for the Clean Service in seconds")
    private int cleanServiceInterval;
    @Schema(description="PubSub consumer service")
    private String messageConsumerType;
    private Boolean errorReasonEnabled = false;
    @Schema(description="Each clean up iteration fetches chunk of expired data per base dn and removes it from storage")
    private int cleanServiceBatchChunkSize;

    public String getBaseDN() {
        return this.baseDN;
    }

    public void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
    }

    public String getBaseEndpoint() {
        return this.baseEndpoint;
    }

    public void setBaseEndpoint(String baseEndpoint) {
        this.baseEndpoint = baseEndpoint;
    }

    public String getOpenIdIssuer() {
        return this.openIdIssuer;
    }

    public void setOpenIdIssuer(String openIdIssuer) {
        this.openIdIssuer = openIdIssuer;
    }

    public LockProtectionMode getProtectionMode() {
        return this.protectionMode;
    }

    public void setProtectionMode(LockProtectionMode protectionMode) {
        this.protectionMode = protectionMode;
    }

    public AuditPersistenceMode getAuditPersistenceMode() {
        return this.auditPersistenceMode;
    }

    public void setAuditPersistenceMode(AuditPersistenceMode auditPersistenceMode) {
        this.auditPersistenceMode = auditPersistenceMode;
    }

    public CedarlingConfiguration getCedarlingConfiguration() {
        return this.cedarlingConfiguration;
    }

    public void setCedarlingConfiguration(CedarlingConfiguration cedarlingConfiguration) {
        this.cedarlingConfiguration = cedarlingConfiguration;
    }

    public boolean isStatEnabled() {
        return this.statEnabled;
    }

    public void setStatEnabled(boolean statEnabled) {
        this.statEnabled = statEnabled;
    }

    public int getStatTimerIntervalInSeconds() {
        return this.statTimerIntervalInSeconds;
    }

    public void setStatTimerIntervalInSeconds(int statTimerIntervalInSeconds) {
        this.statTimerIntervalInSeconds = statTimerIntervalInSeconds;
    }

    public List<String> getTokenChannels() {
        return this.tokenChannels;
    }

    public void setTokenChannels(List<String> tokenChannels) {
        this.tokenChannels = tokenChannels;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientPassword() {
        return this.clientPassword;
    }

    public void setClientPassword(String clientPassword) {
        this.clientPassword = clientPassword;
    }

    public Boolean getDisableJdkLogger() {
        return this.disableJdkLogger;
    }

    public void setDisableJdkLogger(Boolean disableJdkLogger) {
        this.disableJdkLogger = disableJdkLogger;
    }

    public Boolean getDisableExternalLoggerConfiguration() {
        return this.disableExternalLoggerConfiguration;
    }

    public void setDisableExternalLoggerConfiguration(Boolean disableExternalLoggerConfiguration) {
        this.disableExternalLoggerConfiguration = disableExternalLoggerConfiguration;
    }

    public String getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(String loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public String getLoggingLayout() {
        return this.loggingLayout;
    }

    public void setLoggingLayout(String loggingLayout) {
        this.loggingLayout = loggingLayout;
    }

    public String getExternalLoggerConfiguration() {
        return this.externalLoggerConfiguration;
    }

    public void setExternalLoggerConfiguration(String externalLoggerConfiguration) {
        this.externalLoggerConfiguration = externalLoggerConfiguration;
    }

    public int getMetricReporterInterval() {
        return this.metricReporterInterval;
    }

    public void setMetricReporterInterval(int metricReporterInterval) {
        this.metricReporterInterval = metricReporterInterval;
    }

    public int getMetricReporterKeepDataDays() {
        return this.metricReporterKeepDataDays;
    }

    public void setMetricReporterKeepDataDays(int metricReporterKeepDataDays) {
        this.metricReporterKeepDataDays = metricReporterKeepDataDays;
    }

    public Boolean getMetricReporterEnabled() {
        return this.metricReporterEnabled;
    }

    public void setMetricReporterEnabled(Boolean metricReporterEnabled) {
        this.metricReporterEnabled = metricReporterEnabled;
    }

    public int getCleanServiceInterval() {
        return this.cleanServiceInterval;
    }

    public void setCleanServiceInterval(int cleanServiceInterval) {
        this.cleanServiceInterval = cleanServiceInterval;
    }

    public String getMessageConsumerType() {
        if (this.messageConsumerType == null) {
            this.messageConsumerType = "DISABLED";
        }
        return this.messageConsumerType;
    }

    public void setMessageConsumerType(String messageConsumerType) {
        this.messageConsumerType = messageConsumerType;
    }

    public Boolean getErrorReasonEnabled() {
        if (this.errorReasonEnabled == null) {
            this.errorReasonEnabled = false;
        }
        return this.errorReasonEnabled;
    }

    public void setErrorReasonEnabled(Boolean errorReasonEnabled) {
        this.errorReasonEnabled = errorReasonEnabled;
    }

    public int getCleanServiceBatchChunkSize() {
        return this.cleanServiceBatchChunkSize;
    }

    public void setCleanServiceBatchChunkSize(int cleanServiceBatchChunkSize) {
        this.cleanServiceBatchChunkSize = cleanServiceBatchChunkSize;
    }

    public String toString() {
        return "AppConfiguration [baseDN=" + this.baseDN + ", baseEndpoint=" + this.baseEndpoint + ", openIdIssuer=" + this.openIdIssuer + ", protectionMode=" + this.protectionMode + ", auditPersistenceMode=" + this.auditPersistenceMode + ", cedarlingConfiguration=" + this.cedarlingConfiguration + ", statEnabled=" + this.statEnabled + ", statTimerIntervalInSeconds=" + this.statTimerIntervalInSeconds + ", tokenChannels=" + this.tokenChannels + ", clientId=" + this.clientId + ", clientPassword=" + this.clientPassword + ", disableJdkLogger=" + this.disableJdkLogger + ", loggingLevel=" + this.loggingLevel + ", loggingLayout=" + this.loggingLayout + ", externalLoggerConfiguration=" + this.externalLoggerConfiguration + ", metricReporterInterval=" + this.metricReporterInterval + ", metricReporterKeepDataDays=" + this.metricReporterKeepDataDays + ", metricReporterEnabled=" + this.metricReporterEnabled + ", cleanServiceInterval=" + this.cleanServiceInterval + ", messageConsumerType=" + this.messageConsumerType + ", errorReasonEnabled=" + this.errorReasonEnabled + ", cleanServiceBatchChunkSize=" + this.cleanServiceBatchChunkSize + "]";
    }
}

