/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.lock.rest;

import io.jans.configapi.core.model.ApiError;
import io.jans.configapi.core.rest.BaseResource;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.plugin.lock.service.AuditService;
import io.jans.lock.model.audit.HealthEntry;
import io.jans.lock.model.audit.LogEntry;
import io.jans.lock.model.audit.TelemetryEntry;
import io.jans.orm.PersistenceEntryManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;

@Path(value="/audit")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AuditResource
extends BaseResource {
    private static final String EVENT_START_DATE_ISO8601 = "eventStartDateIso8601";
    private static final String EVENT_END_DATE_ISO8601 = "eventEndDateIso8601";
    private static final String EVENT_START_DATE_PARSE_ERR = "Can't parse event start date !";
    private static final String EVENT_END_DATE_PARSE_ERR = "Can't parse event end date !";
    @Inject
    Logger logger;
    @Inject
    AuditService auditService;
    @Inject
    @Named(value="persistenceEntryManager")
    PersistenceEntryManager persistenceEntryManager;

    @Operation(summary="Save health data", description="Save health data", operationId="save-health-data", tags={"Lock - Audit"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/health.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/lock.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/write-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="InternalServerError"))})})
    @POST
    @ProtectedApi(scopes={"https://jans.io/oauth/lock/health.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/lock.admin", "https://jans.io/oauth/lock/write-all", "https://jans.io/oauth/config/write-all"})
    @Path(value="/health")
    public Response postHealthData(@Valid HealthEntry healthEntry) {
        this.logger.debug("Save Health Data - healthEntry:{}", (Object)healthEntry);
        this.auditService.addHealthEntry(healthEntry);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Operation(summary="Bulk save health data", description="Bulk save health data", operationId="bulk-save-health-data", tags={"Lock - Audit"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/health.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/lock.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/write-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="InternalServerError"))})})
    @POST
    @ProtectedApi(scopes={"https://jans.io/oauth/lock/health.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/lock.admin", "https://jans.io/oauth/lock/write-all", "https://jans.io/oauth/config/write-all"})
    @Path(value="/health/bulk")
    public Response postBulkHealthData(@Valid List<HealthEntry> healthEntries) {
        this.logger.debug("Bulk save Health Data - healthEntries:{}", healthEntries);
        for (HealthEntry healthEntry : healthEntries) {
            this.auditService.addHealthEntry(healthEntry);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Operation(summary="Rerquest health records for specific event range", description="Rerquest health records for specific event range", operationId="request-lock-health-records-event-range", tags={"Lock - Audit"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/health.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/health.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/lock.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=HealthEntry.class)))}), @ApiResponse(responseCode="400", description="Wrong date range specified"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/lock/health.readonly"}, groupScopes={"https://jans.io/oauth/lock/health.write"}, superScopes={"https://jans.io/oauth/config/lock.admin", "https://jans.io/oauth/lock/read-all", "https://jans.io/oauth/config/read-all"})
    @Path(value="/health/search")
    public Response getHealthEntrysByRange(@Parameter(description="Search size - max size of the results to return") @DefaultValue(value="50") @QueryParam(value="limit") int limit, @Parameter(description="Event start date in ISO8601 format") @QueryParam(value="eventStartDate") @NotNull String eventStartDateIso8601, @Parameter(description="Event end date in ISO8601 format") @QueryParam(value="eventEndDate") @NotNull String eventEndDateIso8601) {
        this.logger.debug("Get Health entries by by event range");
        AuditResource.checkNotNull((String)eventStartDateIso8601, (String)EVENT_START_DATE_ISO8601);
        AuditResource.checkNotNull((String)eventEndDateIso8601, (String)EVENT_END_DATE_ISO8601);
        Date eventStartDate = this.decodeTime(eventStartDateIso8601);
        AuditResource.checkResourceNotNull((Object)eventStartDate, (String)EVENT_START_DATE_PARSE_ERR);
        Date eventEndDate = this.decodeTime(eventEndDateIso8601);
        AuditResource.checkResourceNotNull((Object)eventStartDate, (String)EVENT_END_DATE_PARSE_ERR);
        List<HealthEntry> entries = this.auditService.getHealthEntrysByRange(eventStartDate, eventEndDate, limit);
        return Response.ok(entries).build();
    }

    @Operation(summary="Save log data", description="Save log data", operationId="save-log-data", tags={"Lock - Audit"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/log.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/lock.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/write-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="InternalServerError"))})})
    @POST
    @ProtectedApi(scopes={"https://jans.io/oauth/lock/log.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/lock.admin", "https://jans.io/oauth/lock/write-all", "https://jans.io/oauth/config/write-all"})
    @Path(value="/log")
    public Response postLogData(@Valid LogEntry logEntry) {
        this.logger.debug("Save Log Data - logEntry:{}", (Object)logEntry);
        this.auditService.addLogData(logEntry);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Operation(summary="Bulk save log data", description="Bulk save log data", operationId="bulk-save-log-data", tags={"Lock - Audit"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/log.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/lock.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/write-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="InternalServerError"))})})
    @POST
    @ProtectedApi(scopes={"https://jans.io/oauth/lock/log.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/lock.admin", "https://jans.io/oauth/lock/write-all", "https://jans.io/oauth/config/write-all"})
    @Path(value="/log/bulk")
    public Response postBulkLogData(@Valid List<LogEntry> logEntries) {
        this.logger.debug("Bulk save Log Data - logEntries:{}", logEntries);
        for (LogEntry LogEntry2 : logEntries) {
            this.auditService.addLogData(LogEntry2);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Operation(summary="Rerquest log records for specific event range", description="Rerquest log records for specific event range", operationId="request-lock-log-records-event-range", tags={"Lock - Log"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/log.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/log.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/lock.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=LogEntry.class)))}), @ApiResponse(responseCode="400", description="Wrong date range specified"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/lock/log.readonly"}, groupScopes={"https://jans.io/oauth/lock/log.write"}, superScopes={"https://jans.io/oauth/config/lock.admin", "https://jans.io/oauth/lock/read-all", "https://jans.io/oauth/config/read-all"})
    @Path(value="/log/search")
    public Response getLogEntrysByRange(@Parameter(description="Search size - max size of the results to return") @DefaultValue(value="50") @QueryParam(value="limit") int limit, @Parameter(description="Event start date in ISO8601 format") @QueryParam(value="eventStartDate") @NotNull String eventStartDateIso8601, @Parameter(description="Event end date in ISO8601 format") @QueryParam(value="eventEndDate") @NotNull String eventEndDateIso8601) {
        this.logger.debug("Get Log entries by by event range");
        AuditResource.checkNotNull((String)eventStartDateIso8601, (String)EVENT_START_DATE_ISO8601);
        AuditResource.checkNotNull((String)eventEndDateIso8601, (String)EVENT_END_DATE_ISO8601);
        Date eventStartDate = this.decodeTime(eventStartDateIso8601);
        AuditResource.checkResourceNotNull((Object)eventStartDate, (String)EVENT_START_DATE_PARSE_ERR);
        Date eventEndDate = this.decodeTime(eventEndDateIso8601);
        AuditResource.checkResourceNotNull((Object)eventStartDate, (String)EVENT_END_DATE_PARSE_ERR);
        List<LogEntry> entries = this.auditService.getLogEntrysByRange(eventStartDate, eventEndDate, limit);
        return Response.ok(entries).build();
    }

    @Operation(summary="Save telemetry data", description="Save telemetry data", operationId="save-telemetry-data", tags={"Lock - Audit"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/telemetry.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/lock.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/write-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="InternalServerError"))})})
    @POST
    @ProtectedApi(scopes={"https://jans.io/oauth/lock/telemetry.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/lock.admin", "https://jans.io/oauth/lock/write-all", "https://jans.io/oauth/config/write-all"})
    @Path(value="/telemetry")
    public Response postTelemetryData(@Valid TelemetryEntry telemetryEntry) {
        this.logger.debug("Save Telemetry Data - telemetryEntry:{}", (Object)telemetryEntry);
        this.auditService.addTelemetryData(telemetryEntry);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Operation(summary="Bulk save telemetry data", description="Bulk save telemetry data", operationId="bulk-save-telemetry-data", tags={"Lock - Audit"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/telemetry.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/lock.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/write-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="InternalServerError"))})})
    @POST
    @ProtectedApi(scopes={"https://jans.io/oauth/lock/telemetry.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/lock.admin", "https://jans.io/oauth/lock/write-all", "https://jans.io/oauth/config/write-all"})
    @Path(value="/telemetry/bulk")
    public Response postBulkTelemetryData(@Valid List<TelemetryEntry> telemetryEntries) {
        this.logger.debug("Bulk save Telemetry Data - telemetryEntries:{}", telemetryEntries);
        for (TelemetryEntry telemetryEntry : telemetryEntries) {
            this.auditService.addTelemetryData(telemetryEntry);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Operation(summary="Request telemetry records for specific event range", description="Rerquest telemetry records for specific event range", operationId="request-lock-telemetry-records-event-range", tags={"Lock - Audit"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/telemetry.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/telemetry.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/lock.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/lock/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=TelemetryEntry.class)))}), @ApiResponse(responseCode="400", description="Wrong date range specified"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/lock/telemetry.readonly"}, groupScopes={"https://jans.io/oauth/lock/telemetry.write"}, superScopes={"https://jans.io/oauth/config/lock.admin", "https://jans.io/oauth/lock/read-all", "https://jans.io/oauth/config/read-all"})
    @Path(value="/telemetry/search")
    public Response getTelemetryEntrysByRange(@Parameter(description="Search size - max size of the results to return") @DefaultValue(value="50") @QueryParam(value="limit") int limit, @Parameter(description="Event start date in ISO8601 format") @QueryParam(value="eventStartDate") @NotNull String eventStartDateIso8601, @Parameter(description="Event end date in ISO8601 format") @QueryParam(value="eventEndDate") @NotNull String eventEndDateIso8601) {
        this.logger.debug("Get Telemetry entries by by event range");
        AuditResource.checkNotNull((String)eventStartDateIso8601, (String)EVENT_START_DATE_ISO8601);
        AuditResource.checkNotNull((String)eventEndDateIso8601, (String)EVENT_END_DATE_ISO8601);
        Date eventStartDate = this.decodeTime(eventStartDateIso8601);
        AuditResource.checkResourceNotNull((Object)eventStartDate, (String)EVENT_START_DATE_PARSE_ERR);
        Date eventEndDate = this.decodeTime(eventEndDateIso8601);
        AuditResource.checkResourceNotNull((Object)eventStartDate, (String)EVENT_END_DATE_PARSE_ERR);
        List<TelemetryEntry> entries = this.auditService.getTelemetryEntrysByRange(eventStartDate, eventEndDate, limit);
        return Response.ok(entries).build();
    }

    private Date decodeTime(String dateZ) {
        try {
            return new Date(Instant.parse(dateZ).toEpochMilli());
        }
        catch (DateTimeParseException ex) {
            this.logger.error("Failed to decode ISO-8601 date '{}'", (Object)dateZ, (Object)ex);
            return null;
        }
    }
}

