/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim2.client.factory;

import io.jans.scim2.client.ScimClient;
import io.jans.scim2.client.rest.ClientSideService;
import io.jans.util.security.SecurityProviderUtility;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.file.Path;

public class ScimClientFactory {
    private static Class<ClientSideService> defaultInterface;

    private ScimClientFactory() {
    }

    public static <T> T getClient(Class<T> interfaceClass, String domain, String OIDCMetadataUrl, String clientId, String clientSecret, boolean secretPostAuthnMethod) throws Exception {
        ScimClient<T> handler = new ScimClient<T>(interfaceClass, domain, OIDCMetadataUrl, clientId, clientSecret, secretPostAuthnMethod);
        return ScimClientFactory.typedProxy(interfaceClass, handler);
    }

    public static <T> T getClient(Class<T> interfaceClass, String domain, String OIDCMetadataUrl, String clientId, Path keyStorePath, String keyStorePassword, String keyId) throws Exception {
        ScimClient<T> handler = new ScimClient<T>(interfaceClass, domain, OIDCMetadataUrl, clientId, keyStorePath, keyStorePassword, keyId);
        return ScimClientFactory.typedProxy(interfaceClass, handler);
    }

    public static ClientSideService getClient(String domain, String OIDCMetadataUrl, String clientId, String clientSecret) throws Exception {
        return ScimClientFactory.getClient(domain, OIDCMetadataUrl, clientId, clientSecret, false);
    }

    public static ClientSideService getClient(String domain, String OIDCMetadataUrl, String clientId, String clientSecret, boolean secretPostAuthnMethod) throws Exception {
        return ScimClientFactory.getClient(defaultInterface, domain, OIDCMetadataUrl, clientId, clientSecret, secretPostAuthnMethod);
    }

    public static ClientSideService getClient(String domain, String OIDCMetadataUrl, String clientId, Path keyStorePath, String keyStorePassword) throws Exception {
        return ScimClientFactory.getClient(defaultInterface, domain, OIDCMetadataUrl, clientId, keyStorePath, keyStorePassword, null);
    }

    public static ClientSideService getClient(String domain, String OIDCMetadataUrl, String clientId, Path keyStorePath, String keyStorePassword, String keyId) throws Exception {
        return ScimClientFactory.getClient(defaultInterface, domain, OIDCMetadataUrl, clientId, keyStorePath, keyStorePassword, keyId);
    }

    private static <T> T typedProxy(Class<T> interfaceClass, InvocationHandler handler) {
        return interfaceClass.cast(Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, handler));
    }

    static {
        SecurityProviderUtility.installBCProvider();
        defaultInterface = ClientSideService.class;
    }
}

