/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.model.scim2.fido;

import io.jans.scim.model.scim2.AttributeDefinition;
import io.jans.scim.model.scim2.BaseScimResource;
import io.jans.scim.model.scim2.annotations.Attribute;
import io.jans.scim.model.scim2.annotations.Schema;
import io.jans.scim.model.scim2.annotations.StoreReference;
import io.jans.scim.model.scim2.fido.DeviceData;

@Schema(id="urn:ietf:params:scim:schemas:core:2.0:Fido2Device", name="Fido2Device", description="Fido 2 Device")
public class Fido2DeviceResource
extends BaseScimResource {
    @Attribute(description="Username of device owner", isRequired=true, mutability=AttributeDefinition.Mutability.IMMUTABLE)
    @StoreReference(ref="personInum")
    private String userId;
    @Attribute(description="Date of enrollment", isRequired=true, mutability=AttributeDefinition.Mutability.IMMUTABLE, type=AttributeDefinition.Type.DATETIME)
    @StoreReference(ref="creationDate")
    private String creationDate;
    @Attribute(description="A counter aimed at being used by the FIDO endpoint", isRequired=true, mutability=AttributeDefinition.Mutability.IMMUTABLE, type=AttributeDefinition.Type.INTEGER)
    @StoreReference(ref="jansCounter")
    private int counter;
    @Attribute(isRequired=true, canonicalValues={"registered", "pending", "compromised", "canceled"})
    @StoreReference(ref="jansStatus")
    private String status;
    @Attribute(description="Device data for Super Gluu enrollment", mutability=AttributeDefinition.Mutability.IMMUTABLE, type=AttributeDefinition.Type.COMPLEX)
    @StoreReference(ref="jansDeviceData")
    private DeviceData deviceData;
    @Attribute
    @StoreReference(ref="displayName")
    private String displayName;

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public int getCounter() {
        return this.counter;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public DeviceData getDeviceData() {
        return this.deviceData;
    }

    public void setDeviceData(DeviceData deviceData) {
        this.deviceData = deviceData;
    }
}

