/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim2.client.rest.provider;

import io.jans.scim2.client.ClientMap;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Provider
public class AuthorizationInjectionFilter
implements ClientRequestFilter {
    private Logger logger = LogManager.getLogger(this.getClass());
    private ClientMap clientMap = ClientMap.instance();

    public void filter(ClientRequestContext context) {
        Client client = context.getClient();
        MultivaluedMap headers = context.getHeaders();
        String authzHeader = this.clientMap.getValue(client);
        if (StringUtils.isNotEmpty((CharSequence)authzHeader)) {
            headers.putSingle((Object)"Authorization", (Object)authzHeader);
        }
        MultivaluedMap<String, String> map = Optional.ofNullable(this.clientMap.getCustomHeaders(client)).orElse((MultivaluedMap<String, String>)new MultivaluedHashMap());
        for (String key : map.keySet()) {
            ArrayList list = new ArrayList();
            ((List)map.get((Object)key)).forEach(list::add);
            headers.put((Object)key, list);
        }
        Optional.ofNullable(System.getProperty("scim.extraHeaders")).map(str -> Arrays.asList(str.split(",\\s*"))).orElse(Collections.emptyList()).forEach(prop -> Optional.ofNullable(System.getProperty("scim.header." + prop)).ifPresent(value -> headers.putSingle(prop, value)));
    }
}

