/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.scim.service;

import io.jans.configapi.plugin.scim.configuration.ScimConfigurationFactory;
import io.jans.orm.PersistenceEntryManager;
import io.jans.scim.model.conf.AppConfiguration;
import io.jans.scim.model.conf.Conf;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.slf4j.Logger;

@ApplicationScoped
public class ScimConfigService {
    @Inject
    Logger log;
    @Inject
    PersistenceEntryManager persistenceManager;
    @Inject
    ScimConfigurationFactory scimConfigurationFactory;

    public Conf findConf() {
        String dn = this.scimConfigurationFactory.getScimConfigurationDn();
        this.log.debug("\n\n ScimConfigService::findConf() - dn:{} ", (Object)dn);
        return (Conf)this.persistenceManager.find((Object)dn, Conf.class, null);
    }

    public void merge(Conf conf) {
        conf.setRevision(conf.getRevision() + 1L);
        this.persistenceManager.merge((Object)conf);
    }

    public AppConfiguration find() {
        Conf conf = this.findConf();
        this.log.debug("\n\n ScimConfigService::find() - new - conf.getDn:{}, conf.getDynamicConf:{}, conf.getRevision:{}", new Object[]{conf.getDn(), conf.getDynamicConf(), conf.getRevision()});
        return conf.getDynamicConf();
    }
}

