/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim2.client;

import io.jans.scim2.client.ClientMap;
import io.jans.scim2.client.rest.CloseableClient;
import io.jans.scim2.client.rest.FreelyAccessible;
import io.jans.scim2.client.rest.provider.AuthorizationInjectionFilter;
import io.jans.scim2.client.rest.provider.ListResponseProvider;
import io.jans.scim2.client.rest.provider.ScimResourceProvider;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;

public abstract class AbstractScimClient<T>
implements CloseableClient,
InvocationHandler,
Serializable {
    private static final long serialVersionUID = 9098930517944520482L;
    private Logger logger = LogManager.getLogger(this.getClass());
    private T scimService;
    private ResteasyClient client;
    private ClientMap clientMap = ClientMap.instance();

    AbstractScimClient(String domain, Class<T> serviceClass) {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).setConnectionManager((HttpClientConnectionManager)cm).build();
        ResteasyClientBuilder builder = (ResteasyClientBuilder)ClientBuilder.newBuilder();
        this.client = builder.httpEngine((ClientHttpEngine)new ApacheHttpClient43Engine((HttpClient)httpClient)).build();
        ResteasyWebTarget target = this.client.target(domain);
        target.register(ListResponseProvider.class);
        target.register(AuthorizationInjectionFilter.class);
        target.register(ScimResourceProvider.class);
        this.scimService = target.proxy(serviceClass);
        this.clientMap.update((Client)this.client, null);
    }

    private Response invokeServiceMethod(Method method, Object[] args) throws ReflectiveOperationException {
        this.logger.trace("Sending service request for method {}", (Object)method.getName());
        Response response = (Response)method.invoke(this.scimService, args);
        boolean buffered = false;
        try {
            buffered = response.bufferEntity();
        }
        catch (Exception e) {
            this.logger.trace(e.getMessage(), (Throwable)e);
        }
        this.logger.trace("Received response entity was{} buffered", (Object)(buffered ? "" : " not"));
        this.logger.trace("Response status code was {}", (Object)response.getStatus());
        return response;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Response response;
        String methodName = method.getName();
        if (Stream.of(CloseableClient.class, Object.class).anyMatch(method.getDeclaringClass()::equals)) {
            return method.invoke((Object)this, args);
        }
        FreelyAccessible unprotected = method.getAnnotation(FreelyAccessible.class);
        if (unprotected != null) {
            response = this.invokeServiceMethod(method, args);
        } else {
            this.clientMap.update((Client)this.client, this.getAuthenticationHeader());
            response = this.invokeServiceMethod(method, args);
            if (response.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                if (this.authorize(response)) {
                    this.logger.trace("Trying second attempt of request (former received unauthorized response code)");
                    this.clientMap.update((Client)this.client, this.getAuthenticationHeader());
                    response = this.invokeServiceMethod(method, args);
                } else {
                    this.logger.error("Could not get access token for current request: {}", (Object)methodName);
                }
            }
        }
        return response;
    }

    @Override
    public void close() {
        this.logger.info("Closing RestEasy client");
        this.clientMap.remove((Client)this.client);
    }

    @Override
    public void setCustomHeaders(MultivaluedMap<String, String> headers) {
        this.logger.info("Setting custom headers");
        this.clientMap.setCustomHeaders((Client)this.client, headers);
    }

    abstract String getAuthenticationHeader();

    abstract boolean authorize(Response var1);
}

