/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim2.client;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.HashMap;
import java.util.Map;

public class ClientMap {
    private static ClientMap map = new ClientMap();
    private Map<Client, String> mappings = new HashMap<Client, String>();
    private Map<Client, MultivaluedMap<String, String>> customHeadersMap = new HashMap<Client, MultivaluedMap<String, String>>();

    private ClientMap() {
    }

    public static ClientMap instance() {
        return map;
    }

    public void update(Client client, String value) {
        this.mappings.put(client, value);
    }

    public void remove(Client client) {
        client.close();
        this.mappings.remove(client);
    }

    public String getValue(Client client) {
        return this.mappings.get(client);
    }

    public void clean() {
        this.customHeadersMap.clear();
        this.mappings.keySet().forEach(this::remove);
    }

    public MultivaluedMap<String, String> getCustomHeaders(Client client) {
        return this.customHeadersMap.get(client);
    }

    public void setCustomHeaders(Client client, MultivaluedMap<String, String> headersMap) {
        this.customHeadersMap.put(client, headersMap);
    }
}

