/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim2.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.as.model.common.AuthenticationMethod;
import io.jans.as.model.crypto.AuthCryptoProvider;
import io.jans.scim2.client.AbstractScimClient;
import io.jans.scim2.client.exception.ScimInitializationException;
import io.jans.util.StringHelper;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.Response;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScimClient<T>
extends AbstractScimClient<T> {
    private static final long serialVersionUID = 3141592672017122134L;
    private static final Charset utf8 = StandardCharsets.UTF_8;
    private static final String SCOPES = Stream.of("https://jans.io/scim/users.read", "https://jans.io/scim/users.write", "https://jans.io/scim/groups.read", "https://jans.io/scim/groups.write", "https://jans.io/scim/fido.read", "https://jans.io/scim/fido.write", "https://jans.io/scim/fido2.read", "https://jans.io/scim/fido2.write", "https://jans.io/scim/all-resources.search", "https://jans.io/scim/bulk", "https://jans.io/scim/tokens").collect(Collectors.joining(" "));
    private Logger logger = LogManager.getLogger(this.getClass());
    private String access_token;
    private String tokenEndpoint;
    private String clientId;
    private String password;
    private AuthenticationMethod tokenEndpointAuthnMethod;
    private String keyId;
    private ObjectMapper mapper = new ObjectMapper();
    private AuthCryptoProvider cryptoProvider;

    public ScimClient(Class<T> serviceClass, String serviceUrl, String OIDCMetadataUrl, String id, String secret, boolean secretPostAuthnMethod) throws Exception {
        super(serviceUrl, serviceClass);
        this.checkRequiredness(id, secret, OIDCMetadataUrl);
        this.clientId = id;
        this.password = secret;
        this.tokenEndpoint = this.getTokenEndpoint(OIDCMetadataUrl);
        this.tokenEndpointAuthnMethod = secretPostAuthnMethod ? AuthenticationMethod.CLIENT_SECRET_POST : AuthenticationMethod.CLIENT_SECRET_BASIC;
        this.updateTokens();
    }

    public ScimClient(Class<T> serviceClass, String serviceUrl, String OIDCMetadataUrl, String id, Path keyStorePath, String keyStorePassword, String keyId) throws Exception {
        super(serviceUrl, serviceClass);
        this.checkRequiredness(id, keyStorePassword, OIDCMetadataUrl);
        try {
            this.cryptoProvider = new AuthCryptoProvider(keyStorePath.toString(), keyStorePassword, null);
        }
        catch (Exception ex) {
            throw new ScimInitializationException("Failed to initialize crypto provider");
        }
        if (StringHelper.isEmpty((String)keyId)) {
            List aliases = this.cryptoProvider.getKeys();
            if (aliases.size() > 0) {
                keyId = (String)aliases.get(0);
            } else {
                throw new ScimInitializationException("No keys found in keystore");
            }
        }
        this.clientId = id;
        this.tokenEndpoint = this.getTokenEndpoint(OIDCMetadataUrl);
        this.tokenEndpointAuthnMethod = AuthenticationMethod.PRIVATE_KEY_JWT;
        this.keyId = keyId;
        this.updateTokens();
    }

    private void checkRequiredness(String ... args) throws ScimInitializationException {
        if (Stream.of(args).anyMatch(StringHelper::isEmpty)) {
            throw new ScimInitializationException("One or more required values are missing");
        }
    }

    private String getTokenEndpoint(String metadataUrl) throws Exception {
        JsonNode tree = this.mapper.readTree(new URL(metadataUrl));
        return tree.get("token_endpoint").asText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTokens() throws Exception {
        WebTarget target = ClientBuilder.newClient().target(this.tokenEndpoint);
        Form form = new Form().param("grant_type", "client_credentials").param("scope", SCOPES);
        Invocation.Builder builder = target.request();
        if (this.tokenEndpointAuthnMethod.equals((Object)AuthenticationMethod.CLIENT_SECRET_BASIC)) {
            Object authz = this.clientId + ":" + this.password;
            authz = new String(Base64.getEncoder().encode(((String)authz).getBytes(utf8)), utf8);
            builder.header("Authorization", (Object)("Basic " + (String)authz));
        } else if (this.tokenEndpointAuthnMethod.equals((Object)AuthenticationMethod.CLIENT_SECRET_POST)) {
            form.param("client_id", this.clientId).param("client_secret", this.password);
        } else {
            throw new ScimInitializationException("Authentication method " + this.tokenEndpointAuthnMethod + " not yet supported, please contact the project maintainer");
        }
        try (Response response = builder.post(Entity.form((Form)form));){
            ObjectMapper mapper = new ObjectMapper();
            this.access_token = mapper.readTree((String)response.readEntity(String.class)).get("access_token").asText();
        }
        this.logger.debug("Got token: " + this.access_token);
    }

    @Override
    String getAuthenticationHeader() {
        return "Bearer " + this.access_token;
    }

    @Override
    boolean authorize(Response response) {
        try {
            this.updateTokens();
            return this.access_token != null;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

