---
tags:
- administration
- reference
- json
- properties
---

# SCIM Configuration Properties

| Property Name | Description |  | 
|-----|-----|-----|
| applicationUrl | Application base URL | [Details](#applicationurl) |
| baseDN | Application config Base DN | [Details](#basedn) |
| baseEndpoint | SCIM base endpoint URL | [Details](#baseendpoint) |
| bulkMaxOperations | Specifies maximum bulk operations | [Details](#bulkmaxoperations) |
| bulkMaxPayloadSize | Specifies maximum payload size of bulk operations | [Details](#bulkmaxpayloadsize) |
| disableJdkLogger | Boolean value specifying whether to enable JDK Loggers | [Details](#disablejdklogger) |
| disableLoggerTimer | Boolean value specifying whether to enable the logger refresh timer | [Details](#disableloggertimer) |
| externalLoggerConfiguration | Path to external log4j2 logging configuration | [Details](#externalloggerconfiguration) |
| loggingLayout | Logging layout used for Server loggers | [Details](#logginglayout) |
| loggingLevel | Logging level for scim logger | [Details](#logginglevel) |
| maxCount | Maximum number of results per page | [Details](#maxcount) |
| metricReporterEnabled | Metric reported data enabled flag | [Details](#metricreporterenabled) |
| metricReporterInterval | The interval for metric reporter in seconds | [Details](#metricreporterinterval) |
| metricReporterKeepDataDays | The days to keep metric reported data | [Details](#metricreporterkeepdatadays) |
| oxAuthIssuer | Jans Auth - Issuer identifier | [Details](#oxauthissuer) |
| personCustomObjectClass | Person Object Class | [Details](#personcustomobjectclass) |
| protectionMode | SCIM Protection Mode | [Details](#protectionmode) |
| skipDefinedPasswordValidation | Boolean value specifying whether to bypass the validation defined upon the password attribute | [Details](#skipdefinedpasswordvalidation) |
| useLocalCache | Boolean value specifying whether to enable local in-memory cache | [Details](#uselocalcache) |
| userExtensionSchemaURI | User Extension Schema URI | [Details](#userextensionschemauri) |


### applicationUrl

- Description: Application base URL

- Required: No

- Default value: None


### baseDN

- Description: Application config Base DN

- Required: No

- Default value: None


### baseEndpoint

- Description: SCIM base endpoint URL

- Required: No

- Default value: None


### bulkMaxOperations

- Description: Specifies maximum bulk operations

- Required: No

- Default value: None


### bulkMaxPayloadSize

- Description: Specifies maximum payload size of bulk operations

- Required: No

- Default value: None


### disableJdkLogger

- Description: Boolean value specifying whether to enable JDK Loggers

- Required: No

- Default value: None


### disableLoggerTimer

- Description: Boolean value specifying whether to enable the logger refresh timer

- Required: No

- Default value: None


### externalLoggerConfiguration

- Description: Path to external log4j2 logging configuration

- Required: No

- Default value: None


### loggingLayout

- Description: Logging layout used for Server loggers

- Required: No

- Default value: None


### loggingLevel

- Description: Logging level for scim logger

- Required: No

- Default value: None


### maxCount

- Description: Maximum number of results per page

- Required: No

- Default value: None


### metricReporterEnabled

- Description: Metric reported data enabled flag

- Required: No

- Default value: None


### metricReporterInterval

- Description: The interval for metric reporter in seconds

- Required: No

- Default value: None


### metricReporterKeepDataDays

- Description: The days to keep metric reported data

- Required: No

- Default value: None


### oxAuthIssuer

- Description: Jans Auth - Issuer identifier

- Required: No

- Default value: None


### personCustomObjectClass

- Description: Person Object Class

- Required: No

- Default value: None


### protectionMode

- Description: SCIM Protection Mode

- Required: No

- Default value: None


### skipDefinedPasswordValidation

- Description: Boolean value specifying whether to bypass the validation defined upon the password attribute

- Required: No

- Default value: None


### useLocalCache

- Description: Boolean value specifying whether to enable local in-memory cache

- Required: No

- Default value: None


### userExtensionSchemaURI

- Description: User Extension Schema URI

- Required: No

- Default value: None


