/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.scim.service;

import io.jans.configapi.plugin.scim.model.config.ScimConfiguration;
import io.jans.configapi.util.AuthUtil;
import io.jans.scim.model.scim2.SearchRequest;
import io.jans.scim.model.scim2.patch.PatchRequest;
import io.jans.scim.model.scim2.user.UserResource;
import io.jans.scim2.client.factory.ScimClientFactory;
import io.jans.scim2.client.rest.ClientSideService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;

@Singleton
public class ScimService {
    @Inject
    Logger log;
    @Inject
    AuthUtil authUtil;
    @Inject
    ScimConfiguration scimConfiguration;

    public Response serachScimUser(String filter, Integer startIndex, Integer count, String sortBy, String sortOrder, String attrsList, String excludedAttrsList) throws Exception {
        ClientSideService client = this.getClientSideService();
        return client.searchUsers(filter, startIndex, count, sortBy, sortOrder, attrsList, excludedAttrsList);
    }

    public Response serachScimUserPost(SearchRequest searchRequest) throws Exception {
        ClientSideService client = this.getClientSideService();
        return client.searchUsersPost(searchRequest);
    }

    public Response createScimUser(UserResource user, String attrsList, String excludedAttrsList) throws Exception {
        ClientSideService client = this.getClientSideService();
        return client.createUser(user, attrsList, excludedAttrsList);
    }

    public Response getScimUserById(String id, String attrsList, String excludedAttrsList) throws Exception {
        ClientSideService client = this.getClientSideService();
        return client.getUserById(id, attrsList, excludedAttrsList);
    }

    public Response updateScimUser(UserResource user, String id, String attrsList, String excludedAttrsList) throws Exception {
        ClientSideService client = this.getClientSideService();
        return client.updateUser(user, id, attrsList, excludedAttrsList);
    }

    public Response deleteScimUser(String id) throws Exception {
        ClientSideService client = this.getClientSideService();
        return client.deleteUser(id);
    }

    public Response patchScimUser(PatchRequest patchRequest, String id, String attrsList, String excludedAttrsList) throws Exception {
        ClientSideService client = this.getClientSideService();
        return client.patchUser(patchRequest, id, attrsList, excludedAttrsList);
    }

    private ClientSideService getClientSideService() throws Exception {
        String domainURL = this.authUtil.getIssuer() + this.scimConfiguration.getScimRelativePath();
        String oidcMetadataUrl = this.authUtil.getOpenIdConfigurationEndpoint();
        this.log.debug("Scim Client param - domainURL:{}, oidcMetadataUrl:{} ", (Object)domainURL, (Object)oidcMetadataUrl);
        return ScimClientFactory.getClient((String)domainURL, (String)oidcMetadataUrl, (String)this.authUtil.getClientId(), (String)this.authUtil.getClientDecryptPassword(this.authUtil.getClientId()));
    }
}

