/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.model.scim2.user;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.jans.scim.model.scim2.AttributeDefinition;
import io.jans.scim.model.scim2.Validations;
import io.jans.scim.model.scim2.annotations.Attribute;
import io.jans.scim.model.scim2.annotations.StoreReference;
import io.jans.scim.model.scim2.annotations.Validator;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Email {
    @Attribute(description="E-mail addresses for the user. The value SHOULD be canonicalized by the Service Provider, e.g.  bjensen@example.com instead of bjensen@EXAMPLE.COM.", isRequired=true)
    @Validator(value=Validations.EMAIL)
    @StoreReference(ref="mail")
    private String value;
    @Attribute(description="A human readable name, primarily used for  display purposes.")
    private String display;
    @Attribute(description="A label indicating the attribute's  function; e.g., 'work' or 'home'.", canonicalValues={"work", "home", "other"})
    private String type;
    @Attribute(description="A Boolean value indicating the 'primary'  or preferred attribute value for this attribute,e.g., the  preferred mailing address or primary e-mail address. The primary  attribute value 'true' MUST appear no more than once.", type=AttributeDefinition.Type.BOOLEAN)
    private Boolean primary;

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public String getType() {
        return this.type;
    }

    @JsonProperty
    public void setType(String type) {
        this.type = type;
    }

    public void setType(Type type) {
        this.setType(type.name().toLowerCase());
    }

    public Boolean getPrimary() {
        return this.primary;
    }

    public void setPrimary(Boolean primary) {
        this.primary = primary;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.display == null ? 0 : this.display.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.primary == null ? 0 : this.primary.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Email other = (Email)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        if (this.display == null ? other.display != null : !this.display.equals(other.display)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.primary == null ? other.primary != null : !this.primary.equals(other.primary));
    }

    public static enum Type {
        WORK,
        HOME,
        OTHER;

    }
}

