/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.scim.rest;

import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import io.jans.configapi.core.rest.BaseResource;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.plugin.scim.service.ScimConfigService;
import io.jans.scim.model.conf.AppConfiguration;
import io.jans.scim.model.conf.Conf;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.slf4j.Logger;

@Path(value="/scim-config")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ScimConfigResource
extends BaseResource {
    @Inject
    Logger log;
    @Inject
    ScimConfigService scimConfigService;

    @Operation(summary="Retrieves SCIM App configuration", description="Retrieves SCIM App configuration", operationId="get-scim-config", tags={"SCIM - Config Management"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/scim/config.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/scim/config.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scim.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppConfiguration.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/scim/config.readonly"}, groupScopes={"https://jans.io/scim/config.write"}, superScopes={"https://jans.io/oauth/config/scim.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    public Response getAppConfiguration() {
        AppConfiguration appConfiguration = this.scimConfigService.find();
        this.log.debug("SCIM appConfiguration:{}", (Object)appConfiguration);
        return Response.ok((Object)appConfiguration).build();
    }

    @Operation(summary="Patch SCIM App configuration", description="Patch SCIM App configuration", operationId="patch-scim-config", tags={"SCIM - Config Management"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/scim/config.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scim.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="String representing patch-document.", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=JsonPatch.class)), examples={@ExampleObject(value="[ {op:replace, path: loggingLevel, value: DEBUG } ]")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppConfiguration.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/scim/config.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/scim.admin", "https://jans.io/oauth/config/write-all"})
    public Response patchAppConfigurationProperty(@NotNull String requestString) throws IOException, JsonPatchException {
        this.log.info("AUTH CONF details to patch - requestString:{}", (Object)requestString);
        Conf conf = this.scimConfigService.findConf();
        AppConfiguration appConfiguration = conf.getDynamicConf();
        this.log.trace("AUTH CONF details BEFORE patch - conf:{}, appConfiguration:{}", (Object)conf, (Object)appConfiguration);
        appConfiguration = (AppConfiguration)Jackson.applyPatch((String)requestString, (Object)appConfiguration);
        this.log.trace("AUTH CONF details BEFORE patch merge - appConfiguration:{}", (Object)appConfiguration);
        conf.setDynamicConf(appConfiguration);
        this.scimConfigService.merge(conf);
        appConfiguration = this.scimConfigService.find();
        this.log.debug("AUTH CONF details AFTER patch merge - appConfiguration:{}", (Object)appConfiguration);
        return Response.ok((Object)appConfiguration).build();
    }
}

