/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.model.scim2.extensions;

import io.jans.model.attribute.AttributeDataType;
import io.jans.scim.model.scim2.AttributeDefinition;
import io.jans.scim.model.scim2.util.DateUtil;
import java.time.format.DateTimeFormatter;
import java.util.regex.Pattern;

public class ExtensionField {
    private static final String XSD_DATE_TIME_PATTERN = "^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}.*$";
    private String name;
    private boolean multiValued;
    private AttributeDataType type;
    private String description;

    public static Object valueOf(ExtensionField field, Object val) {
        Object value = null;
        switch (field.getType()) {
            case STRING: 
            case BINARY: {
                if (!(val instanceof String)) break;
                value = val;
                break;
            }
            case DATE: {
                Pattern p;
                if (!(val instanceof String) || !(p = Pattern.compile(XSD_DATE_TIME_PATTERN)).matcher(val.toString()).find()) break;
                value = val;
                break;
            }
            case NUMERIC: {
                if (!(val instanceof Integer) && !(val instanceof Double)) break;
                value = val;
                break;
            }
            case BOOLEAN: {
                if (!(val instanceof Boolean)) break;
                value = val;
            }
        }
        return value;
    }

    public static Object valueFromString(ExtensionField field, String val) {
        Object value = null;
        switch (field.getType()) {
            case STRING: 
            case BINARY: {
                value = val;
                break;
            }
            case DATE: {
                value = DateUtil.generalizedToISOStringDate(val);
                if (value != null) break;
                try {
                    DateTimeFormatter.ISO_DATE_TIME.parse(val);
                    value = val;
                }
                catch (Exception exception) {}
                break;
            }
            case NUMERIC: {
                try {
                    value = new Integer(val);
                }
                catch (Exception e) {
                    try {
                        value = new Double(val);
                    }
                    catch (Exception e2) {
                        value = null;
                    }
                }
                break;
            }
            case BOOLEAN: {
                value = Boolean.valueOf(val);
            }
        }
        return value;
    }

    public static String stringValueOf(ExtensionField field, Object val) {
        String value = null;
        switch (field.getType()) {
            case STRING: 
            case BINARY: 
            case NUMERIC: {
                value = val.toString();
                break;
            }
            case DATE: {
                value = DateUtil.ISOToGeneralizedStringDate(val.toString());
                break;
            }
            case BOOLEAN: {
                value = val.toString();
            }
        }
        return value;
    }

    public AttributeDefinition.Type getAttributeDefinitionType() {
        AttributeDefinition.Type attrType = null;
        switch (this.type) {
            case BINARY: {
                attrType = AttributeDefinition.Type.BINARY;
                break;
            }
            case STRING: {
                attrType = AttributeDefinition.Type.STRING;
                break;
            }
            case DATE: {
                attrType = AttributeDefinition.Type.DATETIME;
                break;
            }
            case NUMERIC: {
                attrType = AttributeDefinition.Type.DECIMAL;
                break;
            }
            case BOOLEAN: {
                attrType = AttributeDefinition.Type.BOOLEAN;
            }
        }
        return attrType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public AttributeDataType getType() {
        return this.type;
    }

    public void setMultiValued(boolean multiValued) {
        this.multiValued = multiValued;
    }

    public void setType(AttributeDataType type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

