/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.mgt.service;

import com.github.fge.jsonpatch.JsonPatchException;
import io.jans.as.common.model.common.User;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.util.Util;
import io.jans.configapi.core.service.ConfigUserService;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.plugin.mgt.model.user.UserPatchRequest;
import io.jans.configapi.plugin.mgt.util.MgtUtil;
import io.jans.configapi.service.auth.AttributeService;
import io.jans.configapi.service.auth.ConfigurationService;
import io.jans.configapi.util.AuthUtil;
import io.jans.model.GluuStatus;
import io.jans.model.JansAttribute;
import io.jans.model.SearchRequest;
import io.jans.model.attribute.AttributeValidation;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SortOrder;
import io.jans.orm.model.base.CustomObjectAttribute;
import io.jans.orm.search.filter.Filter;
import io.jans.util.StringHelper;
import io.jans.util.exception.InvalidAttributeException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
@Named(value="userMgmtSrv")
public class UserMgmtService {
    @Inject
    private Logger logger;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    ConfigurationService configurationService;
    @Inject
    AttributeService attributeService;
    @Inject
    PersistenceEntryManager persistenceEntryManager;
    @Inject
    AuthUtil authUtil;
    @Inject
    MgtUtil mgtUtil;
    @Inject
    ConfigUserService userService;
    private static final String BIRTH_DATE = "birthdate";

    public String getPeopleBaseDn() {
        return this.userService.getPeopleBaseDn();
    }

    public PagedResult<User> searchUsers(SearchRequest searchRequest) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Search Users with searchRequest:{}, getPeopleBaseDn():{}", (Object)Util.escapeLog((Object)searchRequest), (Object)this.getPeopleBaseDn());
        }
        boolean useLowercaseFilter = this.configurationService.isLowercaseFilter(this.userService.getPeopleBaseDn());
        this.logger.info("For searching user user useLowercaseFilter?:{}", (Object)useLowercaseFilter);
        Filter searchFilter = null;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (searchRequest.getFilterAssertionValue() != null && !searchRequest.getFilterAssertionValue().isEmpty()) {
            for (String assertionValue : searchRequest.getFilterAssertionValue()) {
                Filter uidFilter;
                Filter snFilter;
                Filter nicknameFilter;
                Filter middleNameFilter;
                Filter givenNameFilter;
                Filter mailFilter;
                Filter descriptionFilter;
                Filter displayNameFilter;
                this.logger.info("For searching user - assertionValue:{}", (Object)assertionValue);
                assertionValue = StringHelper.toLowerCase((String)assertionValue);
                Object[] targetArray = new String[]{assertionValue};
                this.logger.info("For searching user - targetArray?:{}", targetArray);
                if (useLowercaseFilter) {
                    displayNameFilter = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"displayName"), null, (String[])targetArray, null);
                    descriptionFilter = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"description"), null, (String[])targetArray, null);
                    mailFilter = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"mail"), null, (String[])targetArray, null);
                    givenNameFilter = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"givenName"), null, (String[])targetArray, null);
                    middleNameFilter = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"middleName"), null, (String[])targetArray, null);
                    nicknameFilter = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"nickname"), null, (String[])targetArray, null);
                    snFilter = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"sn"), null, (String[])targetArray, null);
                    uidFilter = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"uid"), null, (String[])targetArray, null);
                } else {
                    displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
                    descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
                    mailFilter = Filter.createSubstringFilter((String)"mail", null, (String[])targetArray, null);
                    givenNameFilter = Filter.createSubstringFilter((String)"givenName", null, (String[])targetArray, null);
                    middleNameFilter = Filter.createSubstringFilter((String)"middleName", null, (String[])targetArray, null);
                    nicknameFilter = Filter.createSubstringFilter((String)"nickname", null, (String[])targetArray, null);
                    snFilter = Filter.createSubstringFilter((String)"sn", null, (String[])targetArray, null);
                    uidFilter = Filter.createSubstringFilter((String)"uid", null, (String[])targetArray, null);
                }
                Filter inumFilter = Filter.createSubstringFilter((String)"inum", null, (String[])targetArray, null);
                filters.add(Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter, mailFilter, uidFilter, givenNameFilter, middleNameFilter, nicknameFilter, snFilter, inumFilter}));
            }
            searchFilter = Filter.createORFilter(filters);
        }
        this.logger.info("Users searchFilter:{}", searchFilter);
        PagedResult pagedResult = this.persistenceEntryManager.findPagedEntries(this.userService.getPeopleBaseDn(), User.class, searchFilter, null, searchRequest.getSortBy(), SortOrder.getByValue((String)searchRequest.getSortOrder()), searchRequest.getStartIndex().intValue(), searchRequest.getCount().intValue(), searchRequest.getMaxCount());
        List<User> users = this.verifyCustomAttributes(pagedResult.getEntries());
        pagedResult.setEntries(users);
        return pagedResult;
    }

    public List<User> getUserByName(String name) {
        this.logger.info("Get user by name:{} ", (Object)name);
        List users = null;
        try {
            Filter nameFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"uid", (Object)name), Filter.createEqualityFilter((String)"jansStatus", (Object)GluuStatus.ACTIVE.getValue())});
            this.logger.debug("Get user by nameFilter:{} ", (Object)nameFilter);
            users = this.persistenceEntryManager.findEntries(this.userService.getPeopleBaseDn(), User.class, nameFilter);
            this.logger.debug("Asset by name:{} are users:{}", (Object)name, (Object)users);
        }
        catch (Exception ex) {
            this.logger.error("Failed to load user with name:{}, ex:{}", (Object)name, (Object)ex);
        }
        return users;
    }

    public List<User> getUserByEmail(String email) {
        this.logger.info("Get user by email:{} ", (Object)email);
        List users = null;
        try {
            Filter emailFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"mail", (Object)email), Filter.createEqualityFilter((String)"jansStatus", (Object)GluuStatus.ACTIVE.getValue())});
            this.logger.debug("Get user by emailFilter:{} ", (Object)emailFilter);
            users = this.persistenceEntryManager.findEntries(this.userService.getPeopleBaseDn(), User.class, emailFilter);
            this.logger.debug("Asset by email:{} are users:{}", (Object)email, (Object)users);
        }
        catch (Exception ex) {
            this.logger.error("Failed to load user with email:{}, ex:{}", (Object)email, (Object)ex);
        }
        return users;
    }

    public void removeUser(User user) {
        this.persistenceEntryManager.removeRecursively(user.getDn(), User.class);
    }

    public User patchUser(String inum, UserPatchRequest userPatchRequest) throws JsonPatchException, IOException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Details to patch user  inum:{}, UserPatchRequest:{} ", (Object)Util.escapeLog((Object)inum), (Object)Util.escapeLog((Object)userPatchRequest));
        }
        if (StringHelper.isEmpty((String)inum)) {
            return null;
        }
        User user = this.userService.getUserByInum(inum, new String[0]);
        if (user == null) {
            return null;
        }
        this.logger.debug("User to be patched- user:{}", (Object)user);
        if (StringUtils.isNotEmpty((CharSequence)userPatchRequest.getJsonPatchString())) {
            this.logger.debug("Patch basic attributes");
            user = (User)Jackson.applyPatch((String)userPatchRequest.getJsonPatchString(), (Object)user);
            this.logger.debug("User after patching basic attributes - user:{}", (Object)user);
        }
        if (userPatchRequest.getCustomAttributes() != null && !userPatchRequest.getCustomAttributes().isEmpty()) {
            this.logger.debug("Patch Custom Attributes");
            this.updateCustomAttributes(user, userPatchRequest.getCustomAttributes());
        }
        this.logger.debug("User before patch user:{}", (Object)user);
        this.ignoreCustomObjectClassesForNonLDAP(user);
        user = this.userService.updateUser(user);
        if (user != null) {
            List<User> users = new ArrayList<User>();
            users.add(user);
            users = this.verifyCustomAttributes(users);
            user = users.get(0);
        }
        this.logger.info("User after patch user:{}", (Object)user);
        return user;
    }

    public User getUserBasedOnInum(String inum) {
        User result = null;
        try {
            result = this.userService.getUserByInum(inum, new String[0]);
            if (result != null) {
                List<User> users = new ArrayList<User>();
                users.add(result);
                users = this.verifyCustomAttributes(users);
                result = users.get(0);
            }
        }
        catch (Exception ex) {
            this.logger.error("Failed to load user entry", (Throwable)ex);
        }
        return result;
    }

    private User updateCustomAttributes(User user, List<CustomObjectAttribute> customAttributes) {
        this.logger.info("Custom Attributes to update for - user:{} ", (Object)user);
        if (customAttributes == null || customAttributes.isEmpty()) {
            return user;
        }
        this.validateAttributes(customAttributes);
        StringBuilder attributeAdded = new StringBuilder();
        StringBuilder attributeEdited = new StringBuilder();
        StringBuilder attributeDeleted = new StringBuilder();
        for (CustomObjectAttribute attribute : customAttributes) {
            CustomObjectAttribute existingAttribute = this.userService.getCustomAttribute(user, attribute.getName());
            this.logger.debug("Existing CustomAttributes with existingAttribute:{} ", (Object)existingAttribute);
            if (existingAttribute == null) {
                boolean result = this.userService.addUserAttribute(user, attribute.getName(), (Object)attribute.getValues(), Boolean.valueOf(attribute.isMultiValued()));
                attributeAdded.append(attribute.getName()).append(",");
                this.logger.debug("Result of adding CustomAttributes attribute.getName():{} , result:{} ", (Object)attribute.getName(), (Object)result);
                continue;
            }
            if (attribute.getValue() == null || attribute.getValues() == null) {
                user.removeAttribute(attribute.getName());
                attributeDeleted.append(attribute.getName()).append(",");
                continue;
            }
            existingAttribute.setMultiValued(attribute.isMultiValued());
            existingAttribute.setValues(attribute.getValues());
            attributeEdited.append(attribute.getName()).append(",");
        }
        this.logger.info(" *** Attribute added - {} {}", (Object)attributeAdded, (Object)"***");
        this.logger.info(" *** Attribute edited - {} {}", (Object)attributeEdited, (Object)"***");
        this.logger.info(" *** Attribute removed - {} {}", (Object)attributeDeleted, (Object)"***");
        return user;
    }

    public List<User> excludeAttributes(List<User> users, String commaSeparatedString) throws IllegalAccessException, InvocationTargetException {
        this.logger.debug("Attributes:{} to be excluded from users:{} ", (Object)commaSeparatedString, users);
        if (users == null || users.isEmpty() || StringUtils.isEmpty((CharSequence)commaSeparatedString)) {
            return users;
        }
        for (User user : users) {
            this.excludeAttributes(user, commaSeparatedString);
        }
        this.logger.info("Users:{} after excluding attribute:{} ", users, (Object)commaSeparatedString);
        return users;
    }

    public User excludeAttributes(User user, String commaSeparatedString) throws IllegalAccessException, InvocationTargetException {
        this.logger.debug("Attributes:{} to be excluded from user:{} ", (Object)commaSeparatedString, (Object)user);
        if (user == null || StringUtils.isEmpty((CharSequence)commaSeparatedString)) {
            return user;
        }
        List<String> excludedAttributes = Arrays.asList(commaSeparatedString.split(","));
        this.logger.debug("Attributes List:{} to be excluded ", excludedAttributes);
        List allFields = this.authUtil.getAllFields(user.getClass());
        this.logger.debug("All user fields :{} ", (Object)allFields);
        HashMap map = new HashMap();
        for (String attribute : excludedAttributes) {
            this.logger.debug("User class allFields:{} conatins attribute:{} ? :{} ", new Object[]{allFields, attribute, this.authUtil.containsField(allFields, attribute)});
            if (this.authUtil.containsField(allFields, attribute)) {
                this.logger.debug("User class contains attribute:{} ! ", (Object)attribute);
                map.put(attribute, null);
                continue;
            }
            this.logger.debug("Removing custom attribute:{} from user:{} ", (Object)attribute, (Object)user);
            user.removeAttribute(attribute);
        }
        this.logger.info("Attributes map:{} to be excluded ", map);
        if (!map.isEmpty()) {
            this.logger.debug("Removing simple attributes:{} from user object ", map);
            BeanUtilsBean.getInstance().getConvertUtils().register(false, false, 0);
            BeanUtils.populate((Object)user, map);
        }
        return user;
    }

    public String getUserExclusionAttributesAsString() {
        return this.authUtil.getUserExclusionAttributesAsString();
    }

    public String checkMandatoryFields(User user, List<String> excludeAttributes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> mandatoryAttributes = this.authUtil.getUserMandatoryAttributes();
        this.logger.debug("mandatoryAttributess :{}, excludeAttributes:{} ", (Object)mandatoryAttributes, excludeAttributes);
        List<String> requiredAttributes = this.getJansAttributeName(this.getRequiredAttributes());
        this.logger.debug("requiredAttributes:{} ", requiredAttributes);
        if (requiredAttributes != null && !requiredAttributes.isEmpty()) {
            if (mandatoryAttributes == null) {
                mandatoryAttributes = new ArrayList<String>();
            }
            mandatoryAttributes.addAll(requiredAttributes);
        }
        this.logger.info("Final mandatoryAttributes after adding requiredAttributes is {} ", (Object)mandatoryAttributes);
        StringBuilder missingAttributes = new StringBuilder();
        if (mandatoryAttributes == null || mandatoryAttributes.isEmpty()) {
            return missingAttributes.toString();
        }
        List allFields = this.authUtil.getAllFields(user.getClass());
        this.logger.debug("All user fields :{} ", (Object)allFields);
        String attributeValue = null;
        for (String attribute : mandatoryAttributes) {
            this.logger.debug("User class allFields:{} conatins attribute:{} ? :{} ", new Object[]{allFields, attribute, this.authUtil.containsField(allFields, attribute)});
            if (this.isExcludedAttribute(excludeAttributes, attribute)) {
                this.logger.debug("Not checking if the attribute:{} is missing as it's in excludeAttributes:{}", (Object)attribute, excludeAttributes);
                continue;
            }
            if (this.authUtil.containsField(allFields, attribute)) {
                this.logger.debug("Checking if attribute:{} is simple attribute", (Object)attribute);
                attributeValue = BeanUtils.getProperty((Object)user, (String)attribute);
                this.logger.debug("User basic attribute:{} - attributeValue:{} ", (Object)attribute, (Object)attributeValue);
            } else {
                this.logger.debug("Checking if attribute:{} is custom attribute", (Object)attribute);
                attributeValue = user.getAttribute(attribute);
                this.logger.debug("User custom attribute:{} - attributeValue:{} ", (Object)attribute, (Object)attributeValue);
            }
            if (attributeValue != null) continue;
            missingAttributes.append(attribute).append(",");
        }
        this.logger.debug("Checking mandatory missingAttributes:{} ", (Object)missingAttributes);
        if (missingAttributes.length() > 0) {
            missingAttributes.replace(missingAttributes.lastIndexOf(","), missingAttributes.length(), "");
        }
        this.logger.info("Returning missingAttributes:{} ", (Object)missingAttributes);
        return missingAttributes.toString();
    }

    private boolean isExcludedAttribute(List<String> excludeAttributes, String attribute) {
        this.logger.debug(" Is attribute:{} in excludeAttributeList:{} ", (Object)attribute, excludeAttributes);
        if (excludeAttributes == null || excludeAttributes.isEmpty()) {
            return false;
        }
        return excludeAttributes.stream().anyMatch(e -> e.equals(attribute));
    }

    public User parseBirthDateAttribute(User user) {
        if (user.getAttributeObjectValues(BIRTH_DATE) != null) {
            Optional optionalBithdate = user.getAttributeObjectValues(BIRTH_DATE).stream().findFirst();
            if (!optionalBithdate.isPresent()) {
                return user;
            }
            Date date = this.mgtUtil.parseStringToDateObj(optionalBithdate.get().toString());
            if (date == null) {
                date = this.persistenceEntryManager.decodeTime(null, optionalBithdate.get().toString());
            }
            user.getCustomAttributes().remove(new CustomObjectAttribute(BIRTH_DATE));
            user.getCustomAttributes().add(new CustomObjectAttribute(BIRTH_DATE, (Object)date));
        }
        return user;
    }

    public User ignoreCustomObjectClassesForNonLDAP(User user) {
        String persistenceType = this.configurationService.getPersistenceType();
        this.logger.debug("persistenceType: {}, isLDAP?:{}, user.getCustomObjectClasses():{}", new Object[]{persistenceType, this.isLDAP(), user.getCustomObjectClasses()});
        if (!this.isLDAP()) {
            this.logger.info("Setting CustomObjectClasses :{} to null as its used only for LDAP and current persistenceType is {} ", (Object)user.getCustomObjectClasses(), (Object)persistenceType);
            user.setCustomObjectClasses(null);
        }
        this.logger.debug("Final user.getCustomObjectClasses():{} ", (Object[])user.getCustomObjectClasses());
        return user;
    }

    public boolean isLDAP() {
        boolean isLDAP = false;
        String persistenceType = this.getPersistenceType();
        this.logger.debug("persistenceType: {}", (Object)persistenceType);
        if (PersistenceEntryManager.PERSITENCE_TYPES.ldap.name().equals(persistenceType)) {
            isLDAP = true;
        }
        return isLDAP;
    }

    public String getPersistenceType() {
        return this.configurationService.getPersistenceType();
    }

    public User addUser(User user, boolean active) {
        this.logger.info("\n Creating user:{}, active:{}", (Object)user, (Object)active);
        user = this.userService.addUser(user, active);
        this.logger.info("New user:{}\n", (Object)user);
        if (user != null) {
            List<User> users = new ArrayList<User>();
            users.add(user);
            users = this.verifyCustomAttributes(users);
            if (users != null && !users.isEmpty()) {
                user = users.get(0);
            }
        }
        return user;
    }

    public User updateUser(User user) {
        this.logger.info("\n Updating user:{}", (Object)user);
        user = this.userService.updateUser(user);
        this.logger.info("Updated user:{} \n", (Object)user);
        if (user != null) {
            List<User> users = new ArrayList<User>();
            users.add(user);
            users = this.verifyCustomAttributes(users);
            if (users != null && !users.isEmpty()) {
                user = users.get(0);
            }
        }
        return user;
    }

    public List<User> verifyCustomAttributes(List<User> users) {
        this.logger.info("Verify CustomAttributes for users: {}", users);
        if (users == null || users.isEmpty()) {
            return users;
        }
        for (User user : users) {
            List customAttributes = user.getCustomAttributes();
            this.removeInActiveCustomAttribute(customAttributes);
        }
        return users;
    }

    public List<CustomObjectAttribute> removeInActiveCustomAttribute(List<CustomObjectAttribute> customAttributes) {
        if (customAttributes == null || customAttributes.isEmpty()) {
            return customAttributes;
        }
        Iterator<CustomObjectAttribute> it = customAttributes.iterator();
        while (it.hasNext()) {
            String attributeName = it.next().getName();
            this.logger.debug("Verify status of attributeName: {}", (Object)attributeName);
            List<JansAttribute> attList = this.findAttributeByName(attributeName);
            this.logger.debug("attributeName:{} data is attList: {}", (Object)attributeName, attList);
            if (!CollectionUtils.isNotEmpty(attList) || GluuStatus.ACTIVE.getValue().equalsIgnoreCase(attList.get(0).getStatus().getValue())) continue;
            this.logger.info("\n\n*** Removing attribute as it is not active attributeName: {} , status:{} ***\n", (Object)attributeName, (Object)attList.get(0).getStatus().getValue());
            it.remove();
        }
        return customAttributes;
    }

    public List<JansAttribute> findAttributeByName(String name) {
        return this.persistenceEntryManager.findEntries(this.getDnForAttribute(null), JansAttribute.class, Filter.createEqualityFilter((String)"jansAttrName", (Object)name));
    }

    public List<JansAttribute> getRequiredAttributes() {
        List jansAttributes = null;
        try {
            Filter requiredFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"jansRequired", (Object)true), Filter.createEqualityFilter((String)"jansStatus", (Object)"active")});
            this.logger.info("requiredFilter:{}", (Object)requiredFilter);
            jansAttributes = this.persistenceEntryManager.findEntries(this.getDnForAttribute(null), JansAttribute.class, requiredFilter);
            this.logger.info("Required JansAttribute jansAttributes:{}", (Object)jansAttributes);
        }
        catch (Exception ex) {
            this.logger.error("Failed to load required attribute", (Throwable)ex);
        }
        return jansAttributes;
    }

    public List<String> getJansAttributeName(List<JansAttribute> jansAttributeList) {
        ArrayList<String> jansAttributeNameList = null;
        if (jansAttributeList == null || jansAttributeList.isEmpty()) {
            return jansAttributeNameList;
        }
        jansAttributeNameList = new ArrayList<String>();
        for (JansAttribute attribute : jansAttributeList) {
            jansAttributeNameList.add(attribute.getName());
        }
        return jansAttributeNameList;
    }

    private String getDnForAttribute(String inum) {
        String attributesDn = this.staticConfiguration.getBaseDn().getAttributes();
        if (StringHelper.isEmpty((String)inum)) {
            return attributesDn;
        }
        return String.format("inum=%s,%s", inum, attributesDn);
    }

    public void validateAttributes(List<CustomObjectAttribute> customAttributes) {
        if (customAttributes == null || customAttributes.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (CustomObjectAttribute customObjectAttribute : customAttributes) {
            this.logger.info("customObjectAttribute.getName():{}", (Object)customObjectAttribute.getName());
            JansAttribute attribute = this.attributeService.getAttributeByName(customObjectAttribute.getName());
            AttributeValidation validation = null;
            if (attribute != null) {
                validation = attribute.getAttributeValidation();
            }
            this.logger.info("customObjectAttribute.getName():{}, validation:{}", (Object)customObjectAttribute.getName(), (Object)validation);
            if (validation == null) continue;
            String errorMsg = this.validateCustomAttributes(customObjectAttribute, validation);
            this.logger.info("customObjectAttribute.getName():{}, errorMsg:{}", (Object)customObjectAttribute.getName(), (Object)errorMsg);
            if (!StringUtils.isNotBlank((CharSequence)errorMsg)) continue;
            sb.append(errorMsg);
        }
        if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
            this.logger.error("Attribute validation failed with error msg:{} \n", (Object)sb);
            throw new InvalidAttributeException(sb.toString());
        }
    }

    private String validateCustomAttributes(CustomObjectAttribute customObjectAttribute, AttributeValidation attributeValidation) {
        this.logger.info("Validate attributeValidation:{}", (Object)attributeValidation);
        StringBuilder sb = new StringBuilder();
        if (customObjectAttribute == null || attributeValidation == null) {
            return sb.toString();
        }
        String attributeName = customObjectAttribute.getName();
        try {
            Pattern pattern;
            Matcher matcher;
            String attributeValue = String.valueOf(customObjectAttribute.getValue());
            if (StringUtils.isBlank((CharSequence)attributeValue)) {
                return sb.toString();
            }
            Integer minvalue = attributeValidation.getMinLength();
            Integer maxValue = attributeValidation.getMaxLength();
            String regexpValue = attributeValidation.getRegexp();
            this.logger.info("Validate attributeValue.length():{}, attributeValidation.getMinLength():{}, attributeValidation.getMaxLength():{}, attributeValidation.getRegexp():{}", new Object[]{attributeValue.length(), attributeValidation.getMinLength(), attributeValidation.getMaxLength(), attributeValidation.getRegexp()});
            if (minvalue != null && attributeValue.length() < minvalue) {
                sb.append(",must be at least " + minvalue + " characters");
            }
            if (maxValue != null && attributeValue.length() > maxValue) {
                sb.append(",must be less than " + maxValue + " characters");
            }
            if (StringUtils.isNotBlank((CharSequence)regexpValue) && !(matcher = (pattern = Pattern.compile(regexpValue)).matcher(attributeValue)).matches()) {
                sb.append(",must match (" + regexpValue + ") pattern");
            }
        }
        catch (Exception ex) {
            this.logger.error("Error while validating attributeName:{}", (Object)attributeName);
        }
        this.logger.info("Validate reuslt for attributeName:{} is sb :{} ", (Object)attributeName, (Object)sb);
        if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
            sb.insert(0, "'" + attributeName + "' -> ");
            sb.append("  ");
        }
        return sb.toString();
    }
}

