/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.mgt.rest;

import com.github.fge.jsonpatch.JsonPatchException;
import io.jans.as.common.model.common.User;
import io.jans.as.model.util.Util;
import io.jans.configapi.core.model.ApiError;
import io.jans.configapi.core.model.exception.ApiApplicationException;
import io.jans.configapi.core.rest.BaseResource;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.core.util.ApiErrorResponse;
import io.jans.configapi.plugin.mgt.model.user.CustomUser;
import io.jans.configapi.plugin.mgt.model.user.UserPatchRequest;
import io.jans.configapi.plugin.mgt.service.UserMgmtService;
import io.jans.configapi.plugin.mgt.util.MgtUtil;
import io.jans.model.GluuStatus;
import io.jans.model.SearchRequest;
import io.jans.orm.model.PagedResult;
import io.jans.util.StringHelper;
import io.jans.util.exception.InvalidAttributeException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Path(value="/configuser")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ApplicationScoped
public class UserResource
extends BaseResource {
    private static final String USER = "user";
    private static final String MAIL = "mail";
    private static final String DISPLAY_NAME = "displayName";
    private static final String GIVEN_NAME = "givenName";
    private static final String USER_PWD = "userPassword";
    private static final String INUM = "inum";
    private static final String USER_PLACEHOLDER = "user:{}";
    private static final String USER_UPDATE_FLAG_PLACEHOLDER = "user:{}, isUpdate:{}";
    @Inject
    Logger logger;
    @Inject
    MgtUtil mgtUtil;
    @Inject
    UserMgmtService userMgmtSrv;

    @Operation(summary="Gets list of users", description="Gets list of users", operationId="get-user", tags={"Configuration \u2013 User Management"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/user.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserPagedResult.class), examples={@ExampleObject(name="Response json example", value="example/user/user-all.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/user.readonly"})
    public Response getUsers(@Parameter(description="Search size - max size of the results to return") @DefaultValue(value="50") @QueryParam(value="limit") int limit, @Parameter(description="Search pattern") @DefaultValue(value="") @QueryParam(value="pattern") String pattern, @Parameter(description="The 1-based index of the first query result") @DefaultValue(value="0") @QueryParam(value="startIndex") int startIndex, @Parameter(description="Attribute whose value will be used to order the returned response") @DefaultValue(value="inum") @QueryParam(value="sortBy") String sortBy, @Parameter(description="Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"") @DefaultValue(value="ascending") @QueryParam(value="sortOrder") String sortOrder, @Parameter(description="Field and value pair for seraching", examples={@ExampleObject(name="Field value example", value="mail=abc@mail.com,jansStatus=true")}) @DefaultValue(value="") @QueryParam(value="fieldValuePair") String fieldValuePair) throws IllegalAccessException, InvocationTargetException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("User search param - limit:{}, pattern:{}, startIndex:{}, sortBy:{}, sortOrder:{}, fieldValuePair:{}", new Object[]{Util.escapeLog((Object)limit), Util.escapeLog((Object)pattern), Util.escapeLog((Object)startIndex), Util.escapeLog((Object)sortBy), Util.escapeLog((Object)sortOrder), Util.escapeLog((Object)fieldValuePair)});
        }
        SearchRequest searchReq = this.createSearchRequest(this.userMgmtSrv.getPeopleBaseDn(), pattern, sortBy, sortOrder, startIndex, limit, null, this.userMgmtSrv.getUserExclusionAttributesAsString(), this.mgtUtil.getRecordMaxCount(), fieldValuePair, CustomUser.class);
        return Response.ok((Object)((Object)this.doSearch(searchReq, true))).build();
    }

    @Operation(summary="Get User by Inum", description="Get User by Inum", operationId="get-user-by-inum", tags={"Configuration \u2013 User Management"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/user.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=CustomUser.class, description="CustomUser identified by inum"), examples={@ExampleObject(name="Response json example", value="example/user/user.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/user.readonly"})
    @Path(value="{inum}")
    public Response getUserByInum(@Parameter(description="User identifier") @PathParam(value="inum") @NotNull String inum) throws IllegalAccessException, InvocationTargetException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("User search by inum:{}", (Object)Util.escapeLog((Object)inum));
        }
        User user = this.userMgmtSrv.getUserBasedOnInum(inum);
        UserResource.checkResourceNotNull((Object)user, (String)USER);
        this.logger.debug(USER_PLACEHOLDER, (Object)user);
        user = this.excludeUserAttributes(user);
        this.logger.debug(USER_PLACEHOLDER, (Object)user);
        CustomUser customUser = this.getCustomUser(user, true);
        this.logger.info("customUser:{}", (Object)customUser);
        return Response.ok((Object)((Object)customUser)).build();
    }

    @Operation(summary="Create new User", description="Create new User", operationId="post-user", tags={"Configuration \u2013 User Management"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/user.write"})})
    @RequestBody(description="User object", content={@Content(mediaType="application/json", schema=@Schema(implementation=CustomUser.class), examples={@ExampleObject(name="Request json example", value="example/user/user-post.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Created", content={@Content(mediaType="application/json", schema=@Schema(implementation=CustomUser.class, description="Created Object"), examples={@ExampleObject(name="Response json example", value="example/user/user.json")})}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="InternalServerError"))})})
    @POST
    @ProtectedApi(scopes={"https://jans.io/oauth/config/user.write"})
    public Response createUser(@Valid CustomUser customUser, @Parameter(description="Boolean flag to indicate if attributes to be removed for non-LDAP DB. Default value is true, indicating non-LDAP attributes will be removed from request.") @DefaultValue(value="true") @QueryParam(value="removeNonLDAPAttributes") boolean removeNonLDAPAttributes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("User details to be added - customUser:{}, removeNonLDAPAttributes:{}", (Object)Util.escapeLog((Object)((Object)customUser)), (Object)removeNonLDAPAttributes);
        }
        try {
            User user = this.setUserAttributes(customUser);
            this.userMgmtSrv.parseBirthDateAttribute(user);
            this.logger.debug("Create  user:{}", (Object)user);
            this.checkMissingAttributes(user, null);
            this.ignoreCustomAttributes(user, removeNonLDAPAttributes);
            this.validateUser(user, false);
            this.validateAttributes(user);
            this.logger.info("Service call to create user:{}", (Object)user);
            user = this.userMgmtSrv.addUser(user, true);
            this.logger.info("User created {}", (Object)user);
            user = this.excludeUserAttributes(user);
            customUser = this.getCustomUser(user, removeNonLDAPAttributes);
            this.logger.info("newly created customUser:{}", (Object)customUser);
        }
        catch (ApiApplicationException ae) {
            this.logger.error(ApiErrorResponse.CREATE_USER_ERROR.getDescription(), (Throwable)ae);
            UserResource.throwBadRequestException((String)"USER_CREATION_ERROR", (String)ae.getMessage());
        }
        catch (InvalidAttributeException iae) {
            this.logger.error("InvalidAttributeException while creating user is:{}, cause:{}", (Object)iae, (Object)iae.getCause());
            UserResource.throwBadRequestException((String)"USER_CREATION_ERROR", (String)iae.getMessage());
        }
        catch (Exception ex) {
            this.logger.error("Exception while creating user is - ", (Throwable)ex);
            UserResource.throwInternalServerException((Throwable)ex);
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)customUser).build();
    }

    @Operation(summary="Update User", description="Update User", operationId="put-user", tags={"Configuration \u2013 User Management"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/user.write"})})
    @RequestBody(description="User object", content={@Content(mediaType="application/json", schema=@Schema(implementation=CustomUser.class), examples={@ExampleObject(name="Request json example", value="example/user/user.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=CustomUser.class), examples={@ExampleObject(name="Response json example", value="example/user/user.json")})}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="InternalServerError"))})})
    @PUT
    @ProtectedApi(scopes={"https://jans.io/oauth/config/user.write"})
    public Response updateUser(@Valid CustomUser customUser, @Parameter(description="Boolean flag to indicate if attributes to be removed for non-LDAP DB. Default value is true, indicating non-LDAP attributes will be removed from request.") @DefaultValue(value="true") @QueryParam(value="removeNonLDAPAttributes") boolean removeNonLDAPAttributes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("User details to be updated - customUser:{}, removeNonLDAPAttributes:{}", (Object)Util.escapeLog((Object)((Object)customUser)), (Object)removeNonLDAPAttributes);
        }
        try {
            User user = this.setUserAttributes(customUser);
            this.userMgmtSrv.parseBirthDateAttribute(user);
            this.logger.debug("Create  user:{}", (Object)user);
            List<String> excludeAttributes = List.of(USER_PWD);
            this.checkMissingAttributes(user, excludeAttributes);
            this.ignoreCustomAttributes(user, removeNonLDAPAttributes);
            this.validateUser(user, true);
            this.validateAttributes(user);
            this.logger.info("Call update user:{}", (Object)user);
            user = this.userMgmtSrv.updateUser(user);
            this.logger.info("Updated user:{}", (Object)user);
            user = this.excludeUserAttributes(user);
            customUser = this.getCustomUser(user, removeNonLDAPAttributes);
            this.logger.info("updated customUser:{}", (Object)customUser);
        }
        catch (ApiApplicationException ae) {
            this.logger.error(ApiErrorResponse.UPDATE_USER_ERROR.getDescription(), (Throwable)ae);
            UserResource.throwBadRequestException((String)"USER_UPDATE_ERROR", (String)ae.getMessage());
        }
        catch (InvalidAttributeException iae) {
            this.logger.error("InvalidAttributeException while updating user is:{}, cause:{}", (Object)iae, (Object)iae.getCause());
            UserResource.throwBadRequestException((String)"USER_UPDATE_ERROR", (String)iae.getMessage());
        }
        catch (Exception ex) {
            this.logger.error("Exception while updating user is - ", (Throwable)ex);
            UserResource.throwInternalServerException((Throwable)ex);
        }
        return Response.ok((Object)((Object)customUser)).build();
    }

    @Operation(summary="Patch user properties by Inum", description="Patch user properties by Inum", operationId="patch-user-by-inum", tags={"Configuration \u2013 User Management"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/user.write"})})
    @RequestBody(description="UserPatchRequest", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserPatchRequest.class), examples={@ExampleObject(name="Request json example", value="example/user/user-patch.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=CustomUser.class, description="Patched CustomUser Object"), examples={@ExampleObject(name="Response json example", value="example/user/user.json")})}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @ProtectedApi(scopes={"https://jans.io/oauth/config/user.write"})
    @Path(value="{inum}")
    public Response patchUser(@Parameter(description="User identifier") @PathParam(value="inum") @NotNull String inum, @NotNull UserPatchRequest userPatchRequest, @Parameter(description="Boolean flag to indicate if attributes to be removed for non-LDAP DB. Default value is true, indicating non-LDAP attributes will be removed from request.") @DefaultValue(value="true") @QueryParam(value="removeNonLDAPAttributes") boolean removeNonLDAPAttributes) throws IllegalAccessException, InvocationTargetException, JsonPatchException, IOException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("User:{} to be patched with :{}, removeNonLDAPAttributes:{} ", new Object[]{Util.escapeLog((Object)inum), Util.escapeLog((Object)userPatchRequest), removeNonLDAPAttributes});
        }
        CustomUser customUser = null;
        try {
            User existingUser = this.userMgmtSrv.getUserBasedOnInum(inum);
            this.userMgmtSrv.parseBirthDateAttribute(existingUser);
            UserResource.checkResourceNotNull((Object)existingUser, (String)USER);
            this.ignoreCustomAttributes(existingUser, removeNonLDAPAttributes);
            existingUser = this.userMgmtSrv.patchUser(inum, userPatchRequest);
            this.logger.debug("Patched user:{}", (Object)existingUser);
            existingUser = this.excludeUserAttributes(existingUser);
            customUser = this.getCustomUser(existingUser, removeNonLDAPAttributes);
            this.logger.info("patched customUser:{}", (Object)customUser);
        }
        catch (InvalidAttributeException iae) {
            this.logger.error("InvalidAttributeException while updating user is:{}, cause:{}", (Object)iae, (Object)iae.getCause());
            UserResource.throwBadRequestException((String)"USER_PATCH_ERROR", (String)iae.getMessage());
        }
        catch (Exception ex) {
            this.logger.error("Exception while pactching user is:{}, cause:{}", (Object)ex, (Object)ex.getCause());
            UserResource.throwInternalServerException((Throwable)ex);
        }
        return Response.ok(customUser).build();
    }

    @Operation(summary="Delete User", description="Delete User", operationId="delete-user", tags={"Configuration \u2013 User Management"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/user.delete"})})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @DELETE
    @Path(value="{inum}")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/user.delete"})
    public Response deleteUser(@Parameter(description="User identifier") @PathParam(value="inum") @NotNull String inum) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("User to be deleted - inum:{} ", (Object)Util.escapeLog((Object)inum));
        }
        User user = this.userMgmtSrv.getUserBasedOnInum(inum);
        UserResource.checkResourceNotNull((Object)user, (String)USER);
        this.userMgmtSrv.removeUser(user);
        return Response.noContent().build();
    }

    private UserPagedResult doSearch(SearchRequest searchReq, boolean removeNonLDAPAttributes) throws IllegalAccessException, InvocationTargetException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("User search params - searchReq:{}, removeNonLDAPAttributes:{} ", (Object)Util.escapeLog((Object)searchReq), (Object)removeNonLDAPAttributes);
        }
        PagedResult<User> pagedResult = this.userMgmtSrv.searchUsers(searchReq);
        if (this.logger.isTraceEnabled()) {
            this.logger.debug("PagedResult  - pagedResult:{}", pagedResult);
        }
        UserPagedResult pagedCustomUser = new UserPagedResult();
        if (pagedResult != null) {
            this.logger.debug("Users fetched  - pagedResult.getEntries():{}", (Object)pagedResult.getEntries());
            List<Object> users = pagedResult.getEntries();
            users = this.userMgmtSrv.excludeAttributes(users, searchReq.getExcludedAttributesStr());
            this.logger.debug("Users fetched  - users:{}", users);
            users = users.stream().map(user -> this.userMgmtSrv.parseBirthDateAttribute((User)user)).collect(Collectors.toList());
            List<CustomUser> customUsers = this.getCustomUserList(users, removeNonLDAPAttributes);
            pagedCustomUser.setStart(pagedResult.getStart());
            pagedCustomUser.setEntriesCount(pagedResult.getEntriesCount());
            pagedCustomUser.setTotalEntriesCount(pagedResult.getTotalEntriesCount());
            pagedCustomUser.setEntries(customUsers);
        }
        this.logger.info("User pagedCustomUser:{}", (Object)pagedCustomUser);
        return pagedCustomUser;
    }

    private User excludeUserAttributes(User user) throws IllegalAccessException, InvocationTargetException {
        return this.userMgmtSrv.excludeAttributes(user, this.userMgmtSrv.getUserExclusionAttributesAsString());
    }

    private void checkMissingAttributes(User user, List<String> excludeAttributes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ApiApplicationException {
        String missingAttributes = this.userMgmtSrv.checkMandatoryFields(user, excludeAttributes);
        this.logger.debug("missingAttributes:{}", (Object)missingAttributes);
        if (StringHelper.isEmpty((String)missingAttributes)) {
            return;
        }
        throw new ApiApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), String.format(ApiErrorResponse.MISSING_ATTRIBUTES.getDescription(), missingAttributes));
    }

    private void validateUser(User user, boolean isUpdate) throws ApiApplicationException {
        this.logger.info(USER_UPDATE_FLAG_PLACEHOLDER, (Object)user, (Object)isUpdate);
        if (user == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        String msg = this.validateUserName(user, isUpdate);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            sb.append(msg);
        }
        if (StringUtils.isNotBlank((CharSequence)(msg = this.validateUserEmail(user, isUpdate)))) {
            sb.append(msg);
        }
        if (sb.length() > 0) {
            throw new ApiApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), String.format(ApiErrorResponse.GENERAL_ERROR.getDescription(), sb.toString()));
        }
    }

    private String validateUserName(User user, boolean isUpdate) {
        this.logger.info(USER_UPDATE_FLAG_PLACEHOLDER, (Object)user, (Object)isUpdate);
        String msg = null;
        if (user == null) {
            return msg;
        }
        String inum = user.getAttribute(INUM);
        String name = user.getUserId();
        List<User> sameNameUser = this.userMgmtSrv.getUserByName(name);
        this.logger.info(" sameNameUser:{}", sameNameUser);
        if (sameNameUser != null && !sameNameUser.isEmpty()) {
            List users = null;
            users = isUpdate ? sameNameUser.stream().filter(e -> !e.getAttribute(INUM).equalsIgnoreCase(inum)).collect(Collectors.toList()) : sameNameUser.stream().filter(e -> e.getUserId().equalsIgnoreCase(name)).collect(Collectors.toList());
            if (users != null && !users.isEmpty()) {
                msg = String.format(ApiErrorResponse.SAME_NAME_USER_EXISTS_ERROR.getDescription(), name);
            }
        }
        return msg;
    }

    private String validateUserEmail(User user, boolean isUpdate) {
        this.logger.info(USER_UPDATE_FLAG_PLACEHOLDER, (Object)user, (Object)isUpdate);
        String msg = null;
        if (user == null) {
            return msg;
        }
        String inum = user.getAttribute(INUM);
        String email = user.getAttribute(MAIL);
        List<User> sameEmailUser = this.userMgmtSrv.getUserByEmail(email);
        this.logger.info(" sameEmailUser:{}", sameEmailUser);
        if (sameEmailUser != null && !sameEmailUser.isEmpty()) {
            List usersList = null;
            if (isUpdate) {
                usersList = sameEmailUser.stream().filter(e -> !e.getAttribute(INUM).equalsIgnoreCase(inum)).collect(Collectors.toList());
            }
            if (!isUpdate || usersList != null && !usersList.isEmpty()) {
                msg = String.format(ApiErrorResponse.SAME_NAME_EMAIL_EXISTS_ERROR.getDescription(), email);
            }
        }
        return msg;
    }

    private void validateAttributes(User user) {
        this.userMgmtSrv.validateAttributes(user.getCustomAttributes());
    }

    private List<CustomUser> getCustomUserList(List<User> users, boolean removeNonLDAPAttributes) {
        ArrayList<CustomUser> customUserList = new ArrayList<CustomUser>();
        if (users == null || users.isEmpty()) {
            return customUserList;
        }
        for (User user : users) {
            CustomUser customUser = new CustomUser();
            this.setParentAttributes(customUser, user, removeNonLDAPAttributes);
            customUserList.add(customUser);
            this.ignoreCustomAttributes(customUser, removeNonLDAPAttributes);
        }
        this.logger.debug("Custom Users - customUserList:{}", customUserList);
        return customUserList;
    }

    private CustomUser getCustomUser(User user, Boolean ignoreCustomAttributes) {
        CustomUser customUser = new CustomUser();
        if (user == null) {
            return customUser;
        }
        this.setParentAttributes(customUser, user, ignoreCustomAttributes);
        this.logger.debug("Custom User - customUser:{}", (Object)customUser);
        return customUser;
    }

    public CustomUser setParentAttributes(CustomUser customUser, User user, boolean removeNonLDAPAttributes) {
        customUser.setBaseDn(user.getBaseDn());
        customUser.setCreatedAt(user.getCreatedAt());
        customUser.setCustomAttributes(user.getCustomAttributes());
        customUser.setCustomObjectClasses(user.getCustomObjectClasses());
        customUser.setDn(user.getDn());
        customUser.setOxAuthPersistentJwt(user.getOxAuthPersistentJwt());
        customUser.setUpdatedAt(user.getUpdatedAt());
        customUser.setUserId(user.getUserId());
        customUser.setStatus(user.getStatus());
        this.ignoreCustomAttributes(customUser, removeNonLDAPAttributes);
        return this.setCustomUserAttributes(customUser, user);
    }

    public CustomUser setCustomUserAttributes(CustomUser customUser, User user) {
        customUser.setMail(user.getAttribute(MAIL));
        customUser.setDisplayName(user.getAttribute(DISPLAY_NAME));
        customUser.setGivenName(user.getAttribute(GIVEN_NAME));
        customUser.setUserPassword(user.getAttribute(USER_PWD));
        customUser.setInum(user.getAttribute(INUM));
        customUser.setStatus(user.getStatus());
        customUser.removeAttribute(MAIL);
        customUser.removeAttribute(DISPLAY_NAME);
        customUser.removeAttribute(GIVEN_NAME);
        customUser.removeAttribute(USER_PWD);
        customUser.removeAttribute(INUM);
        return customUser;
    }

    private User setUserAttributes(CustomUser customUser) {
        User user = new User();
        user.setBaseDn(customUser.getBaseDn());
        user.setCreatedAt(customUser.getCreatedAt());
        user.setCustomAttributes(customUser.getCustomAttributes());
        user.setCustomObjectClasses(customUser.getCustomObjectClasses());
        user.setDn(customUser.getDn());
        user.setOxAuthPersistentJwt(customUser.getOxAuthPersistentJwt());
        user.setUpdatedAt(customUser.getUpdatedAt());
        user.setUserId(customUser.getUserId());
        user.setStatus(customUser.getStatus() != null ? customUser.getStatus() : GluuStatus.ACTIVE);
        return this.setUserCustomAttributes(customUser, user);
    }

    private User setUserCustomAttributes(CustomUser customUser, User user) {
        if (StringUtils.isNotBlank((CharSequence)customUser.getMail())) {
            user.setAttribute(MAIL, (Object)customUser.getMail(), Boolean.valueOf(false));
        }
        user.setAttribute(DISPLAY_NAME, (Object)customUser.getDisplayName(), Boolean.valueOf(false));
        user.setAttribute(GIVEN_NAME, (Object)customUser.getGivenName(), Boolean.valueOf(false));
        if (StringUtils.isNotBlank((CharSequence)customUser.getUserPassword())) {
            user.setAttribute(USER_PWD, (Object)customUser.getUserPassword(), Boolean.valueOf(false));
        }
        if (StringUtils.isNotBlank((CharSequence)customUser.getInum())) {
            user.setAttribute(INUM, (Object)customUser.getInum(), Boolean.valueOf(false));
        }
        return user;
    }

    private User ignoreCustomAttributes(User user, boolean removeNonLDAPAttributes) {
        this.logger.info("\n\n ** validate User CustomObjectClasses - User user:{}, removeNonLDAPAttributes:{}, user.getCustomObjectClasses():{}, userMgmtSrv.getPersistenceType():{}, userMgmtSrv.isLDAP():?{}", new Object[]{user, removeNonLDAPAttributes, user.getCustomObjectClasses(), this.userMgmtSrv.getPersistenceType(), this.userMgmtSrv.isLDAP()});
        if (removeNonLDAPAttributes) {
            return this.userMgmtSrv.ignoreCustomObjectClassesForNonLDAP(user);
        }
        return user;
    }

    private class UserPagedResult
    extends PagedResult<CustomUser> {
        private UserPagedResult() {
        }
    }
}

