/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.plugin.mgt.util;

import io.jans.configapi.configuration.ConfigurationFactory;
import io.jans.configapi.plugin.mgt.model.config.UserMgtConfigSource;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;

@ApplicationScoped
public class MgtUtil {
    @Inject
    Logger logger;
    @Inject
    ConfigurationFactory configurationFactory;
    @Inject
    UserMgtConfigSource configSource;
    public static final String DATE_PATTERN_YYYY_MM_DD = "yyyy-MM-dd";

    public int getRecordMaxCount() {
        this.logger.trace(" MaxCount details - ApiAppConfiguration.MaxCount():{}, DEFAULT_MAX_COUNT:{} ", (Object)this.configurationFactory.getApiAppConfiguration().getMaxCount(), (Object)200);
        return this.configurationFactory.getApiAppConfiguration().getMaxCount() > 0 ? this.configurationFactory.getApiAppConfiguration().getMaxCount() : 200;
    }

    public Date parseStringToDateObj(String dateString) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_PATTERN_YYYY_MM_DD);
        Date date = null;
        try {
            date = dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            this.logger.error("Error in parsing string to date. Allowed Date Format : {},  Date-String : {} ", (Object)DATE_PATTERN_YYYY_MM_DD, (Object)dateString);
        }
        return date;
    }
}

