/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.cache;

import io.jans.service.cache.AbstractCacheProvider;
import io.jans.service.cache.CacheConfiguration;
import io.jans.service.cache.CacheProvider;
import io.jans.service.cache.CacheProviderType;
import io.jans.service.cache.InMemoryCacheProvider;
import io.jans.service.cache.LocalCache;
import io.jans.service.cache.MemcachedProvider;
import io.jans.service.cache.NativePersistenceCacheProvider;
import io.jans.service.cache.RedisProvider;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;

@ApplicationScoped
@Named
public class CacheProviderFactory {
    @Inject
    private Logger log;
    @Inject
    private CacheConfiguration cacheConfiguration;
    @Inject
    @Any
    private Instance<CacheProvider> instance;

    @Produces
    @ApplicationScoped
    public CacheProvider getCacheProvider() {
        this.log.debug("Started to create cache provider");
        return this.getCacheProvider(this.cacheConfiguration);
    }

    public CacheProvider getCacheProvider(CacheConfiguration cacheConfiguration) {
        CacheProviderType cacheProviderType = cacheConfiguration.getCacheProviderType();
        if (cacheProviderType == null) {
            this.log.error("Failed to initialize cacheProvider, cacheProviderType is null. Fallback to IN_MEMORY type.");
            cacheProviderType = CacheProviderType.IN_MEMORY;
        }
        AbstractCacheProvider cacheProvider = null;
        switch (cacheProviderType) {
            case IN_MEMORY: {
                cacheProvider = (AbstractCacheProvider)this.instance.select(InMemoryCacheProvider.class, new Annotation[0]).get();
                break;
            }
            case MEMCACHED: {
                cacheProvider = (AbstractCacheProvider)this.instance.select(MemcachedProvider.class, new Annotation[0]).get();
                break;
            }
            case REDIS: {
                cacheProvider = (AbstractCacheProvider)this.instance.select(RedisProvider.class, new Annotation[0]).get();
                break;
            }
            case NATIVE_PERSISTENCE: {
                cacheProvider = (AbstractCacheProvider)this.instance.select(NativePersistenceCacheProvider.class, new Annotation[0]).get();
            }
        }
        if (cacheProvider == null) {
            throw new RuntimeException("Failed to initialize cacheProvider, cacheProviderType is unsupported: " + cacheProviderType);
        }
        cacheProvider.create();
        return cacheProvider;
    }

    @Produces
    @ApplicationScoped
    @LocalCache
    public CacheProvider getLocalCacheProvider() {
        this.log.debug("Started to create local cache provider");
        CacheProviderType cacheProviderType = CacheProviderType.IN_MEMORY;
        AbstractCacheProvider cacheProvider = (AbstractCacheProvider)this.instance.select(InMemoryCacheProvider.class, new Annotation[0]).get();
        if (cacheProvider == null) {
            throw new RuntimeException("Failed to initialize cacheProvider, cacheProviderType is unsupported: " + cacheProviderType);
        }
        cacheProvider.create();
        return cacheProvider;
    }
}

