/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.document.store.provider;

import io.jans.orm.PersistenceEntryManager;
import io.jans.service.document.store.conf.DBDocumentStoreConfiguration;
import io.jans.service.document.store.conf.DocumentStoreConfiguration;
import io.jans.service.document.store.conf.DocumentStoreType;
import io.jans.service.document.store.exception.DocumentException;
import io.jans.service.document.store.exception.WriteDocumentException;
import io.jans.service.document.store.model.Document;
import io.jans.service.document.store.provider.DocumentStoreProvider;
import io.jans.service.document.store.service.DBDocumentService;
import io.jans.util.Pair;
import io.jans.util.StringHelper;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.codec.binary.Base64InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DBDocumentStoreProvider
extends DocumentStoreProvider<Document> {
    protected static final String[] FIND_DOCUMENT_CHECK_ATTRIBUTES = new String[]{"dn", "inum", "jansRevision", "displayName", "jansHash", "jansEnabled"};
    @Inject
    private Logger log;
    @Inject
    private DBDocumentService documentService;
    @Inject
    private DocumentStoreConfiguration documentStoreConfiguration;
    private DBDocumentStoreConfiguration dbDocumentStoreConfiguration;

    @Override
    public DocumentStoreType getProviderType() {
        return DocumentStoreType.DB;
    }

    @PostConstruct
    public void init() {
        this.dbDocumentStoreConfiguration = this.documentStoreConfiguration.getDbConfiguration();
    }

    public void configure(DocumentStoreConfiguration documentStoreConfiguration, PersistenceEntryManager persistenceEntryManager) {
        this.log = LoggerFactory.getLogger(DBDocumentStoreProvider.class);
        this.documentStoreConfiguration = documentStoreConfiguration;
        if (this.documentService == null) {
            this.documentService = new DBDocumentService(persistenceEntryManager);
        }
    }

    @Override
    public void create() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean hasDocument(String path) {
        this.log.debug("Has document: '{}'", (Object)path);
        if (StringHelper.isEmpty((String)path)) {
            throw new IllegalArgumentException("Specified path should not be empty!");
        }
        Document oxDocument = null;
        try {
            oxDocument = this.documentService.getDocumentByDisplayName(path);
            if (oxDocument != null) {
                return true;
            }
        }
        catch (Exception e) {
            this.log.error("Failed to check if path '" + path + "' exists in repository", (Throwable)e);
            throw new DocumentException(e);
        }
        return false;
    }

    @Override
    public String saveDocument(String path, String description, String documentContent, Charset charset, String module) {
        this.log.debug("Save document: '{}'", (Object)path);
        Document oxDocument = new Document();
        oxDocument.setDocument(documentContent);
        this.setFileNameAndPath(oxDocument, path);
        try {
            oxDocument.setInum(this.documentService.generateInumForNewDocument());
            String dn = "inum=" + oxDocument.getInum() + ",ou=document,o=jans";
            oxDocument.setDn(dn);
            oxDocument.setDescription(description);
            oxDocument.setEnabled(true);
            oxDocument.setService(module);
            this.documentService.addDocument(oxDocument);
            return path;
        }
        catch (Exception ex) {
            this.log.error("Failed to write document to file '{}'", (Object)path, (Object)ex);
            throw new WriteDocumentException(ex);
        }
    }

    @Override
    public String saveDocumentStream(String path, String description, InputStream documentStream, String module) {
        Document oxDocument = new Document();
        this.setFileNameAndPath(oxDocument, path);
        try {
            String documentContent = new String(documentStream.readAllBytes(), StandardCharsets.UTF_8);
            oxDocument.setDocument(documentContent);
            String inum = this.documentService.generateInumForNewDocument();
            oxDocument.setInum(inum);
            String dn = "inum=" + oxDocument.getInum() + ",ou=document,o=jans";
            oxDocument.setDn(dn);
            oxDocument.setDescription(description);
            oxDocument.setEnabled(true);
            oxDocument.setService(module);
            this.documentService.addDocument(oxDocument);
            return path;
        }
        catch (Exception e) {
            this.log.error("Failed to write document from stream to file '{}'", (Object)path, (Object)e);
            throw new WriteDocumentException(e);
        }
    }

    @Override
    public String saveBinaryDocumentStream(String path, String description, InputStream documentStream, String module) {
        return this.saveDocumentStream(path, description, (InputStream)new Base64InputStream(documentStream, true), module);
    }

    @Override
    public String readDocument(String name, Charset charset) {
        this.log.debug("Read document: '{}'", (Object)name);
        try {
            Document oxDocument = this.documentService.getDocumentByDisplayName(name);
            if (oxDocument != null) {
                return oxDocument.getDocument();
            }
        }
        catch (Exception e) {
            this.log.error("Failed to read document as stream from file '{}'", (Object)name, (Object)e);
            throw new DocumentException(e);
        }
        return null;
    }

    @Override
    public InputStream readDocumentAsStream(String name) {
        this.log.debug("Read document as stream: '{}'", (Object)name);
        String fileData = this.readDocument(name, null);
        if (fileData == null) {
            this.log.error("Document file '{}' isn't empty", (Object)name);
            return null;
        }
        return new ByteArrayInputStream(fileData.getBytes());
    }

    @Override
    public InputStream readBinaryDocumentAsStream(String path) {
        return new Base64InputStream(this.readDocumentAsStream(path), false);
    }

    @Override
    public String renameDocument(String currentPath, String destinationPath) {
        this.log.debug("Rename document: '{}' -> '{}'", (Object)currentPath, (Object)destinationPath);
        try {
            Document oxDocument = this.documentService.getDocumentByDisplayName(currentPath);
            if (oxDocument == null) {
                this.log.error("Document doesn't Exist with the name  '{}'", (Object)currentPath);
                return null;
            }
            this.setFileNameAndPath(oxDocument, destinationPath);
            this.documentService.updateDocument(oxDocument);
            Document oxDocumentDestination = this.documentService.getDocumentByDisplayName(destinationPath);
            if (oxDocumentDestination == null) {
                this.log.error("Failed to rename to destination file '{}'", (Object)destinationPath);
                return null;
            }
        }
        catch (Exception e) {
            this.log.error("Failed to rename to destination file '{}'", (Object)destinationPath);
            throw new WriteDocumentException(e);
        }
        return destinationPath;
    }

    @Override
    public boolean removeDocument(String path) {
        this.log.debug("Remove document: '{}'", (Object)path);
        try {
            Document oxDocument = this.documentService.getDocumentByDisplayName(path);
            if (oxDocument == null) {
                this.log.error(" document not exist file '{}'", (Object)path);
                return false;
            }
            this.documentService.removeDocument(oxDocument);
            return true;
        }
        catch (Exception e) {
            this.log.error("Failed to remove document file '{}'", (Object)path, (Object)e);
            throw new DocumentException(e);
        }
    }

    public String renameDocumentByDisplayName(String currentPath, String destinationPath) {
        this.log.debug("Rename document: '{}' -> '{}'", (Object)currentPath, (Object)destinationPath);
        try {
            Document oxDocument = this.documentService.getDocumentByDisplayName(currentPath);
            if (oxDocument == null) {
                this.log.error("Document doesn't Exist with the name  '{}'", (Object)currentPath);
                return null;
            }
            this.setFileNameAndPath(oxDocument, destinationPath);
            this.documentService.updateDocument(oxDocument);
            Document oxDocumentDestination = this.documentService.getDocumentByDisplayName(destinationPath);
            if (oxDocumentDestination == null) {
                this.log.error("Failed to rename to destination file '{}'", (Object)destinationPath);
                return null;
            }
        }
        catch (Exception e) {
            this.log.error("Failed to rename to destination file '{}'", (Object)destinationPath);
            throw new WriteDocumentException(e);
        }
        return destinationPath;
    }

    public String readDocumentByDisplayName(String filePath) {
        this.log.debug("Read document: '{}'", (Object)filePath);
        try {
            Document oxDocument = this.documentService.getDocumentByDisplayName(filePath);
            if (oxDocument != null) {
                return oxDocument.getDocument();
            }
        }
        catch (Exception e) {
            this.log.error("Failed to location of document as stream from file path'{}'", (Object)filePath, (Object)e);
            throw new DocumentException(e);
        }
        return null;
    }

    @Override
    public List<Document> findDocumentsByModules(List<String> moduleList, String ... attributes) {
        this.log.debug("Find documents for modules: '{}'", moduleList);
        try {
            List<Document> oxDocuments = this.documentService.findDocumentsListByModules(moduleList, attributes);
            return oxDocuments;
        }
        catch (Exception e) {
            this.log.error("Failed to find documents for modules '{}'", moduleList, (Object)e);
            throw new DocumentException(e);
        }
    }

    private void setFileNameAndPath(Document document, String path) {
        Pair<String, String> splittedPath = this.extractFileNameAndPath(path);
        document.setFileName((String)splittedPath.getSecond());
        document.setFilePath((String)splittedPath.getFirst());
    }

    public Pair<String, String> extractFileNameAndPath(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        Path parentPath = path.getParent();
        if (parentPath == null) {
            return new Pair(null, (Object)path.getFileName().toString());
        }
        return new Pair((Object)parentPath.toString(), (Object)path.getFileName().toString());
    }
}

