/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.document.store.service;

import io.jans.service.document.store.conf.DocumentStoreType;
import io.jans.service.document.store.provider.DocumentStore;
import io.jans.service.document.store.provider.DocumentStoreProvider;
import jakarta.inject.Inject;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;

public abstract class BaseDocumentStoreService<T>
implements DocumentStore<T> {
    @Inject
    private Logger log;

    @Override
    public boolean hasDocument(String path) {
        DocumentStoreProvider documentStoreProvider = this.getDocumentStoreProvider();
        return documentStoreProvider.hasDocument(path);
    }

    @Override
    public String saveDocument(String path, String description, String documentContent, Charset charset, String module) {
        DocumentStoreProvider documentStoreProvider = this.getDocumentStoreProvider();
        return documentStoreProvider.saveDocument(path, description, documentContent, charset, module);
    }

    @Override
    public String saveDocumentStream(String path, String description, InputStream documentStream, String module) {
        DocumentStoreProvider documentStoreProvider = this.getDocumentStoreProvider();
        return documentStoreProvider.saveDocumentStream(path, description, documentStream, module);
    }

    @Override
    public String saveBinaryDocumentStream(String path, String description, InputStream documentStream, String module) {
        return this.saveDocumentStream(path, description, documentStream, module);
    }

    @Override
    public String readDocument(String path, Charset charset) {
        DocumentStoreProvider documentStoreProvider = this.getDocumentStoreProvider();
        return documentStoreProvider.readDocument(path, charset);
    }

    @Override
    public InputStream readDocumentAsStream(String path) {
        DocumentStoreProvider documentStoreProvider = this.getDocumentStoreProvider();
        return documentStoreProvider.readDocumentAsStream(path);
    }

    @Override
    public InputStream readBinaryDocumentAsStream(String path) {
        DocumentStoreProvider documentStoreProvider = this.getDocumentStoreProvider();
        return documentStoreProvider.readBinaryDocumentAsStream(path);
    }

    @Override
    public String renameDocument(String currentPath, String destinationPath) {
        DocumentStoreProvider documentStoreProvider = this.getDocumentStoreProvider();
        return documentStoreProvider.renameDocument(currentPath, destinationPath);
    }

    @Override
    public boolean removeDocument(String path) {
        DocumentStoreProvider documentStoreProvider = this.getDocumentStoreProvider();
        return documentStoreProvider.removeDocument(path);
    }

    @Override
    public List<T> findDocumentsByModules(List moduleList, String ... attributes) {
        DocumentStoreProvider documentStoreProvider = this.getDocumentStoreProvider();
        return documentStoreProvider.findDocumentsByModules(moduleList, attributes);
    }

    @Override
    public DocumentStoreType getProviderType() {
        DocumentStoreProvider documentStoreProvider = this.getDocumentStoreProvider();
        return documentStoreProvider.getProviderType();
    }

    protected abstract DocumentStoreProvider getDocumentStoreProvider();
}

