/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.document.store;

import io.jans.service.document.store.conf.DocumentStoreConfiguration;
import io.jans.service.document.store.conf.DocumentStoreType;
import io.jans.service.document.store.provider.DocumentStoreProvider;
import io.jans.service.document.store.provider.JcaDocumentStoreProvider;
import io.jans.service.document.store.provider.LocalDocumentStoreProvider;
import io.jans.service.document.store.provider.WebDavDocumentStoreProvider;
import io.jans.util.security.StringEncrypter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneDocumentStoreProviderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(StandaloneDocumentStoreProviderFactory.class);
    private StringEncrypter stringEncrypter;

    public StandaloneDocumentStoreProviderFactory(StringEncrypter stringEncrypter) {
        this.stringEncrypter = stringEncrypter;
    }

    public DocumentStoreProvider getDocumentStoreProvider(DocumentStoreConfiguration documentStoreConfiguration) {
        DocumentStoreType documentStoreType = documentStoreConfiguration.getDocumentStoreType();
        if (documentStoreType == null) {
            LOG.error("Failed to initialize documentStoreProvider, documentStoreProviderType is null. Fallback to LOCAL type.");
            documentStoreType = DocumentStoreType.LOCAL;
        }
        DocumentStoreProvider documentStoreProvider = null;
        switch (documentStoreType) {
            case LOCAL: {
                LocalDocumentStoreProvider localDocumentStoreProvider = new LocalDocumentStoreProvider();
                localDocumentStoreProvider.configure(documentStoreConfiguration);
                localDocumentStoreProvider.init();
                documentStoreProvider = localDocumentStoreProvider;
                break;
            }
            case JCA: {
                if (this.stringEncrypter == null) {
                    throw new RuntimeException("Factory is not initialized properly. stringEncrypter is not specified");
                }
                JcaDocumentStoreProvider jcaDocumentStoreProvider = new JcaDocumentStoreProvider();
                jcaDocumentStoreProvider.configure(documentStoreConfiguration, this.stringEncrypter);
                jcaDocumentStoreProvider.init();
                documentStoreProvider = jcaDocumentStoreProvider;
                break;
            }
            case WEB_DAV: {
                if (this.stringEncrypter == null) {
                    throw new RuntimeException("Factory is not initialized properly. stringEncrypter is not specified");
                }
                WebDavDocumentStoreProvider webDavDocumentStoreProvider = new WebDavDocumentStoreProvider();
                webDavDocumentStoreProvider.configure(documentStoreConfiguration);
                webDavDocumentStoreProvider.init();
                documentStoreProvider = webDavDocumentStoreProvider;
            }
        }
        if (documentStoreProvider == null) {
            throw new RuntimeException("Failed to initialize documentStoreProvider, documentStoreProviderType is unsupported: " + documentStoreType);
        }
        documentStoreProvider.create();
        return documentStoreProvider;
    }
}

