/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.document.store.provider;

import io.jans.service.document.store.conf.DocumentStoreConfiguration;
import io.jans.service.document.store.conf.DocumentStoreType;
import io.jans.service.document.store.conf.WebDavDocumentStoreConfiguration;
import io.jans.service.document.store.provider.DocumentStoreProvider;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class WebDavDocumentStoreProvider
extends DocumentStoreProvider<String> {
    @Inject
    private Logger log;
    @Inject
    private DocumentStoreConfiguration documentStoreConfiguration;
    private WebDavDocumentStoreConfiguration webDavDocumentStoreConfiguration;

    @PostConstruct
    public void init() {
        this.webDavDocumentStoreConfiguration = this.documentStoreConfiguration.getWebDavConfiguration();
    }

    @Override
    public void create() {
        this.log.debug("Starting LocalDocumentStoreProvider ...");
    }

    public void configure(DocumentStoreConfiguration documentStoreConfiguration) {
        this.log = LoggerFactory.getLogger(DocumentStoreConfiguration.class);
        this.documentStoreConfiguration = documentStoreConfiguration;
    }

    @Override
    @PreDestroy
    public void destroy() {
        this.log.debug("Destroying LocalDocumentStoreProvider");
        this.log.debug("Destroyed LocalDocumentStoreProvider");
    }

    @Override
    public DocumentStoreType getProviderType() {
        return DocumentStoreType.WEB_DAV;
    }

    @Override
    public boolean hasDocument(String path) {
        return false;
    }

    @Override
    public String saveDocument(String path, String description, String documentContent, Charset charset, String module) {
        return null;
    }

    @Override
    public String saveDocumentStream(String path, String description, InputStream documentStream, String module) {
        return null;
    }

    @Override
    public String saveBinaryDocumentStream(String path, String description, InputStream documentStream, String module) {
        return null;
    }

    @Override
    public String readDocument(String path, Charset charset) {
        return null;
    }

    @Override
    public InputStream readBinaryDocumentAsStream(String path) {
        return null;
    }

    @Override
    public InputStream readDocumentAsStream(String path) {
        return null;
    }

    @Override
    public String renameDocument(String currentPath, String destinationPath) {
        return null;
    }

    @Override
    public boolean removeDocument(String path) {
        return false;
    }

    @Override
    public List<String> findDocumentsByModules(List<String> moduleList, String ... attributes) {
        throw new RuntimeException("Not yet implemented");
    }
}

