/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.exception;

import io.jans.service.exception.ExceptionHandler;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ExceptionHandlerExtension
implements Extension {
    private static final Logger log = LoggerFactory.getLogger((String)ExceptionHandlerExtension.class.getName());
    private Map<Class<? extends Throwable>, List<Method>> allExceptionHandlers = new HashMap<Class<? extends Throwable>, List<Method>>();

    public <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> pat) {
        AnnotatedTypeConfigurator cat = pat.configureAnnotatedType();
        ArrayList typeExceptionHandlerAnnotations = new ArrayList();
        for (AnnotatedMethodConfigurator methodConfiguration : cat.methods()) {
            AnnotatedMethod method = methodConfiguration.getAnnotated();
            if (method.getJavaMember().getExceptionTypes().length != 0) {
                log.trace("Handler method '{}' must not throw exceptions. Ignoring it.", (Object)method.getJavaMember());
                continue;
            }
            ArrayList methodAnnotations = new ArrayList();
            this.collectAnnotations(ExceptionHandler.class, method, methodAnnotations);
            for (ExceptionHandler eh : methodAnnotations) {
                for (Class<? extends Throwable> ex : eh.value()) {
                    List<Method> handlerMethods = this.allExceptionHandlers.get(ex);
                    if (handlerMethods == null) {
                        handlerMethods = new ArrayList<Method>();
                        this.allExceptionHandlers.put(ex, handlerMethods);
                    }
                    handlerMethods.add(method.getJavaMember());
                }
            }
        }
    }

    private <T> void collectAnnotations(Class<T> annotationType, AnnotatedMethod<?> method, List<T> values) {
        for (Annotation annotation : method.getAnnotations()) {
            this.collectAnnotations(annotationType, annotation, values);
        }
    }

    private <T> void collectAnnotations(Class<T> annotationType, Annotation annotation, List<T> values) {
        if (annotationType.isAssignableFrom(annotation.annotationType())) {
            values.add(annotation);
        }
    }

    public Map<Class<? extends Throwable>, List<Method>> getAllExceptionHandlers() {
        return this.allExceptionHandlers;
    }
}

