/*
 * Decompiled with CFR 0.152.
 */
package io.jans.i18n;

import io.jans.i18n.ExtendedResourceBundle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.spi.ResourceBundleControlProvider;

public class ExtendedResourceBundleControlProvider
implements ResourceBundleControlProvider {
    private static Path EXTERNAL_PATH;

    @Override
    public ResourceBundle.Control getControl(String baseName) {
        if (baseName.equals("jakarta.faces.Messages")) {
            System.out.println("Preparing control to load bundle with baseName: " + baseName);
            return new CustomControl();
        }
        return null;
    }

    static {
        Path customPath;
        File file;
        if (System.getProperty("server.base") != null && (file = (customPath = Paths.get(System.getProperty("server.base") + "/custom/i18n", new String[0])).toFile()).exists() && file.isDirectory()) {
            EXTERNAL_PATH = customPath;
        }
    }

    protected static class CustomControl
    extends ResourceBundle.Control {
        protected CustomControl() {
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String resourceName = this.toResourceName(this.toBundleName(baseName, locale), "properties");
            Properties properties = new Properties();
            try (InputStream input = loader.getResourceAsStream(resourceName);){
                InputStreamReader inputReader = new InputStreamReader(input, "UTF-8");
                properties.load(inputReader);
            }
            if (properties.isEmpty()) {
                System.out.println("Using default control to load bundle with baseName: " + baseName);
                return null;
            }
            Path externalResource = null;
            if (EXTERNAL_PATH != null) {
                externalResource = EXTERNAL_PATH.resolve(resourceName);
            }
            ExtendedResourceBundle.loadPropertiesFromFile(properties, externalResource);
            return new ExtendedResourceBundle(baseName, externalResource, properties);
        }
    }
}

