/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.el;

import com.sun.el.lang.FunctionMapperImpl;
import com.sun.el.lang.VariableMapperImpl;
import io.jans.service.el.ConstantResolver;
import io.jans.service.el.ExtendedELContext;
import jakarta.el.ArrayELResolver;
import jakarta.el.BeanELResolver;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELResolver;
import jakarta.el.FunctionMapper;
import jakarta.el.ListELResolver;
import jakarta.el.MapELResolver;
import jakarta.el.ResourceBundleELResolver;
import jakarta.el.VariableMapper;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;

@Dependent
public class ContextProducer {
    @Inject
    private BeanManager beanManager;

    @Produces
    @RequestScoped
    public ExtendedELContext createELContext() {
        ConstantResolver constantResolver = new ConstantResolver();
        CompositeELResolver resolver = this.createELResolver(constantResolver);
        return this.createELContext((ELResolver)resolver, (FunctionMapper)new FunctionMapperImpl(), (VariableMapper)new VariableMapperImpl(), constantResolver);
    }

    private CompositeELResolver createELResolver(ConstantResolver constantResolver) {
        CompositeELResolver resolver = new CompositeELResolver();
        resolver.add((ELResolver)constantResolver);
        resolver.add(this.beanManager.getELResolver());
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            resolver.add(facesContext.getELContext().getELResolver());
        }
        resolver.add((ELResolver)new MapELResolver());
        resolver.add((ELResolver)new ListELResolver());
        resolver.add((ELResolver)new ArrayELResolver());
        resolver.add((ELResolver)new ResourceBundleELResolver());
        resolver.add((ELResolver)new BeanELResolver());
        return resolver;
    }

    private ExtendedELContext createELContext(final ELResolver resolver, final FunctionMapper functionMapper, final VariableMapper variableMapper, final ConstantResolver constantResolver) {
        return new ExtendedELContext(){

            public ELResolver getELResolver() {
                return resolver;
            }

            public FunctionMapper getFunctionMapper() {
                return functionMapper;
            }

            public VariableMapper getVariableMapper() {
                return variableMapper;
            }

            @Override
            public ConstantResolver getConstantResolver() {
                return constantResolver;
            }
        };
    }
}

