/*
 * Decompiled with CFR 0.152.
 */
package io.jans.jsf2.customization;

import com.sun.faces.util.FacesLogger;
import io.jans.jsf2.customization.Utils;
import jakarta.faces.application.ApplicationConfigurationPopulator;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FacesConfigPopulator
extends ApplicationConfigurationPopulator {
    private static final String NAVIGATION_RULE = "navigation-rule";
    private static final String FACES_CONFIG_PATTERN = ".*\\.navigation\\.xml$";
    private static final String DEFAULT_NAVIGATION_PATH = "META-INF/navigation";
    private Logger log = LoggerFactory.getLogger(FacesConfigPopulator.class);

    public void populateApplicationConfiguration(Document toPopulate) {
        this.populateNavigationRules(toPopulate);
    }

    protected void populateNavigationRules(Document toPopulate) {
        this.log.debug("Starting configuration populator");
        if (Utils.isCustomPagesDirExists()) {
            String customPath = Utils.getCustomPagesPath();
            this.log.debug("Adding navigation rules from custom dir folder: {}", (Object)customPath);
            try {
                this.findAndUpdateNavigationRules(toPopulate, customPath);
            }
            catch (Exception ex) {
                FacesLogger.CONFIG.getLogger().log(Level.SEVERE, "Can't add customized navigation rules");
            }
        }
        try {
            this.log.debug("Adding navigation rules from application resurces");
            Enumeration<URL> urlEnumeration = ((Object)((Object)this)).getClass().getClassLoader().getResources(DEFAULT_NAVIGATION_PATH);
            if (urlEnumeration.hasMoreElements()) {
                URL url = urlEnumeration.nextElement();
                this.findAndUpdateNavigationRules(toPopulate, url.getPath());
            }
        }
        catch (Exception ex) {
            this.log.error("Failed to populate application configuraton", (Throwable)ex);
        }
    }

    private void findAndUpdateNavigationRules(Document toPopulate, String path) throws Exception {
        File file = new File(path);
        RegexFileFilter regexFileFilter = new RegexFileFilter(FACES_CONFIG_PATTERN);
        Collection facesConfigFiles = FileUtils.listFiles((File)file, (IOFileFilter)regexFileFilter, (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        this.log.debug("Found '{}' navigation rules files", (Object)facesConfigFiles.size());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        for (File files : facesConfigFiles) {
            String faceConfig = files.getAbsolutePath();
            this.updateDocument(toPopulate, builder, faceConfig);
            this.log.debug("Added navigation rules from {}", (Object)faceConfig);
        }
    }

    private void updateDocument(Document toPopulate, DocumentBuilder docBuilder, String faceConfig) {
        try {
            Document document = docBuilder.parse(new File(faceConfig));
            Element root = toPopulate.getDocumentElement();
            NodeList navigationRules = this.getNavigationRules(document);
            for (int i = 0; i < navigationRules.getLength(); ++i) {
                Node importedNode = toPopulate.importNode(navigationRules.item(i), true);
                root.appendChild(importedNode);
            }
        }
        catch (Exception ex) {
            this.log.error("Failed to update navigation rules", (Throwable)ex);
        }
    }

    private NodeList getNavigationRules(Document document) {
        String namespace = document.getDocumentElement().getNamespaceURI();
        return document.getDocumentElement().getElementsByTagNameNS(namespace, NAVIGATION_RULE);
    }
}

